/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.search.aggregate;

import com.dell.doradus.search.aggregate.ValueConverter;
import java.lang.reflect.Method;

class CaseConverter
implements ValueConverter {
    Method m_toCaseMethod;

    CaseConverter(Method toCaseMethod) {
        this.m_toCaseMethod = toCaseMethod;
    }

    @Override
    public String convert(String value) {
        try {
            return (String)this.m_toCaseMethod.invoke(null, value);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String toUPPERCase(String value) {
        return value.toUpperCase();
    }

    public static String toLOWERCase(String value) {
        return value.toLowerCase();
    }

    public static ValueConverter getConverter(String parameter) {
        parameter = parameter.toUpperCase();
        String methodName = String.format("to%sCase", parameter);
        try {
            Method method = CaseConverter.class.getMethod(methodName, String.class);
            return new CaseConverter(method);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Illegal CASE parameter: " + parameter);
        }
    }
}

