/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.search.aggregate;

import com.dell.doradus.search.aggregate.AverageGroup;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;

class BigIntegerAverageGroup
extends AverageGroup {
    private BigInteger m_value = BigInteger.ZERO;

    BigIntegerAverageGroup(String key) {
        super(key);
    }

    @Override
    void doUpdate(String value) {
        this.m_value = this.m_value.add(new BigInteger(value));
    }

    @Override
    Object getResult() {
        BigInteger result = this.m_value.divide(BigInteger.valueOf(this.m_count));
        int digits = result.abs().toString().length();
        MathContext mc = new MathContext(digits + 3);
        return new BigDecimal(this.m_value).divide(new BigDecimal(this.m_count), mc);
    }

    @Override
    Object getValue() {
        return this.m_value;
    }
}

