/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.search.aggregate;

import com.dell.doradus.common.Utils;
import com.dell.doradus.search.aggregate.ValueConverter;
import java.util.Date;
import java.util.List;

abstract class BatchConverter<E>
implements ValueConverter {
    List<E> m_backetValues;
    String[] m_backets;

    public static ValueConverter getConverter(List backetValues) {
        if (backetValues.get(0) instanceof Integer) {
            return new BatchConverter<Integer>(backetValues){

                @Override
                public Integer StringToValue(String value) {
                    try {
                        return Integer.parseInt(value);
                    }
                    catch (NumberFormatException ex) {
                        throw new IllegalArgumentException("Invalid integer format");
                    }
                }

                @Override
                public int Compare(Integer value1, Integer value2) {
                    return value1.compareTo(value2);
                }
            };
        }
        if (backetValues.get(0) instanceof Long) {
            return new BatchConverter<Long>(backetValues){

                @Override
                public Long StringToValue(String value) {
                    try {
                        return Long.parseLong(value);
                    }
                    catch (NumberFormatException ex) {
                        throw new IllegalArgumentException("Invalid long format");
                    }
                }

                @Override
                public int Compare(Long value1, Long value2) {
                    return value1.compareTo(value2);
                }
            };
        }
        if (backetValues.get(0) instanceof Float) {
            return new BatchConverter<Float>(backetValues){

                @Override
                public Float StringToValue(String value) {
                    try {
                        return Float.valueOf(Float.parseFloat(value));
                    }
                    catch (NumberFormatException ex) {
                        throw new IllegalArgumentException("Invalid float format");
                    }
                }

                @Override
                public int Compare(Float value1, Float value2) {
                    return value1.compareTo(value2);
                }
            };
        }
        if (backetValues.get(0) instanceof Double) {
            return new BatchConverter<Double>(backetValues){

                @Override
                public Double StringToValue(String value) {
                    try {
                        return Double.parseDouble(value);
                    }
                    catch (NumberFormatException ex) {
                        throw new IllegalArgumentException("Invalid double format");
                    }
                }

                @Override
                public int Compare(Double value1, Double value2) {
                    return value1.compareTo(value2);
                }
            };
        }
        if (backetValues.get(0) instanceof Date) {
            return new BatchConverter<Date>(backetValues){

                @Override
                public String ValueToString(Date value) {
                    return Utils.formatDateUTC((long)value.getTime());
                }

                @Override
                public Date StringToValue(String value) {
                    return Utils.dateFromString((String)value);
                }

                @Override
                public int Compare(Date value1, Date value2) {
                    return value1.compareTo(value2);
                }
            };
        }
        if (backetValues.get(0) instanceof String) {
            return new BatchConverter<String>(backetValues){

                @Override
                public String StringToValue(String value) {
                    return value;
                }

                @Override
                public int Compare(String value1, String value2) {
                    return value1.compareTo(value2);
                }
            };
        }
        return null;
    }

    BatchConverter(List<E> backetValues) {
        this.m_backetValues = backetValues;
        this.m_backets = new String[this.m_backetValues.size() + 1];
        this.m_backets[0] = "<" + this.ValueToString(this.m_backetValues.get(0));
        int i = 0;
        while (i < this.m_backetValues.size() - 1) {
            this.m_backets[i + 1] = String.valueOf(this.ValueToString(this.m_backetValues.get(i))) + "-" + this.ValueToString(this.m_backetValues.get(i + 1));
            ++i;
        }
        this.m_backets[this.m_backets.length - 1] = ">=" + this.ValueToString(this.m_backetValues.get(this.m_backetValues.size() - 1));
    }

    public String ValueToString(E value) {
        return value.toString();
    }

    public abstract E StringToValue(String var1) throws IllegalArgumentException;

    public abstract int Compare(E var1, E var2);

    @Override
    public String convert(String value) {
        try {
            E typeValue = this.StringToValue(value);
            int i = 0;
            while (i < this.m_backetValues.size()) {
                if (this.Compare(typeValue, this.m_backetValues.get(i)) < 0) {
                    return this.m_backets[i];
                }
                ++i;
            }
            return this.m_backets[this.m_backets.length - 1];
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
    }
}

