/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.search.aggregate;

import com.dell.doradus.common.AggregateResult;
import com.dell.doradus.common.FieldType;
import com.dell.doradus.common.TableDefinition;
import com.dell.doradus.common.UNode;
import com.dell.doradus.common.Utils;
import com.dell.doradus.core.ObjectID;
import com.dell.doradus.core.ServerConfig;
import com.dell.doradus.search.QueryExecutor;
import com.dell.doradus.search.aggregate.AggregationGroup;
import com.dell.doradus.search.aggregate.AggregationGroupItem;
import com.dell.doradus.search.aggregate.AggregationMetric;
import com.dell.doradus.search.aggregate.AverageGroup;
import com.dell.doradus.search.aggregate.BatchConverter;
import com.dell.doradus.search.aggregate.CountGroup;
import com.dell.doradus.search.aggregate.DBEntitySequenceFactory;
import com.dell.doradus.search.aggregate.Entity;
import com.dell.doradus.search.aggregate.EntitySequence;
import com.dell.doradus.search.aggregate.Group;
import com.dell.doradus.search.aggregate.GroupPath;
import com.dell.doradus.search.aggregate.GroupSetEntry;
import com.dell.doradus.search.aggregate.LinkInfo;
import com.dell.doradus.search.aggregate.MaxMinHelper;
import com.dell.doradus.search.aggregate.MetricExpression;
import com.dell.doradus.search.aggregate.MetricPath;
import com.dell.doradus.search.aggregate.NullGroup;
import com.dell.doradus.search.aggregate.PathEntry;
import com.dell.doradus.search.aggregate.ValueConverter;
import com.dell.doradus.search.parser.AggregationQueryBuilder;
import com.dell.doradus.utilities.Timer;
import com.dell.doradus.utilities.TimerGroup;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Aggregate {
    public static final String GROUPSEPARATOR = "\u0000";
    private boolean separateSearchTiming = false;
    static Logger log = LoggerFactory.getLogger((String)Aggregate.class.getSimpleName());
    TimerGroup timers = new TimerGroup(String.valueOf(Aggregate.class.getSimpleName()) + ".timing");
    String m_mParamValue;
    String m_query;
    String m_fParamValue;
    MetricPath[] m_metricPaths;
    ArrayList<ArrayList<AggregationGroup>> m_groups;
    GroupSetEntry[] m_groupSet;
    boolean m_isComposite;
    private boolean m_showGroupSets;
    private long m_totalObjects = -1L;
    TableDefinition m_tableDef;
    int m_indent = 0;
    private boolean m_l2rEnable;

    public Aggregate(TableDefinition tableDef) {
        assert (tableDef != null);
        this.m_tableDef = tableDef;
        this.m_groupSet = new GroupSetEntry[0];
        ServerConfig config = ServerConfig.getInstance();
        this.separateSearchTiming = config.aggr_separate_search;
        this.m_l2rEnable = config.l2r_enable;
    }

    public void execute() throws IOException {
        int i;
        GroupSetEntry groupSetEntry;
        Utils.require((this.m_metricPaths != null && this.m_metricPaths.length != 0 ? 1 : 0) != 0, (String)"Metric ('m') parameter is required");
        ArrayList allfieldNames = new ArrayList();
        GroupSetEntry[] groupSetEntryArray = this.m_groupSet;
        int n = this.m_groupSet.length;
        int n2 = 0;
        while (n2 < n) {
            GroupSetEntry groupSetEntry2 = groupSetEntryArray[n2];
            GroupPath[] groupPathArray = groupSetEntry2.m_groupPaths;
            int n3 = groupSetEntry2.m_groupPaths.length;
            int n4 = 0;
            while (n4 < n3) {
                GroupPath groupPath = groupPathArray[n4];
                this.preserveGroupLink(groupPath, true);
                groupSetEntry2.m_metricPath.addGroupPath(groupPath);
                ++n4;
            }
            this.preserveGroupLink(groupSetEntry2.m_metricPath, false);
            allfieldNames.addAll(groupSetEntry2.m_metricPath.fieldNames);
            if (groupSetEntry2.m_isComposite) {
                groupSetEntry2.m_compositeGroup = groupSetEntry2.m_totalGroup.createSubgroup("\u0000*");
            }
            ++n2;
        }
        ArrayList<String> fieldNames = new ArrayList<String>(new HashSet(allfieldNames));
        String queryText = this.m_query;
        if (queryText == null) {
            queryText = "*";
        }
        ArrayList<Integer> iGroupSet2Skip = new ArrayList<Integer>();
        if (queryText.equals("*")) {
            int i2 = 0;
            while (i2 < this.m_groupSet.length) {
                if (this.m_groupSet[i2].m_groupPathsParam == null && this.m_groupSet[i2].m_metricPath.branches.size() == 0 && this.m_groupSet[i2].m_metricPath.fieldType == FieldType.TIMESTAMP) {
                    Date date = null;
                    if (this.m_groupSet[i2].m_metricPath.function.equals("MAX")) {
                        date = MaxMinHelper.getMaxDate(this.m_tableDef, this.m_groupSet[i2].m_metricPath.name);
                    } else if (this.m_groupSet[i2].m_metricPath.function.equals("MIN")) {
                        date = MaxMinHelper.getMinDate(this.m_tableDef, this.m_groupSet[i2].m_metricPath.name);
                    }
                    if (date != null) {
                        this.m_groupSet[i2].m_totalGroup.update(Utils.formatDateUTC((long)date.getTime()));
                        iGroupSet2Skip.add(i2);
                    }
                }
                ++i2;
            }
        }
        if (iGroupSet2Skip.size() == this.m_groupSet.length) {
            return;
        }
        Timer searchTimer = new Timer();
        this.timers.start("Search");
        QueryExecutor executor = new QueryExecutor(this.m_tableDef);
        executor.setL2rEnabled(this.m_l2rEnable);
        Iterable<ObjectID> hits = executor.search(queryText);
        if (this.separateSearchTiming) {
            ArrayList<ObjectID> hitList = new ArrayList<ObjectID>();
            for (ObjectID id : hits) {
                hitList.add(id);
            }
            hits = hitList;
            this.timers.stop("Search");
            log.debug("Search '{}' took {}", new Object[]{queryText, searchTimer});
        }
        this.timers.start("Aggregating");
        DBEntitySequenceFactory factory = new DBEntitySequenceFactory();
        EntitySequence collection = factory.getSequence(this.m_tableDef, hits, fieldNames);
        ArrayList<HashSet[]> groupKeysSet = new ArrayList<HashSet[]>();
        GroupSetEntry[] groupSetEntryArray2 = this.m_groupSet;
        int n5 = this.m_groupSet.length;
        int n6 = 0;
        while (n6 < n5) {
            groupSetEntry = groupSetEntryArray2[n6];
            HashSet[] groupKeys = new HashSet[groupSetEntry.m_groupPaths.length];
            int i3 = 0;
            while (i3 < groupKeys.length) {
                groupKeys[i3] = new HashSet();
                ++i3;
            }
            groupKeysSet.add(groupKeys);
            ++n6;
        }
        this.m_totalObjects = 0L;
        for (Entity obj : collection) {
            ++this.m_totalObjects;
            i = 0;
            while (i < this.m_groupSet.length) {
                if (!iGroupSet2Skip.contains(i)) {
                    this.process(obj, this.m_groupSet[i].m_metricPath, this.m_groupSet[i], (Set[])groupKeysSet.get(i));
                }
                ++i;
            }
        }
        groupSetEntryArray2 = this.m_groupSet;
        i = this.m_groupSet.length;
        int n7 = 0;
        while (n7 < i) {
            groupSetEntry = groupSetEntryArray2[n7];
            boolean useNullGroup = !groupSetEntry.m_metricPath.function.equals("COUNT");
            this.addEmptyGroups(groupSetEntry.m_totalGroup, groupSetEntry.m_groupPaths, 0, useNullGroup);
            if (groupSetEntry.m_isComposite) {
                this.addEmptyGroups(groupSetEntry.m_compositeGroup, groupSetEntry.m_groupPaths, 1, useNullGroup);
            }
            ++n7;
        }
        if (this.m_metricPaths.length > 1 && this.m_groups != null) {
            int cMetrics = this.m_metricPaths.length;
            int cGroups = this.m_groups.size();
            int ig = 0;
            while (ig < cGroups) {
                GroupSetEntry groupSetEntry3 = this.m_groupSet[ig];
                if (groupSetEntry3.m_groupPaths[0].groupOutputParameters.function == AggregationGroup.Selection.Top || groupSetEntry3.m_groupPaths[0].groupOutputParameters.function == AggregationGroup.Selection.Bottom) {
                    ArrayList<Group> definedgroups = new ArrayList<Group>();
                    int im = 1;
                    while (im < cMetrics) {
                        definedgroups.add(this.m_groupSet[im * cGroups + ig].m_totalGroup);
                        ++im;
                    }
                    this.defineGroupsSelection(this.m_groupSet[ig].m_totalGroup, this.m_groupSet[ig].m_groupPaths, 0, definedgroups);
                }
                ++ig;
            }
        }
        factory.timers.log();
        this.timers.stop("Aggregating");
        this.timers.log("Aggregate '%s'", this.m_mParamValue);
    }

    private void preserveGroupLink(PathEntry entry, boolean preserve) {
        if (entry.branches.size() == 0) {
            if (entry.name.startsWith("*")) {
                entry.name = preserve ? String.valueOf(entry.name) + entry.groupIndex : "*";
            }
        } else {
            for (PathEntry child : entry.branches) {
                this.preserveGroupLink(child, preserve);
            }
        }
    }

    private void process(Entity obj, PathEntry entry, GroupSetEntry groupSetEntry, Set<String>[] groupKeys) {
        for (int groupIndex : entry.groupIndexes) {
            groupKeys[groupIndex].clear();
        }
        this.collectGroupValues(obj, entry, groupSetEntry, groupKeys);
        for (int groupIndex : entry.groupIndexes) {
            if (groupKeys[groupIndex].size() != 0) continue;
            return;
        }
        if (entry.query != null && !entry.checkCondition(obj)) {
            return;
        }
        if (entry.isLink) {
            for (Entity linkedObject : obj.getLinkedEntities(entry.name, entry.fieldNames)) {
                this.process(linkedObject, entry.branches.get(0), groupSetEntry, groupKeys);
            }
        } else if (entry.name == "*") {
            this.updateMetric(obj.id().toString(), groupSetEntry, groupKeys);
        } else {
            String[] values;
            String[] stringArray;
            String value = obj.get(entry.name);
            if (value == null) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = value;
            } else {
                stringArray = value.split("\ufffe");
            }
            String[] stringArray3 = values = stringArray;
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                String collectionValue = stringArray3[n2];
                for (Integer groupIndex : entry.matchingGroupIndexes) {
                    groupKeys[groupIndex].clear();
                    groupSetEntry.m_groupPaths[groupIndex].addValueKeys(groupKeys[groupIndex], collectionValue);
                }
                this.updateMetric(collectionValue, groupSetEntry, groupKeys);
                ++n2;
            }
        }
    }

    private void collectGroupValues(Entity obj, PathEntry entry, GroupSetEntry groupSetEntry, Set<String>[] groupKeys) {
        if (entry.query != null) {
            this.timers.start("Where", entry.queryText);
            boolean result = entry.checkCondition(obj);
            this.timers.stop("Where", entry.queryText, result ? 1 : 0);
            if (!result) {
                return;
            }
        }
        for (PathEntry field : entry.leafBranches) {
            String[] values;
            String fieldName = field.name;
            int groupIndex = field.groupIndex;
            if (fieldName == "*") {
                groupSetEntry.m_groupPaths[groupIndex].addValueKeys(groupKeys[groupIndex], obj.id().toString());
                continue;
            }
            String value = obj.get(fieldName);
            if (value == null || value.indexOf("\ufffe") == -1) {
                groupSetEntry.m_groupPaths[groupIndex].addValueKeys(groupKeys[groupIndex], value);
                continue;
            }
            String[] stringArray = values = value.split("\ufffe");
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                String collectionValue = stringArray[n2];
                groupSetEntry.m_groupPaths[groupIndex].addValueKeys(groupKeys[groupIndex], collectionValue);
                ++n2;
            }
        }
        for (PathEntry child : entry.linkBranches) {
            boolean hasLinkedEntities = false;
            if (child.nestedLinks == null || child.nestedLinks.size() == 0) {
                for (Entity linkedObj : obj.getLinkedEntities(child.name, child.fieldNames)) {
                    hasLinkedEntities = true;
                    this.collectGroupValues(linkedObj, child, groupSetEntry, groupKeys);
                }
            } else {
                for (LinkInfo linkInfo : child.nestedLinks) {
                    for (Entity linkedObj : obj.getLinkedEntities(linkInfo.name, child.fieldNames)) {
                        hasLinkedEntities = true;
                        this.collectGroupValues(linkedObj, child, groupSetEntry, groupKeys);
                    }
                }
            }
            if (hasLinkedEntities || child.hasUnderlyingQuery()) continue;
            this.nullifyGroupKeys(child, groupSetEntry, groupKeys);
        }
    }

    private void nullifyGroupKeys(PathEntry entry, GroupSetEntry groupSetEntry, Set<String>[] groupKeys) {
        for (PathEntry field : entry.leafBranches) {
            int groupIndex = field.groupIndex;
            groupSetEntry.m_groupPaths[groupIndex].addValueKeys(groupKeys[groupIndex], null);
        }
        for (PathEntry child : entry.linkBranches) {
            this.nullifyGroupKeys(child, groupSetEntry, groupKeys);
        }
    }

    private void updateMetric(String value, GroupSetEntry groupSetEntry, Set<String>[] groupKeys) {
        this.updateMetric(value, groupSetEntry.m_totalGroup, groupKeys, 0);
        if (groupSetEntry.m_isComposite) {
            this.updateMetric(value, groupSetEntry.m_compositeGroup, groupKeys, groupKeys.length - 1);
        }
    }

    private synchronized void updateMetric(String value, Group group, Set<String>[] groupKeys, int index) {
        group.update(value);
        if (index < groupKeys.length) {
            for (String key : groupKeys[index]) {
                Group subgroup = group.subgroup(key);
                this.updateMetric(value, subgroup, groupKeys, index + 1);
            }
        }
    }

    private void addEmptyGroups(Group group, GroupPath[] groupPathes, int groupPathIndex, boolean useNullGroup) {
        if (group.m_subgroups == null) {
            return;
        }
        for (Group subgroup : group.m_subgroups.values()) {
            this.addEmptyGroups(subgroup, groupPathes, groupPathIndex + 1, useNullGroup);
        }
        GroupPath groupPath = groupPathes[groupPathIndex];
        if (groupPath.converters != null) {
            for (ValueConverter converter : groupPath.converters) {
                if (!(converter instanceof BatchConverter)) continue;
                BatchConverter batchConverter = (BatchConverter)converter;
                String[] stringArray = batchConverter.m_backets;
                int n = batchConverter.m_backets.length;
                int n2 = 0;
                while (n2 < n) {
                    String backet = stringArray[n2];
                    if (!group.m_subgroups.containsKey(backet)) {
                        group.m_subgroups.put(backet, useNullGroup ? new NullGroup(backet) : new CountGroup(backet));
                    }
                    ++n2;
                }
            }
        }
    }

    private void defineGroupsSelection(Group group, GroupPath[] groupPaths, int index, List<Group> definedgroups) {
        ArrayList<String> groupkeys = new ArrayList<String>();
        for (Group subgroup : group.subgroups(groupPaths[index].groupOutputParameters)) {
            groupkeys.add(subgroup.m_key);
        }
        group.defineGroupsSelection(groupkeys);
        if (definedgroups != null) {
            for (Group definedgroup : definedgroups) {
                if (definedgroup == null) continue;
                definedgroup.defineGroupsSelection(groupkeys);
            }
        }
        if (++index < groupPaths.length) {
            for (Group subgroup : group.m_subgroups.values()) {
                ArrayList<Group> definedsubgroups = new ArrayList<Group>();
                for (Group definedgroup : definedgroups) {
                    if (definedgroup == null) continue;
                    definedsubgroups.add(definedgroup.m_subgroups.get(subgroup.m_key));
                }
                this.defineGroupsSelection(subgroup, groupPaths, index, definedsubgroups);
            }
        }
    }

    private void parseParam_m(String paramValue) {
        this.m_mParamValue = paramValue;
        ArrayList<MetricExpression> me = AggregationQueryBuilder.BuildAggregationMetricsExpression(this.m_mParamValue, this.m_tableDef);
        for (MetricExpression m : me) {
            Utils.require((boolean)(m instanceof AggregationMetric), (String)"Metric expressions are not supported in Spider service");
        }
        ArrayList<AggregationMetric> metrics = AggregationQueryBuilder.BuildAggregationMetrics(this.m_mParamValue, this.m_tableDef);
        this.m_metricPaths = new MetricPath[metrics.size()];
        int i = 0;
        while (i < metrics.size()) {
            AggregationMetric metric = (AggregationMetric)metrics.get(i);
            if (metric.items == null) {
                metric.items = new ArrayList<AggregationGroupItem>(1);
                AggregationGroupItem item = new AggregationGroupItem();
                item.tableDef = this.m_tableDef;
                item.name = "*";
                item.isLink = false;
                metric.items.add(item);
            }
            this.m_metricPaths[i] = new MetricPath(metric);
            ++i;
        }
    }

    private void parseParam_q(String paramValue) {
        this.m_query = paramValue;
    }

    private void parseParam_f(String paramValue) {
        this.m_fParamValue = paramValue;
        this.m_groups = AggregationGroup.GetAggregationList(this.m_fParamValue, this.m_tableDef);
    }

    private void parseParam_cf(String paramValue) {
        this.parseParam_f(paramValue);
        this.m_isComposite = true;
    }

    private void parseParam_l2r(String paramValue) {
        this.m_l2rEnable = "true".equals(paramValue);
    }

    private void parseParameters(String[] queryParts) throws IllegalArgumentException {
        HashSet<String> parsedParams = new HashSet<String>();
        String[] stringArray = queryParts;
        int n = queryParts.length;
        int n2 = 0;
        while (n2 < n) {
            String queryPart = stringArray[n2];
            int eqInx = queryPart.indexOf(61);
            Utils.require((eqInx > 0 ? 1 : 0) != 0, (String)("Query parameter missing '=': " + queryPart));
            String paramCode = queryPart.substring(0, eqInx);
            String paramValue = queryPart.substring(eqInx + 1);
            if (!parsedParams.add(paramCode)) {
                Aggregate.abortParsing("Query parameter can only be specified once: " + queryPart);
            }
            switch (paramCode) {
                case "cf": {
                    this.parseParam_cf(paramValue);
                    break;
                }
                case "f": {
                    this.parseParam_f(paramValue);
                    this.m_groups = AggregationGroup.GetAggregationList(this.m_fParamValue, this.m_tableDef);
                    break;
                }
                case "l2r": {
                    this.parseParam_l2r(paramValue);
                    break;
                }
                case "m": {
                    this.parseParam_m(paramValue);
                    break;
                }
                case "q": {
                    this.parseParam_q(paramValue);
                    break;
                }
                default: {
                    Aggregate.abortParsing("Illegal query parameter: " + queryPart);
                }
            }
            ++n2;
        }
    }

    private void buildContext() throws IllegalArgumentException {
        this.m_showGroupSets = this.m_metricPaths.length > 1 || this.m_groups != null && this.m_groups.size() > 1 || this.m_fParamValue != null && Pattern.matches("GROUP\\(.+\\)", this.m_fParamValue.toUpperCase());
        int cGroups = 1;
        if (this.m_groups != null) {
            cGroups = this.m_groups.size();
        }
        this.m_groupSet = new GroupSetEntry[this.m_metricPaths.length * cGroups];
        int im = 0;
        while (im < this.m_metricPaths.length) {
            int ig = 0;
            while (ig < cGroups) {
                int i = im * cGroups + ig;
                this.m_groupSet[i] = new GroupSetEntry();
                if (this.m_groups == null) {
                    this.m_groupSet[i].m_groupPaths = new GroupPath[0];
                } else {
                    List aggregationGroups = this.m_groups.get(ig);
                    StringBuilder groupPathsParam = new StringBuilder();
                    this.m_groupSet[i].m_groupPaths = new GroupPath[aggregationGroups.size()];
                    if (aggregationGroups.size() > 0) {
                        int j = 0;
                        while (j < aggregationGroups.size()) {
                            groupPathsParam = groupPathsParam.append(((AggregationGroup)aggregationGroups.get((int)j)).text).append(',');
                            this.m_groupSet[i].m_groupPaths[j] = GroupPath.createGroupPath(this.m_tableDef, (AggregationGroup)aggregationGroups.get(j), j);
                            ++j;
                        }
                        this.m_groupSet[i].m_groupPathsParam = groupPathsParam.deleteCharAt(groupPathsParam.length() - 1).toString();
                    }
                }
                MetricPath metricPath = this.m_metricPaths[im];
                this.m_groupSet[i].m_metricPath = new MetricPath(metricPath.metric);
                this.m_groupSet[i].m_totalGroup = Group.getGroup(metricPath.function, metricPath.fieldType);
                ++ig;
            }
            ++im;
        }
        if (this.m_isComposite) {
            GroupSetEntry[] groupSetEntryArray = this.m_groupSet;
            int n = this.m_groupSet.length;
            int n2 = 0;
            while (n2 < n) {
                GroupSetEntry groupSetEntry = groupSetEntryArray[n2];
                if (groupSetEntry.m_groupPaths.length >= 2) {
                    groupSetEntry.m_isComposite = true;
                }
                ++n2;
            }
        }
    }

    public void parseParameters(UNode rootNode) {
        Utils.require((boolean)rootNode.getName().equals("aggregate-search"), (String)("Root node must be 'aggregate-search': " + rootNode));
        StringBuilder uriQuery = new StringBuilder();
        for (String childName : rootNode.getMemberNames()) {
            UNode childNode = rootNode.getMember(childName);
            Utils.require((boolean)childNode.isValue(), (String)("Elements of 'aggregate-search' must be values: " + childNode));
            if (uriQuery.length() > 0) {
                uriQuery.append('&');
            }
            if (childName.equals("query")) {
                uriQuery.append("q=");
            } else if (childName.equals("metric")) {
                uriQuery.append("m=");
            } else if (childName.equals("grouping-fields")) {
                uriQuery.append("f=");
            } else if (childName.equals("composite-fields")) {
                uriQuery.append("cf=");
            } else if (childName.equals("pair")) {
                uriQuery.append("pair=");
            } else {
                Utils.require((boolean)false, (String)("Unknown 'aggregate-search' parameter: " + childName));
            }
            uriQuery.append(Utils.urlEncode((String)childNode.getValue()));
        }
        this.parseParameters(uriQuery.toString());
    }

    public void parseParameters(String uriQuery) {
        this.parseParameters(Utils.splitURIQuery((String)uriQuery));
        Utils.require((this.m_metricPaths != null && this.m_metricPaths.length != 0 ? 1 : 0) != 0, (String)"Metric ('m') parameter is required");
        this.buildContext();
    }

    public void parseParameters(String metricParam, String queryParam, String groupParam) {
        Utils.require((metricParam != null && !metricParam.isEmpty() ? 1 : 0) != 0, (String)"Metric parameter is required");
        this.parseParam_m(metricParam);
        if (queryParam != null && !queryParam.isEmpty()) {
            this.parseParam_q(queryParam);
        }
        if (groupParam != null && !groupParam.isEmpty()) {
            this.parseParam_f(groupParam);
        }
        this.buildContext();
    }

    static void abortParsing(String message) {
        throw new IllegalArgumentException(message);
    }

    public String[] getGroupNames() {
        if (this.m_fParamValue == null || this.m_fParamValue.isEmpty()) {
            return null;
        }
        GroupSetEntry groupSetEntry = this.m_groupSet[0];
        String[] groupName = new String[groupSetEntry.m_groupPaths.length];
        int i = 0;
        while (i < groupName.length) {
            groupName[i] = groupSetEntry.m_groupPaths[i].name;
            ++i;
        }
        return groupName;
    }

    public boolean isAverageMetric() {
        GroupSetEntry groupSetEntry = this.m_groupSet[0];
        return groupSetEntry.m_totalGroup instanceof AverageGroup;
    }

    public StatisticResult getStatisticResult(String statisticName) throws IOException {
        StatisticResult result = null;
        GroupSetEntry groupSetEntry = this.m_groupSet[0];
        if (groupSetEntry.m_totalGroup instanceof AverageGroup) {
            result = new AverageStatistic();
            String key = String.valueOf(this.m_tableDef.getTableName()) + "/" + statisticName;
            result.setFieldName(String.valueOf(key) + "." + "COUNT");
            ((AverageStatistic)result).setSumFieldName(String.valueOf(key) + "." + "SUM");
        } else {
            result = new StatisticResult();
            result.setFieldName(String.valueOf(this.m_tableDef.getTableName()) + "/" + statisticName);
        }
        if (groupSetEntry.m_totalGroup.m_subgroups == null) {
            this.putValue(result, "value", groupSetEntry.m_totalGroup);
        }
        if (groupSetEntry.m_totalGroup.m_subgroups != null) {
            for (Group group : groupSetEntry.m_totalGroup.subgroups(groupSetEntry.m_groupPaths[0].groupOutputParameters)) {
                this.getGroupResult(result, group, groupSetEntry, 0, group.getDisplayName());
            }
            this.putValue(result, "\uefffsummary", groupSetEntry.m_totalGroup);
        }
        if (groupSetEntry.m_isComposite && groupSetEntry.m_compositeGroup.m_subgroups != null) {
            this.getCompositeGroupResult(result, groupSetEntry.m_compositeGroup, groupSetEntry, groupSetEntry.m_groupPaths.length - 1, groupSetEntry.m_groupPaths[0].path);
        }
        return result;
    }

    private void putValue(StatisticResult result, String columnName, Group metricValue) {
        if (result instanceof AverageStatistic) {
            AverageGroup avarrage = (AverageGroup)metricValue;
            result.addValue(new AbstractMap.SimpleEntry<String, Object>(columnName, avarrage.m_count));
            ((AverageStatistic)result).addSumValue(new AbstractMap.SimpleEntry<String, Object>(columnName, avarrage.getValue()));
        } else {
            result.addValue(new AbstractMap.SimpleEntry<String, Object>(columnName, metricValue.getMetric()));
        }
    }

    private void getGroupResult(StatisticResult result, Group group, GroupSetEntry groupSetEntry, int groupPathIndex, String parentName) throws IOException {
        if (group.m_subgroups != null) {
            for (Group subgroup : group.subgroups(groupSetEntry.m_groupPaths[groupPathIndex + 1].groupOutputParameters)) {
                String groupName = String.valueOf(parentName) + GROUPSEPARATOR + subgroup.getDisplayName();
                this.getGroupResult(result, subgroup, groupSetEntry, groupPathIndex + 1, groupName);
                this.putValue(result, String.valueOf(parentName) + GROUPSEPARATOR + "\uefffsummary", group);
            }
        } else {
            this.putValue(result, parentName, group);
        }
    }

    private void getCompositeGroupResult(StatisticResult result, Group group, GroupSetEntry groupSetEntry, int groupPathIndex, String parentName) throws IOException {
        if (group.m_subgroups != null) {
            for (Group subgroup : group.subgroups(groupSetEntry.m_groupPaths[groupPathIndex].groupOutputParameters)) {
                this.getGroupResult(result, subgroup, groupSetEntry, groupPathIndex, parentName);
            }
        }
    }

    public AggregateResult getResult() {
        AggregateResult aggResult = new AggregateResult();
        aggResult.setMetricParam(this.m_mParamValue);
        if (this.m_query != null) {
            aggResult.setQueryParam(this.m_query);
        }
        if (this.m_fParamValue != null) {
            aggResult.setGroupingParam(this.m_fParamValue);
        }
        if (!this.m_showGroupSets && this.m_fParamValue == null) {
            aggResult.setGlobalValue(this.m_groupSet[0].m_totalGroup.getMetricValue());
        } else if (!this.m_showGroupSets) {
            this.addGroupSet(aggResult, this.m_groupSet[0], false);
            aggResult.setGlobalValue(this.m_groupSet[0].m_totalGroup.getMetricValue());
        } else {
            GroupSetEntry[] groupSetEntryArray = this.m_groupSet;
            int n = this.m_groupSet.length;
            int n2 = 0;
            while (n2 < n) {
                GroupSetEntry groupSetEntry = groupSetEntryArray[n2];
                this.addGroupSet(aggResult, groupSetEntry, true);
                ++n2;
            }
        }
        if (this.m_totalObjects != -1L) {
            aggResult.setTotalObjects(this.m_totalObjects);
        }
        return aggResult;
    }

    public UNode toDoc() {
        return this.getResult().toDoc();
    }

    private void addGroupSet(AggregateResult aggResult, GroupSetEntry groupSetEntry, boolean compound) {
        AggregateResult.AggGroupSet aggGroupSet = aggResult.addGroupSet();
        if (compound) {
            if (this.m_metricPaths.length > 1) {
                aggGroupSet.setMetricParam(groupSetEntry.m_metricPath.metric.sourceText);
            }
            if (groupSetEntry.m_groupPathsParam != null) {
                aggGroupSet.setGroupingParam(groupSetEntry.m_groupPathsParam);
            }
            aggGroupSet.setGroupsetValue(groupSetEntry.m_totalGroup.getMetricValue());
        }
        if (groupSetEntry.m_totalGroup.m_subgroups != null) {
            for (Group group : groupSetEntry.m_totalGroup.subgroups(groupSetEntry.m_groupPaths[0].groupOutputParameters)) {
                this.addGroup((AggregateResult.IAggGroupList)aggGroupSet, group, groupSetEntry, 0);
            }
            if (groupSetEntry.m_isComposite && groupSetEntry.m_compositeGroup.m_subgroups != null) {
                this.addCompositeGroup(aggGroupSet, groupSetEntry.m_compositeGroup, groupSetEntry, groupSetEntry.m_groupPaths[0].path, groupSetEntry.m_groupPaths.length - 1);
            }
        }
        if (groupSetEntry.m_totalGroup.m_subgroups != null && groupSetEntry.m_groupPaths[0].groupOutputParameters.count != 0) {
            aggGroupSet.setTotalGroups((long)groupSetEntry.m_totalGroup.m_subgroups.size());
        }
    }

    private void addGroup(AggregateResult.IAggGroupList aggGroupList, Group group, GroupSetEntry groupSetEntry, int groupPathIndex) {
        AggregateResult.AggGroup aggGroup = aggGroupList.addGroup();
        aggGroup.setFieldName(groupSetEntry.m_groupPaths[groupPathIndex].path);
        aggGroup.setFieldValue(group.getDisplayName());
        aggGroup.setGroupValue(group.getMetricValue());
        if (group.m_subgroups != null) {
            for (Group subgroup : group.subgroups(groupSetEntry.m_groupPaths[groupPathIndex + 1].groupOutputParameters)) {
                this.addGroup((AggregateResult.IAggGroupList)aggGroup, subgroup, groupSetEntry, groupPathIndex + 1);
            }
            if (groupSetEntry.m_groupPaths[groupPathIndex + 1].groupOutputParameters.count != 0) {
                aggGroup.setTotalGroups(new Long(group.m_subgroups.size()).longValue());
            }
        }
    }

    private void addCompositeGroup(AggregateResult.AggGroupSet aggGroupSet, Group group, GroupSetEntry groupSetEntry, String name, int groupPathIndex) {
        AggregateResult.AggGroup aggGroup = aggGroupSet.addGroup();
        aggGroup.setFieldName(name);
        aggGroup.setFieldValue(group.getDisplayName());
        aggGroup.setComposite(true);
        if (group.m_subgroups != null) {
            for (Group subgroup : group.subgroups(groupSetEntry.m_groupPaths[groupPathIndex].groupOutputParameters)) {
                this.addGroup((AggregateResult.IAggGroupList)aggGroup, subgroup, groupSetEntry, groupPathIndex);
            }
        }
    }

    public static class AverageStatistic
    extends StatisticResult {
        String additionalField;
        List<AbstractMap.SimpleEntry<String, Object>> additionalValues = new ArrayList<AbstractMap.SimpleEntry<String, Object>>();

        public String getCountFieldName() {
            return this.fieldName;
        }

        public String getSumFieldName() {
            return this.additionalField;
        }

        public void setSumFieldName(String sumFieldName) {
            this.additionalField = sumFieldName;
        }

        public Iterable<AbstractMap.SimpleEntry<String, Object>> getCountValues() {
            return this.values;
        }

        public Iterable<AbstractMap.SimpleEntry<String, Object>> getSumValues() {
            return this.additionalValues;
        }

        public void addSumValue(AbstractMap.SimpleEntry<String, Object> value) {
            this.additionalValues.add(value);
        }
    }

    public static class StatisticResult {
        public static final String COUNTKEY = "COUNT";
        public static final String SUMKEY = "SUM";
        public static final String VALUEKEY = "value";
        public static final String SUMMARY = "\uefffsummary";
        public static final String METRICKEY = "metric";
        public static final String KEYSEPARATOR = "/";
        public static final String AVERAGESEPARATOR = ".";
        public String fieldName;
        List<AbstractMap.SimpleEntry<String, Object>> values = new ArrayList<AbstractMap.SimpleEntry<String, Object>>();

        public String getFieldName() {
            return this.fieldName;
        }

        public void setFieldName(String fieldName) {
            this.fieldName = fieldName;
        }

        public Iterable<AbstractMap.SimpleEntry<String, Object>> getValues() {
            return this.values;
        }

        public void addValue(AbstractMap.SimpleEntry<String, Object> value) {
            this.values.add(value);
        }
    }
}

