/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.search;

import com.dell.doradus.common.FieldDefinition;
import com.dell.doradus.common.FieldType;
import com.dell.doradus.common.UNode;
import com.dell.doradus.common.Utils;
import com.dell.doradus.core.ObjectID;
import com.dell.doradus.olap.io.BSTR;
import com.dell.doradus.search.FieldSet;
import com.dell.doradus.search.SearchResultList;
import com.dell.doradus.search.aggregate.AggregationGroupItem;
import com.dell.doradus.search.aggregate.SortOrder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class SearchResult
implements Comparable<SearchResult> {
    public ObjectID id;
    public FieldSet fieldSet;
    public SortOrder[] orders;
    public TreeMap<String, String> scalars = new TreeMap();
    public TreeMap<String, List<SearchResultList>> links = new TreeMap();
    private List<List<BSTR>> sortKeys = null;

    public String id() {
        String ret = this.id != null ? this.id.toString() : this.scalars.get("_ID");
        return ret;
    }

    public UNode toDoc() {
        UNode docNode = UNode.createMapNode((String)"doc");
        for (Map.Entry<String, String> entry : this.scalars.entrySet()) {
            FieldDefinition fieldDef = this.fieldSet.tableDef.getFieldDef(entry.getKey());
            if (fieldDef != null && fieldDef.isCollection()) {
                UNode fieldNode = docNode.addArrayNode(entry.getKey(), "field");
                for (String value : Utils.splitSorted((String)entry.getValue(), (String)"\ufffe")) {
                    fieldNode.addValueNode("value", value);
                }
                continue;
            }
            docNode.addValueNode(entry.getKey(), entry.getValue(), "field");
        }
        for (Map.Entry<String, Object> entry : this.links.entrySet()) {
            List linkList = (List)entry.getValue();
            List<FieldSet> fsList = this.fieldSet.getLinks(entry.getKey());
            int i = 0;
            while (i < linkList.size()) {
                SearchResultList l = (SearchResultList)linkList.get(i);
                FieldSet fs = fsList.get(i);
                String linkKey = entry.getKey();
                if (fs.filter != null) {
                    linkKey = String.valueOf(linkKey) + ".WHERE(" + fs.filter + ")";
                }
                if (fs.alias != null) {
                    linkKey = fs.alias;
                }
                UNode linkNode = docNode.addArrayNode(linkKey, "field");
                if (l.results.size() > 0) {
                    for (SearchResult sr : l.results) {
                        linkNode.addChildNode(sr.toDoc());
                    }
                }
                ++i;
            }
        }
        return docNode;
    }

    private void loadSortKeys() {
        if (this.sortKeys != null) {
            return;
        }
        if (this.orders == null || this.orders.length == 0) {
            return;
        }
        this.sortKeys = new ArrayList<List<BSTR>>(this.orders.length);
        SortOrder[] sortOrderArray = this.orders;
        int n = this.orders.length;
        int n2 = 0;
        while (n2 < n) {
            SortOrder order = sortOrderArray[n2];
            HashSet<BSTR> sortValues = new HashSet<BSTR>();
            this.loadSortKey(order.items, 0, sortValues);
            ArrayList<BSTR> sortArray = new ArrayList<BSTR>(sortValues);
            Collections.sort(sortArray);
            this.sortKeys.add(sortArray);
            ++n2;
        }
    }

    private void loadSortKey(List<AggregationGroupItem> items, int index, Set<BSTR> sortedSet) {
        block16: {
            SearchResultList ch;
            AggregationGroupItem item;
            block14: {
                block15: {
                    SearchResultList ch2;
                    item = items.get(index);
                    if (index != items.size() - 1) break block14;
                    if (!item.fieldDef.isLinkField()) break block15;
                    List<SearchResultList> list = this.links.get(item.fieldDef.getName());
                    SearchResultList searchResultList = ch2 = list == null || list.size() == 0 ? null : list.get(0);
                    if (ch2 == null) break block16;
                    for (SearchResult sr : ch2.results) {
                        sortedSet.add(new BSTR(sr.id()));
                    }
                    break block16;
                }
                String s = this.scalars.get(item.fieldDef.getName());
                ArrayList<String> values = new ArrayList<String>();
                if (item.fieldDef.isCollection()) {
                    values.addAll(Utils.split((String)s, (String)"\ufffe"));
                } else {
                    values.add(s);
                }
                FieldType type = item.fieldDef.getType();
                if (type == FieldType.INTEGER || type == FieldType.LONG) {
                    for (String str : values) {
                        if (str == null) {
                            sortedSet.add(new BSTR());
                            continue;
                        }
                        long l = Long.parseLong(str);
                        sortedSet.add(new BSTR(l));
                    }
                } else if (type == FieldType.DOUBLE || type == FieldType.FLOAT) {
                    for (String str : values) {
                        if (str == null) {
                            sortedSet.add(new BSTR());
                            continue;
                        }
                        double d = Double.parseDouble(str);
                        sortedSet.add(new BSTR(d));
                    }
                } else {
                    for (String str : values) {
                        sortedSet.add(new BSTR(str == null ? "" : str.toLowerCase()));
                    }
                }
                break block16;
            }
            Utils.require((boolean)item.fieldDef.isLinkField(), (String)("in sort order " + item.fieldDef.getName() + " should be a link field"));
            List<SearchResultList> list = this.links.get(item.fieldDef.getName());
            SearchResultList searchResultList = ch = list == null || list.size() == 0 ? null : list.get(0);
            if (ch != null) {
                for (SearchResult sr : ch.results) {
                    sr.loadSortKey(items, index + 1, sortedSet);
                }
            }
        }
    }

    @Override
    public int compareTo(SearchResult o) {
        if (this.orders == null) {
            return this.id().compareTo(o.id());
        }
        this.loadSortKeys();
        o.loadSortKeys();
        int s = 0;
        while (s < this.sortKeys.size()) {
            int i;
            List<BSTR> x = this.sortKeys.get(s);
            List<BSTR> y = o.sortKeys.get(s);
            SortOrder order = this.orders[s];
            int minK = Math.min(x.size(), y.size());
            int c = 0;
            if (order == null || order.ascending) {
                i = 0;
                while (i < minK) {
                    c = x.get(i).compareTo(y.get(i));
                    if (c != 0) {
                        return c;
                    }
                    ++i;
                }
                c = Integer.compare(x.size(), y.size());
                if (c != 0) {
                    return c;
                }
            } else {
                i = minK - 1;
                while (i >= 0) {
                    c = x.get(i).compareTo(y.get(i));
                    if (c != 0) {
                        return -c;
                    }
                    --i;
                }
                c = Integer.compare(x.size(), y.size());
                if (c != 0) {
                    return -c;
                }
            }
            ++s;
        }
        return this.id().compareTo(o.id());
    }

    public String toString() {
        return this.toDoc().toXML(true);
    }
}

