/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.search;

import com.dell.doradus.common.TableDefinition;
import com.dell.doradus.core.ObjectID;
import com.dell.doradus.core.ServerConfig;
import com.dell.doradus.search.FieldSet;
import com.dell.doradus.search.FieldSetCreator;
import com.dell.doradus.search.IDHelper;
import com.dell.doradus.search.SearchParameters;
import com.dell.doradus.search.SearchResultList;
import com.dell.doradus.search.Searcher;
import com.dell.doradus.search.aggregate.DBEntitySequenceFactory;
import com.dell.doradus.search.aggregate.DBEntitySequenceOptions;
import com.dell.doradus.search.aggregate.EntitySequence;
import com.dell.doradus.search.aggregate.SortOrder;
import com.dell.doradus.search.filter.Filter;
import com.dell.doradus.search.parser.AggregationQueryBuilder;
import com.dell.doradus.search.parser.DoradusQueryBuilder;
import com.dell.doradus.search.query.Query;
import com.dell.doradus.utilities.TimerGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryExecutor {
    protected static Logger LOG = LoggerFactory.getLogger((String)QueryExecutor.class.getSimpleName());
    private TableDefinition m_table;
    private int m_pageSize;
    private int m_skip = 0;
    private SearchParameters m_parameters = new SearchParameters();

    public QueryExecutor(TableDefinition tableDef) {
        this.m_table = tableDef;
        this.m_pageSize = ServerConfig.getInstance().search_default_page_size;
    }

    public void setPageSize(int pageSize) {
        this.m_pageSize = pageSize;
    }

    public void setSkip(int skip) {
        this.m_skip = skip;
    }

    public void setContinueAfterID(String objectID) {
        this.m_parameters.continuation = IDHelper.createID(objectID);
        this.m_parameters.inclusive = false;
    }

    public void setContinueBeforeID(String objectID) {
        this.m_parameters.continuation = IDHelper.createID(objectID);
        this.m_parameters.inclusive = true;
    }

    public void setL2rEnabled(boolean l2rEnabled) {
        this.m_parameters.l2r = l2rEnabled;
    }

    public SearchResultList search(String query, String fields, String sortOrder) {
        if (sortOrder != null && this.m_parameters.continuation != null) {
            throw new IllegalArgumentException("Cannot use &g or &e parameters with &o parameter. To use paging please specify &k (skip) parameter instead");
        }
        TimerGroup timers = new TimerGroup("search.timing");
        timers.start("search");
        if (this.m_pageSize == 0) {
            this.m_pageSize = 0x7FFFFFFE;
        }
        FieldSet fieldSet = new FieldSet(this.m_table, fields);
        fieldSet.limit = this.m_pageSize;
        try {
            SearchResultList searchResultList;
            Iterable<ObjectID> iter = this.search(query);
            DBEntitySequenceOptions def = DBEntitySequenceOptions.defaultOptions;
            int p = this.m_pageSize;
            if (p < Integer.MAX_VALUE) {
                ++p;
            }
            DBEntitySequenceOptions options = new DBEntitySequenceOptions(Math.min(p, def.entityBuffer), Math.min(p, def.linkBuffer), Math.min(p, def.initialLinkBuffer), Math.min(p, def.initialLinkBufferDimension), Math.min(p, def.initialScalarBuffer));
            int cap = Math.min(p, 10000);
            DBEntitySequenceFactory factory = new DBEntitySequenceFactory(cap, cap, cap, options);
            SortOrder[] orders = AggregationQueryBuilder.BuildSortOrders(sortOrder, this.m_table);
            FieldSetCreator fieldSetCreator = new FieldSetCreator(fieldSet, orders);
            EntitySequence sequence = factory.getSequence(this.m_table, iter, fieldSetCreator.loadedFields);
            SearchResultList searchResultList2 = searchResultList = fieldSetCreator.create(sequence, this.m_skip);
            return searchResultList2;
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            timers.stop("search");
            timers.log("search", new Object[0]);
        }
    }

    public Iterable<ObjectID> search(String query) {
        Query qu = DoradusQueryBuilder.Build(query, this.m_table);
        return this.search(qu);
    }

    public Iterable<ObjectID> search(Query query) {
        LOG.debug("query: {}", (Object)query);
        Searcher s = new Searcher();
        return s.search(this.m_parameters, this.m_table, query);
    }

    public Filter filter(String query) {
        Query qu = DoradusQueryBuilder.Build(query, this.m_table);
        return this.filter(qu);
    }

    public Filter filter(Query query) {
        LOG.debug("query: {}", (Object)query);
        Searcher s = new Searcher();
        return s.filter(this.m_parameters, this.m_table, query);
    }
}

