/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.search;

import com.dell.doradus.common.FieldDefinition;
import com.dell.doradus.common.Utils;
import com.dell.doradus.core.ObjectID;
import java.nio.ByteBuffer;

public class IDHelper {
    public static ObjectID createID(String id) {
        return new ObjectID(id, ObjectID.IDFormat.UFT8);
    }

    public static String IDToString(ObjectID id) {
        if (id == null) {
            id = ObjectID.EMPTY;
        }
        return id.toString();
    }

    public static byte[] next(byte[] value) {
        byte[] next = new byte[value.length + 1];
        int i = 0;
        while (i < value.length) {
            next[i] = value[i];
            ++i;
        }
        next[value.length] = 0;
        return next;
    }

    public static byte[] idToBytes(ObjectID id) {
        if (id == null) {
            return ObjectID.EMPTY.bytes();
        }
        return id.bytes();
    }

    public static ObjectID bytesToId(byte[] bytes) {
        return new ObjectID(bytes, ObjectID.IDFormat.UFT8);
    }

    public static ObjectID bytesToId(ByteBuffer byteBuffer) {
        return IDHelper.bytesToId(Utils.getBytes((ByteBuffer)byteBuffer));
    }

    public static byte[] linkBoundMinimum(FieldDefinition link) {
        return IDHelper.linkToBytes(link, null);
    }

    public static byte[] linkBoundMaximum(FieldDefinition link) {
        return Utils.toBytes((String)("~" + link.getName() + "0"));
    }

    public static byte[] linkToBytes(FieldDefinition link, ObjectID id) {
        if (id == null) {
            id = ObjectID.EMPTY;
        }
        byte[] header = Utils.toBytes((String)("~" + link.getName() + "/"));
        return Utils.concatenate((byte[][])new byte[][]{header, id.bytes()});
    }

    public static ObjectID linkValueToId(byte[] value) {
        int offset = 0;
        while (value[offset] != 47) {
            ++offset;
        }
        byte[] lnk = new byte[value.length - ++offset];
        int i = 0;
        while (i < lnk.length) {
            lnk[i] = value[i + offset];
            ++i;
        }
        return new ObjectID(lnk, ObjectID.IDFormat.UFT8);
    }
}

