/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.search;

import com.dell.doradus.core.ObjectID;
import com.dell.doradus.search.aggregate.Entity;
import com.dell.doradus.search.filter.Filter;
import java.util.Iterator;

public class FilteredIterator
implements Iterator<ObjectID> {
    private Filter m_filter;
    private Iterator<Entity> m_sequence;
    private Entity m_next;

    public FilteredIterator(Filter filter, Iterator<Entity> sequence) {
        this.m_filter = filter;
        this.m_sequence = sequence;
        this.findNext();
    }

    @Override
    public ObjectID next() {
        Entity next = this.m_next;
        this.findNext();
        return next.id();
    }

    @Override
    public boolean hasNext() {
        return this.m_next != null;
    }

    @Override
    public void remove() {
        throw new RuntimeException("FilteredIterator does not support remove()");
    }

    private void findNext() {
        while (this.m_sequence.hasNext()) {
            this.m_next = this.m_sequence.next();
            if (this.m_filter != null && !this.m_filter.check(this.m_next)) continue;
            return;
        }
        this.m_next = null;
    }
}

