/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.search;

import com.dell.doradus.common.TableDefinition;
import com.dell.doradus.core.ObjectID;
import com.dell.doradus.search.FilteredIterator;
import com.dell.doradus.search.Searcher;
import com.dell.doradus.search.aggregate.EntitySequence;
import com.dell.doradus.search.filter.Filter;
import java.util.Iterator;
import java.util.List;

public class FilteredIterable
implements Iterable<ObjectID> {
    private Filter m_filter;
    private Iterable<ObjectID> m_sequence;
    private Searcher m_searcher;
    private TableDefinition m_table;
    private List<String> m_fields;

    public FilteredIterable(Searcher searcher, Filter filter, Iterable<ObjectID> sequence, TableDefinition table) {
        this.m_filter = filter;
        this.m_sequence = sequence;
        this.m_searcher = searcher;
        this.m_table = table;
        this.m_fields = Searcher.getFields(this.m_filter);
    }

    @Override
    public Iterator<ObjectID> iterator() {
        if (this.m_filter == null) {
            return this.m_sequence.iterator();
        }
        EntitySequence sequence = this.m_searcher.getSequence(this.m_table, this.m_sequence, this.m_fields);
        return new FilteredIterator(this.m_filter, sequence.iterator());
    }

    public Filter filter() {
        return this.m_filter;
    }

    public Iterable<ObjectID> sequence() {
        return this.m_sequence;
    }
}

