/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.search;

import com.dell.doradus.common.FieldDefinition;
import com.dell.doradus.common.TableDefinition;
import com.dell.doradus.search.FieldSet;
import com.dell.doradus.search.parser.AggregationQueryBuilder;
import com.dell.doradus.search.parser.FieldSetItem;
import com.dell.doradus.search.parser.FieldSetQueryBuilder;
import java.util.ArrayList;
import java.util.List;

class FieldSetTokenizer {
    public String text;
    public int position;
    public StringBuilder currentField = new StringBuilder();
    public FieldSet currentSet;

    public FieldSetTokenizer(FieldSet set, String text) {
        this.text = text;
        this.currentSet = set;
        this.position = 0;
        this.currentField.setLength(0);
    }

    private static List<FieldDefinition> GetFieldList(List<FieldDefinition> list, FieldDefinition fieldDef) {
        if (list == null) {
            list = new ArrayList<FieldDefinition>();
        }
        if (fieldDef != null && fieldDef.isGroupField()) {
            for (FieldDefinition nested : fieldDef.getNestedFields()) {
                list = FieldSetTokenizer.GetFieldList(list, nested);
            }
        } else {
            list.add(fieldDef);
        }
        return list;
    }

    private void Parse() {
        FieldSetItem root = FieldSetQueryBuilder.BuildFieldSet(this.text);
        int i = 0;
        while (i < root.children.size()) {
            FieldSetItem nextItem = root.children.get(i);
            FieldSetTokenizer.CreateItemSet(nextItem, this.currentSet.tableDef, this.currentSet);
            ++i;
        }
    }

    public static void CreateItemSet(FieldSetItem item, TableDefinition def, FieldSet set) {
        block14: {
            block12: {
                block13: {
                    if (def == null) break block12;
                    FieldDefinition fieldDef = def.getFieldDef(item.name);
                    if (fieldDef == null) break block13;
                    List<FieldDefinition> list = FieldSetTokenizer.GetFieldList(null, fieldDef);
                    int i = 0;
                    while (i < list.size()) {
                        FieldDefinition fieldDefinition = list.get(i);
                        FieldSet current = set;
                        if (!fieldDefinition.isLinkField() && item.children.size() > 0) {
                            throw new IllegalArgumentException(fieldDefinition + " is not a link");
                        }
                        if (fieldDefinition.isLinkField()) {
                            current = new FieldSet(def.getLinkExtentTableDef(fieldDefinition));
                            current.limit = item.limit;
                            current.alias = item.alias;
                            if (item.grammarItems != null) {
                                int j = 0;
                                while (j < item.grammarItems.size()) {
                                    current.filter = AggregationQueryBuilder.CompileQuery(current.tableDef, current.filter, item.grammarItems.get(j));
                                    ++j;
                                }
                            }
                            set.addLink(fieldDefinition.getName(), current);
                            int k = 0;
                            while (k < item.children.size()) {
                                FieldSetItem nextItem = item.children.get(k);
                                FieldSetTokenizer.CreateItemSet(nextItem, def.getLinkExtentTableDef(fieldDefinition), current);
                                ++k;
                            }
                        } else if (!set.ScalarFields.contains(fieldDefinition.getName())) {
                            set.ScalarFields.add(fieldDefinition.getName());
                            if (item.alias != null) {
                                set.ScalarFieldAliases.put(fieldDefinition.getName(), item.alias);
                            }
                        }
                        ++i;
                    }
                    break block14;
                }
                if (item.children.size() > 0) {
                    throw new IllegalArgumentException(String.valueOf(item.name) + " is not a link");
                }
                if (set.ScalarFields.contains(item.name)) break block14;
                set.ScalarFields.add(item.name);
                if (item.alias == null) break block14;
                set.ScalarFieldAliases.put(item.name, item.alias);
                break block14;
            }
            int i = 0;
            while (i < item.children.size()) {
                FieldSetItem nextItem = item.children.get(i);
                set.ScalarFields.add(nextItem.name);
                if (nextItem.alias != null) {
                    set.ScalarFieldAliases.put(item.name, item.alias);
                }
                ++i;
            }
        }
    }

    public void ProcessField() {
        this.Parse();
    }
}

