/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.search;

import com.dell.doradus.common.TableDefinition;
import com.dell.doradus.search.FieldSet;
import com.dell.doradus.search.QueryExecutor;
import com.dell.doradus.search.SearchResult;
import com.dell.doradus.search.SearchResultList;
import com.dell.doradus.search.aggregate.Entity;
import com.dell.doradus.search.aggregate.EntitySequence;
import com.dell.doradus.search.aggregate.SortOrder;
import com.dell.doradus.search.filter.Filter;
import com.dell.doradus.search.util.HeapList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class FieldSetCreator {
    public int limit;
    public Filter filter;
    public SortOrder[] orders;
    public TableDefinition tableDef;
    public List<String> scalarFields;
    public List<String> loadedFields;
    public TreeMap<String, List<FieldSetCreator>> links = new TreeMap();
    public FieldSet fieldSet;

    public FieldSetCreator(FieldSet fieldSet, SortOrder[] orders) {
        this.tableDef = fieldSet.tableDef;
        this.limit = fieldSet.limit;
        if (this.limit == -1) {
            this.limit = Integer.MAX_VALUE;
        }
        this.scalarFields = fieldSet.ScalarFields;
        this.loadedFields = this.scalarFields;
        this.orders = orders;
        this.fieldSet = fieldSet;
        HashSet<String> flds = new HashSet<String>(this.scalarFields.size());
        flds.addAll(this.scalarFields);
        if (fieldSet.filter != null) {
            this.filter = new QueryExecutor(this.tableDef).filter(fieldSet.filter);
            this.filter.addFields(flds);
        }
        if (flds.contains("*")) {
            flds.clear();
            flds.add("*");
        }
        this.loadedFields = new ArrayList<String>(flds);
        for (String link : fieldSet.getLinks()) {
            ArrayList<FieldSetCreator> list = new ArrayList<FieldSetCreator>();
            this.links.put(link, list);
            for (FieldSet fs : fieldSet.getLinks(link)) {
                list.add(new FieldSetCreator(fs, null));
            }
        }
    }

    public SearchResultList create(EntitySequence sequence, int skip) {
        int maxSize = this.limit;
        if (this.limit < Integer.MAX_VALUE - skip) {
            maxSize += skip;
        }
        SearchResultList resultList = new SearchResultList();
        if (this.orders == null || this.limit == Integer.MAX_VALUE) {
            for (Entity entity : sequence) {
                if (this.filter != null && !this.filter.check(entity)) continue;
                SearchResult result = this.createResult(entity);
                resultList.results.add(result);
                if (resultList.results.size() < maxSize) {
                    continue;
                }
                break;
            }
        } else {
            SearchResult[] arr;
            HeapList<SearchResult> results = new HeapList<SearchResult>(maxSize);
            for (Entity entity : sequence) {
                if (this.filter != null && !this.filter.check(entity)) continue;
                SearchResult result = this.createResult(entity);
                results.Add(result);
            }
            SearchResult[] searchResultArray = arr = results.GetValues(SearchResult.class);
            int n = arr.length;
            int n2 = 0;
            while (n2 < n) {
                SearchResult result = searchResultArray[n2];
                resultList.results.add(result);
                ++n2;
            }
        }
        if (this.limit == Integer.MAX_VALUE && this.orders != null) {
            Collections.sort(resultList.results);
        }
        if (skip > 0) {
            if (skip > resultList.results.size()) {
                resultList.results.clear();
            } else {
                resultList.results.subList(0, skip).clear();
            }
        }
        if (resultList.results.size() >= this.limit) {
            resultList.continuation_token = resultList.results.get((int)(resultList.results.size() - 1)).id.toString();
        }
        return resultList;
    }

    private SearchResult createResult(Entity entity) {
        SearchResult result = new SearchResult();
        result.scalars.put("_ID", entity.id().toString());
        result.id = entity.id();
        result.orders = this.orders;
        result.fieldSet = this.fieldSet;
        for (String string : this.scalarFields) {
            if (string.equals("_ID")) continue;
            if (string.equals("*")) {
                Iterable<String> allFields = entity.getAllFields();
                if (allFields == null) continue;
                for (String field : allFields) {
                    String value = entity.get(field);
                    if (value == null) continue;
                    result.scalars.put(field, value);
                }
                continue;
            }
            String v = entity.get(string);
            if (v == null) continue;
            result.scalars.put(string, v);
        }
        for (Map.Entry entry : this.links.entrySet()) {
            String linkName = (String)entry.getKey();
            List linkedSetList = (List)entry.getValue();
            ArrayList<SearchResultList> searchResultList = new ArrayList<SearchResultList>();
            result.links.put(linkName, searchResultList);
            for (FieldSetCreator linkedSet : linkedSetList) {
                EntitySequence linkedSequence = entity.getLinkedEntities(linkName, linkedSet.loadedFields);
                SearchResultList linkedResultList = linkedSet.create(linkedSequence, 0);
                searchResultList.add(linkedResultList);
            }
        }
        return result;
    }
}

