/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.search;

import com.dell.doradus.common.FieldDefinition;
import com.dell.doradus.common.TableDefinition;
import com.dell.doradus.common.Utils;
import com.dell.doradus.search.FieldSetTokenizer;
import com.dell.doradus.search.query.Query;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class FieldSet {
    public int limit = -1;
    public String alias = null;
    public Query filter = null;
    public TableDefinition tableDef;
    public ArrayList<String> ScalarFields = new ArrayList();
    public Map<String, String> ScalarFieldAliases = new HashMap<String, String>();
    private TreeMap<String, List<FieldSet>> LinkFields = new TreeMap();

    public FieldSet(TableDefinition tableDef) {
        this.tableDef = tableDef;
    }

    public FieldSet(TableDefinition tableDef, String text) {
        text = tableDef.replaceAliaces(text);
        this.tableDef = tableDef;
        this.Set(text);
        this.Fixup();
        this.mergeLinks();
    }

    public void addLink(String linkName, FieldSet fieldSet) {
        List<FieldSet> fieldSetList = this.LinkFields.get(linkName);
        if (fieldSetList == null) {
            fieldSetList = new ArrayList<FieldSet>();
            this.LinkFields.put(linkName, fieldSetList);
        }
        fieldSetList.add(fieldSet);
    }

    public Collection<String> getLinks() {
        return this.LinkFields.keySet();
    }

    public List<FieldSet> getLinks(String linkName) {
        return this.LinkFields.get(linkName);
    }

    public boolean IsOnlyID() {
        return this.LinkFields.size() == 0 && this.ScalarFields.size() == 1 && this.ScalarFields.get(0).equals("_ID");
    }

    public void Set(String fields) {
        if (fields == null || fields.equals("") || fields.equals("*")) {
            this.ScalarFields.add("*");
            return;
        }
        FieldSetTokenizer tok = new FieldSetTokenizer(this, fields);
        tok.ProcessField();
    }

    public void Fixup() {
        if (this.ScalarFields.contains("*") && this.ScalarFields.size() > 1) {
            this.ScalarFields.clear();
            this.ScalarFields.add("*");
        }
        if (this.ScalarFields.contains("_all")) {
            this.ScalarFields.clear();
            this.ScalarFields.add("*");
            this.LinkFields.clear();
            for (FieldDefinition fieldDef : this.tableDef.getFieldDefinitions()) {
                if (!fieldDef.isLinkField()) continue;
                this.addLink(fieldDef.getName(), new FieldSet(this.tableDef.getLinkExtentTableDef(fieldDef), "*"));
            }
        }
        if (this.ScalarFields.contains("_local")) {
            this.ScalarFields.clear();
            this.ScalarFields.add("*");
            this.LinkFields.clear();
            for (FieldDefinition fieldDef : this.tableDef.getFieldDefinitions()) {
                if (!fieldDef.isLinkField()) continue;
                this.addLink(fieldDef.getName(), new FieldSet(this.tableDef.getLinkExtentTableDef(fieldDef), "_ID"));
            }
        }
        for (List<FieldSet> linkSetList : this.LinkFields.values()) {
            for (FieldSet linkSet : linkSetList) {
                linkSet.Fixup();
            }
        }
        this.ScalarFields.remove("_ID");
    }

    public void expand() {
        if (this.ScalarFields.contains("*")) {
            this.ScalarFields.clear();
            for (FieldDefinition fd : this.tableDef.getFieldDefinitions()) {
                if (!fd.isScalarField()) continue;
                this.ScalarFields.add(fd.getName());
            }
        }
        for (List<FieldSet> linkSetList : this.LinkFields.values()) {
            for (FieldSet linkSet : linkSetList) {
                linkSet.expand();
            }
        }
    }

    private void mergeLinks() {
        ArrayList<String> allLinks = new ArrayList<String>(this.getLinks());
        for (String linkName : allLinks) {
            List<FieldSet> linkSet = this.getLinks(linkName);
            if (linkSet.size() <= 1) continue;
            ArrayList<FieldSet> newLinkSet = new ArrayList<FieldSet>();
            for (FieldSet link : linkSet) {
                int curSize = newLinkSet.size();
                boolean merged = false;
                int i = 0;
                while (i < curSize) {
                    String filter2;
                    FieldSet existingLink = (FieldSet)newLinkSet.get(i);
                    String filter1 = link.filter == null ? null : link.filter.toString();
                    String string = filter2 = existingLink.filter == null ? null : existingLink.filter.toString();
                    if (filter1 == null && filter2 == null || filter1 != null && filter1.equals(filter2)) {
                        existingLink.merge(link);
                        merged = true;
                        break;
                    }
                    ++i;
                }
                if (merged) continue;
                link.mergeLinks();
                newLinkSet.add(link);
            }
            this.LinkFields.put(linkName, newLinkSet);
        }
    }

    private void merge(FieldSet other) {
        Utils.require((this.limit == -1 || other.limit == -1 || this.limit == other.limit ? 1 : 0) != 0, (String)"Inconsistent field sizes");
        if (this.limit == -1) {
            this.limit = other.limit;
        }
        this.ScalarFields.addAll(other.ScalarFields);
        for (String link : other.getLinks()) {
            for (FieldSet linkSet : other.getLinks(link)) {
                this.addLink(link, linkSet);
            }
        }
        this.mergeLinks();
    }
}

