/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.olap.xlink;

import com.dell.doradus.common.FieldDefinition;
import com.dell.doradus.common.TableDefinition;
import com.dell.doradus.olap.io.BSTR;
import com.dell.doradus.olap.search.Result;
import com.dell.doradus.olap.search.ResultBuilder;
import com.dell.doradus.olap.store.CubeSearcher;
import com.dell.doradus.olap.store.FieldSearcher;
import com.dell.doradus.olap.store.IdSearcher;
import com.dell.doradus.olap.store.IntIterator;
import com.dell.doradus.olap.store.ValueSearcher;
import com.dell.doradus.olap.xlink.XLinkContext;
import com.dell.doradus.search.query.AllQuery;
import com.dell.doradus.search.query.Query;
import java.util.HashMap;
import java.util.Map;

public class XQueryCount {
    private Map<BSTR, IntVal> xcount = new HashMap<BSTR, IntVal>();

    public void add(BSTR id, int count) {
        IntVal val = this.xcount.get(id);
        if (val == null) {
            this.xcount.put(new BSTR(id), new IntVal(count));
        } else {
            val.val += count;
        }
    }

    public int get(BSTR id) {
        IntVal val = this.xcount.get(id);
        if (val == null) {
            return 0;
        }
        return val.val;
    }

    public void setup(XLinkContext ctx, FieldDefinition fieldDef, Query query) {
        FieldDefinition inverse;
        if (query == null) {
            query = new AllQuery();
        }
        if ((inverse = fieldDef.getInverseLinkDef()).isXLinkDirect()) {
            this.setupInverse(ctx, inverse.getTableDef(), query, inverse.getXLinkJunction());
        } else {
            this.setupDirect(ctx, inverse.getTableDef(), query);
        }
    }

    private void setupDirect(XLinkContext ctx, TableDefinition tableDef, Query query) {
        for (String xshard : ctx.xshards) {
            CubeSearcher searcher = ctx.olap.getSearcher(tableDef.getAppDef(), xshard);
            Result r = ResultBuilder.search(tableDef, query, searcher);
            IdSearcher ids = searcher.getIdSearcher(tableDef.getTableName());
            int i = 0;
            while (i < r.size()) {
                if (r.get(i)) {
                    BSTR id = ids.getId(i);
                    this.add(id, 1);
                }
                ++i;
            }
        }
    }

    private void setupInverse(XLinkContext ctx, TableDefinition tableDef, Query query, String field) {
        if (query == null) {
            query = new AllQuery();
        }
        for (String xshard : ctx.xshards) {
            CubeSearcher searcher = ctx.olap.getSearcher(tableDef.getAppDef(), xshard);
            Result r = ResultBuilder.search(tableDef, query, searcher);
            FieldSearcher fs = searcher.getFieldSearcher(tableDef.getTableName(), field);
            int[] counts = new int[fs.fields()];
            IntIterator iter = new IntIterator();
            int i = 0;
            while (i < r.size()) {
                if (r.get(i)) {
                    fs.fields(i, iter);
                    int j = 0;
                    while (j < iter.count()) {
                        int n = iter.get(j);
                        counts[n] = counts[n] + 1;
                        ++j;
                    }
                }
                ++i;
            }
            ValueSearcher vs = searcher.getValueSearcher(tableDef.getTableName(), field);
            int i2 = 0;
            while (i2 < vs.size()) {
                if (counts[i2] != 0) {
                    BSTR val = vs.getValue(i2);
                    this.add(val, counts[i2]);
                }
                ++i2;
            }
        }
    }

    static class IntVal {
        public int val = 0;

        public IntVal(int val) {
            this.val = val;
        }

        public String toString() {
            return "" + this.val;
        }
    }
}

