/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.olap.xlink;

import com.dell.doradus.common.FieldDefinition;
import com.dell.doradus.common.TableDefinition;
import com.dell.doradus.olap.io.BSTR;
import com.dell.doradus.olap.search.Result;
import com.dell.doradus.olap.search.ResultBuilder;
import com.dell.doradus.olap.store.CubeSearcher;
import com.dell.doradus.olap.store.FieldSearcher;
import com.dell.doradus.olap.store.IdSearcher;
import com.dell.doradus.olap.store.ValueSearcher;
import com.dell.doradus.olap.xlink.XLinkContext;
import com.dell.doradus.search.query.Query;
import java.util.HashSet;
import java.util.Set;

public class XQueryAny {
    private Set<BSTR> xresult = new HashSet<BSTR>();

    public void add(BSTR id) {
        this.xresult.add(new BSTR(id));
    }

    public boolean contains(BSTR id) {
        return this.xresult.contains(id);
    }

    public void setup(XLinkContext ctx, FieldDefinition fieldDef, Query query, Query filter) {
        FieldDefinition inverse = fieldDef.getInverseLinkDef();
        if (inverse.isXLinkDirect()) {
            this.setupInverse(ctx, inverse.getTableDef(), query, filter, inverse.getXLinkJunction());
        } else {
            this.setupDirect(ctx, inverse.getTableDef(), query, filter);
        }
    }

    private void setupDirect(XLinkContext ctx, TableDefinition tableDef, Query query, Query filter) {
        for (String xshard : ctx.xshards) {
            CubeSearcher searcher = ctx.olap.getSearcher(tableDef.getAppDef(), xshard);
            Result r = ResultBuilder.search(tableDef, query, searcher);
            if (filter != null) {
                Result f = ResultBuilder.search(tableDef, filter, searcher);
                r.and(f);
            }
            IdSearcher ids = searcher.getIdSearcher(tableDef.getTableName());
            int i = 0;
            while (i < r.size()) {
                if (r.get(i)) {
                    BSTR id = ids.getId(i);
                    this.add(id);
                }
                ++i;
            }
        }
    }

    private void setupInverse(XLinkContext ctx, TableDefinition tableDef, Query query, Query filter, String field) {
        for (String xshard : ctx.xshards) {
            CubeSearcher searcher = ctx.olap.getSearcher(tableDef.getAppDef(), xshard);
            Result r = ResultBuilder.search(tableDef, query, searcher);
            if (filter != null) {
                Result f = ResultBuilder.search(tableDef, filter, searcher);
                r.and(f);
            }
            FieldSearcher fs = searcher.getFieldSearcher(tableDef.getTableName(), field);
            Result r2 = new Result(fs.fields());
            fs.fillValues(r, r2);
            ValueSearcher vs = searcher.getValueSearcher(tableDef.getTableName(), field);
            int i = 0;
            while (i < r2.size()) {
                if (r2.get(i)) {
                    BSTR val = vs.getValue(i);
                    this.add(val);
                }
                ++i;
            }
        }
    }
}

