/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.olap.xlink;

import com.dell.doradus.common.ApplicationDefinition;
import com.dell.doradus.common.FieldDefinition;
import com.dell.doradus.common.TableDefinition;
import com.dell.doradus.olap.aggregate.IMetricValue;
import com.dell.doradus.olap.aggregate.MetricCollector;
import com.dell.doradus.olap.aggregate.MetricCollectorFactory;
import com.dell.doradus.olap.aggregate.MetricCounter;
import com.dell.doradus.olap.aggregate.MetricCounterFactory;
import com.dell.doradus.olap.io.BSTR;
import com.dell.doradus.olap.search.Result;
import com.dell.doradus.olap.search.ResultBuilder;
import com.dell.doradus.olap.store.CubeSearcher;
import com.dell.doradus.olap.store.FieldSearcher;
import com.dell.doradus.olap.store.IdSearcher;
import com.dell.doradus.olap.store.IntIterator;
import com.dell.doradus.olap.store.ValueSearcher;
import com.dell.doradus.olap.xlink.XLinkContext;
import com.dell.doradus.olap.xlink.XMetrics;
import com.dell.doradus.search.aggregate.AggregationGroupItem;
import com.dell.doradus.search.aggregate.AggregationMetric;
import com.dell.doradus.search.aggregate.BinaryExpression;
import com.dell.doradus.search.aggregate.LongIntegerExpression;
import com.dell.doradus.search.aggregate.MetricExpression;
import com.dell.doradus.search.aggregate.NumberExpression;
import com.dell.doradus.search.query.AllQuery;
import com.dell.doradus.search.query.Query;
import java.util.ArrayList;
import java.util.List;

public class XLinkMetricContext {
    public XLinkContext context;

    public XLinkMetricContext(XLinkContext context) {
        this.context = context;
    }

    public void setupXLinkMetric(List<MetricExpression> metrics) {
        for (MetricExpression metric : metrics) {
            this.setupXLinkMetric(metric);
        }
    }

    public void setupXLinkMetric(MetricExpression metric) {
        if (metric instanceof AggregationMetric) {
            this.setupXLinkMetric((AggregationMetric)metric);
        } else if (!(metric instanceof NumberExpression) && !(metric instanceof LongIntegerExpression)) {
            if (metric instanceof BinaryExpression) {
                BinaryExpression be = (BinaryExpression)metric;
                this.setupXLinkMetric(be.first);
                this.setupXLinkMetric(be.second);
            } else {
                throw new IllegalArgumentException("Invalid expression type: " + metric.getClass().getName());
            }
        }
    }

    public void setupXLinkMetric(AggregationMetric metric) {
        if (metric.filter != null) {
            this.context.setupXLinkQuery(metric.tableDef, metric.filter);
        }
        List<AggregationGroupItem> items = metric.items;
        TableDefinition tableDef = metric.tableDef;
        if (items == null) {
            return;
        }
        int i = items.size() - 1;
        while (i >= 0) {
            AggregationGroupItem item = items.get(i);
            if (item.query != null) {
                this.context.setupXLinkQuery(item.tableDef, item.query);
            }
            if (item.fieldDef.isXLinkField()) {
                metric.items = new ArrayList<AggregationGroupItem>();
                int j = i + 1;
                while (j < items.size()) {
                    metric.items.add(items.get(j));
                    ++j;
                }
                metric.tableDef = item.tableDef;
                XMetrics xmetrics = this.setup(item.fieldDef, metric, item.query);
                item.xlinkContext = xmetrics;
                metric.items = items;
                metric.tableDef = tableDef;
            }
            --i;
        }
    }

    private XMetrics setup(FieldDefinition fieldDef, AggregationMetric metric, Query filter) {
        XMetrics xmetrics = new XMetrics();
        if (fieldDef.getInverseLinkDef().isXLinkDirect()) {
            this.setupInverse(xmetrics, fieldDef, metric, filter);
        } else {
            this.setupDirect(xmetrics, fieldDef, metric, filter);
        }
        return xmetrics;
    }

    private void setupDirect(XMetrics xmetrics, FieldDefinition fieldDef, AggregationMetric metric, Query filter) {
        if (filter == null) {
            filter = new AllQuery();
        }
        TableDefinition invTable = fieldDef.getInverseTableDef();
        ApplicationDefinition appDef = fieldDef.getTableDef().getAppDef();
        for (String xshard : this.context.xshards) {
            CubeSearcher searcher = this.context.olap.getSearcher(appDef, xshard);
            Result bvQuery = ResultBuilder.search(invTable, filter, searcher);
            MetricCounter metricCounter = MetricCounterFactory.create(searcher, metric);
            MetricCollector metricCollector = MetricCollectorFactory.create(searcher, metric);
            IdSearcher ids = searcher.getIdSearcher(invTable.getTableName());
            int docsCount = ids.size();
            int doc = 0;
            while (doc < docsCount) {
                if (bvQuery.get(doc)) {
                    IMetricValue value = metricCollector.get();
                    metricCounter.add(doc, value);
                    xmetrics.metricsMap.put(new BSTR(ids.getId(doc)), value);
                }
                ++doc;
            }
        }
    }

    private void setupInverse(XMetrics xmetrics, FieldDefinition fieldDef, AggregationMetric metric, Query filter) {
        if (filter == null) {
            filter = new AllQuery();
        }
        TableDefinition invTable = fieldDef.getInverseTableDef();
        FieldDefinition inv = fieldDef.getInverseLinkDef();
        ApplicationDefinition appDef = fieldDef.getTableDef().getAppDef();
        for (String xshard : this.context.xshards) {
            CubeSearcher searcher = this.context.olap.getSearcher(appDef, xshard);
            Result bvQuery = ResultBuilder.search(invTable, filter, searcher);
            MetricCounter metricCounter = MetricCounterFactory.create(searcher, metric);
            MetricCollector metricCollector = MetricCollectorFactory.create(searcher, metric);
            FieldSearcher fs = searcher.getFieldSearcher(inv.getTableName(), inv.getXLinkJunction());
            IntIterator iter = new IntIterator();
            int docsCount = fs.size();
            IMetricValue[] vals = new IMetricValue[fs.fields()];
            int doc = 0;
            while (doc < docsCount) {
                if (bvQuery.get(doc)) {
                    IMetricValue value = metricCollector.get();
                    metricCounter.add(doc, value);
                    fs.fields(doc, iter);
                    int i = 0;
                    while (i < iter.count()) {
                        int val = iter.get(i);
                        if (vals[val] == null) {
                            vals[val] = metricCollector.get();
                        }
                        vals[val].add(value);
                        ++i;
                    }
                }
                ++doc;
            }
            ValueSearcher vs = searcher.getValueSearcher(invTable.getTableName(), inv.getXLinkJunction());
            int v = 0;
            while (v < vs.size()) {
                if (vals[v] != null) {
                    BSTR id = vs.getValue(v);
                    IMetricValue metricValue = xmetrics.metricsMap.get(id);
                    if (metricValue == null) {
                        xmetrics.metricsMap.put(new BSTR(id), vals[v]);
                    } else {
                        metricValue.add(vals[v]);
                    }
                }
                ++v;
            }
        }
    }
}

