/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.olap.xlink;

import com.dell.doradus.common.ApplicationDefinition;
import com.dell.doradus.common.FieldDefinition;
import com.dell.doradus.common.TableDefinition;
import com.dell.doradus.olap.aggregate.mr.MFCollector;
import com.dell.doradus.olap.aggregate.mr.MGName;
import com.dell.doradus.olap.collections.BdLongSet;
import com.dell.doradus.olap.io.BSTR;
import com.dell.doradus.olap.search.Result;
import com.dell.doradus.olap.search.ResultBuilder;
import com.dell.doradus.olap.store.CubeSearcher;
import com.dell.doradus.olap.store.FieldSearcher;
import com.dell.doradus.olap.store.IdSearcher;
import com.dell.doradus.olap.store.IntIterator;
import com.dell.doradus.olap.store.ValueSearcher;
import com.dell.doradus.olap.xlink.XGroups;
import com.dell.doradus.olap.xlink.XLinkContext;
import com.dell.doradus.search.aggregate.AggregationGroup;
import com.dell.doradus.search.aggregate.AggregationGroupItem;
import com.dell.doradus.search.query.AllQuery;
import com.dell.doradus.search.query.Query;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class XLinkGroupContext {
    public XLinkContext context;

    public XLinkGroupContext(XLinkContext context) {
        this.context = context;
    }

    public static boolean hasXLink(AggregationGroup group) {
        List<AggregationGroupItem> items = group.items;
        int i = 0;
        while (i < items.size()) {
            if (items.get((int)i).fieldDef.isXLinkField()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void setupXLinkGroup(AggregationGroup group) {
        if (group.filter != null) {
            this.context.setupXLinkQuery(group.tableDef, group.filter);
        }
        List<AggregationGroupItem> items = group.items;
        TableDefinition tableDef = group.tableDef;
        int i = items.size() - 1;
        while (i >= 0) {
            AggregationGroupItem item = items.get(i);
            if (item.query != null) {
                this.context.setupXLinkQuery(item.tableDef, item.query);
            }
            if (item.fieldDef.isXLinkField()) {
                group.items = new ArrayList<AggregationGroupItem>();
                int j = i + 1;
                while (j < items.size()) {
                    group.items.add(items.get(j));
                    ++j;
                }
                group.tableDef = item.tableDef;
                XGroups xgroups = this.setup(item.fieldDef, group, item.query);
                item.xlinkContext = xgroups;
                group.items = items;
                group.tableDef = tableDef;
            }
            --i;
        }
    }

    private XGroups setup(FieldDefinition fieldDef, AggregationGroup group, Query filter) {
        XGroups xgroups = new XGroups();
        if (fieldDef.getInverseLinkDef().isXLinkDirect()) {
            this.setupInverse(xgroups, fieldDef, group, filter);
        } else {
            this.setupDirect(xgroups, fieldDef, group, filter);
        }
        return xgroups;
    }

    private void setupDirect(XGroups xgroups, FieldDefinition fieldDef, AggregationGroup group, Query filter) {
        if (filter == null) {
            filter = new AllQuery();
        }
        TableDefinition invTable = fieldDef.getInverseTableDef();
        HashMap<MGName, Long> names = new HashMap<MGName, Long>();
        ApplicationDefinition appDef = fieldDef.getTableDef().getAppDef();
        for (String xshard : this.context.xshards) {
            CubeSearcher searcher = this.context.olap.getSearcher(appDef, xshard);
            Result bvQuery = ResultBuilder.search(invTable, filter, searcher);
            MFCollector collector = group.items.size() == 0 ? new MFCollector.IdField(searcher, invTable) : MFCollector.create(searcher, group);
            IdSearcher ids = searcher.getIdSearcher(invTable.getTableName());
            int docsCount = ids.size();
            BdLongSet[] docToFields = new BdLongSet[docsCount];
            BdLongSet allFields = new BdLongSet(1024);
            BdLongSet values = new BdLongSet(1024);
            values.enableClearBuffer();
            BdLongSet emptySet = new BdLongSet(1024);
            int doc = 0;
            while (doc < docsCount) {
                docToFields[doc] = emptySet;
                if (bvQuery.get(doc)) {
                    collector.collect(doc, values);
                    if (values.size() > 0) {
                        allFields.addAll(values);
                        BdLongSet vals = new BdLongSet(values.size());
                        vals.addAll(values);
                        docToFields[doc] = vals;
                        values.clear();
                    }
                }
                ++doc;
            }
            if (collector.requiresOrdering()) {
                allFields.sort();
            }
            HashMap<Long, Long> remap = new HashMap<Long, Long>();
            int i = 0;
            while (i < allFields.size()) {
                long num = allFields.get(i);
                MGName fieldName = collector.getField(num);
                Long mappedNum = (Long)names.get(fieldName);
                if (mappedNum == null) {
                    mappedNum = names.size();
                    names.put(fieldName, mappedNum);
                    xgroups.groupNames.add(fieldName);
                }
                remap.put(num, mappedNum);
                ++i;
            }
            allFields = null;
            i = 0;
            while (i < docsCount) {
                BSTR id = ids.getId(i);
                BdLongSet orig = docToFields[i];
                docToFields[i] = null;
                if (orig.size() > 0) {
                    BdLongSet remapped = new BdLongSet(orig.size());
                    int j = 0;
                    while (j < orig.size()) {
                        long num = orig.get(j);
                        remapped.add((Long)remap.get(num));
                        ++j;
                    }
                    xgroups.groupsMap.put(new BSTR(id), remapped);
                }
                ++i;
            }
        }
    }

    private void setupInverse(XGroups xgroups, FieldDefinition fieldDef, AggregationGroup group, Query filter) {
        if (filter == null) {
            filter = new AllQuery();
        }
        TableDefinition invTable = fieldDef.getInverseTableDef();
        FieldDefinition inv = fieldDef.getInverseLinkDef();
        HashMap<MGName, Long> names = new HashMap<MGName, Long>();
        ApplicationDefinition appDef = fieldDef.getTableDef().getAppDef();
        for (String xshard : this.context.xshards) {
            int i;
            CubeSearcher searcher = this.context.olap.getSearcher(appDef, xshard);
            Result bvQuery = ResultBuilder.search(invTable, filter, searcher);
            MFCollector collector = group.items.size() == 0 ? new MFCollector.IdField(searcher, invTable) : MFCollector.create(searcher, group);
            FieldSearcher fs = searcher.getFieldSearcher(inv.getTableName(), inv.getXLinkJunction());
            IntIterator iter = new IntIterator();
            int docsCount = fs.size();
            BdLongSet[] docToFields = new BdLongSet[fs.fields()];
            BdLongSet allFields = new BdLongSet(1024);
            BdLongSet values = new BdLongSet(1024);
            values.enableClearBuffer();
            int doc = 0;
            while (doc < docsCount) {
                if (bvQuery.get(doc)) {
                    collector.collect(doc, values);
                    allFields.addAll(values);
                    fs.fields(doc, iter);
                    i = 0;
                    while (i < iter.count()) {
                        int val = iter.get(i);
                        BdLongSet vals = docToFields[val];
                        if (vals == null) {
                            docToFields[val] = vals = new BdLongSet(values.size());
                        }
                        vals.addAll(values);
                        ++i;
                    }
                    values.clear();
                }
                ++doc;
            }
            if (collector.requiresOrdering()) {
                allFields.sort();
            }
            HashMap<Long, Long> remap = new HashMap<Long, Long>();
            i = 0;
            while (i < allFields.size()) {
                long num = allFields.get(i);
                MGName fieldName = collector.getField(num);
                Long mappedNum = (Long)names.get(fieldName);
                if (mappedNum == null) {
                    mappedNum = names.size();
                    names.put(fieldName, mappedNum);
                    xgroups.groupNames.add(fieldName);
                }
                remap.put(num, mappedNum);
                ++i;
            }
            allFields = null;
            ValueSearcher vs = searcher.getValueSearcher(invTable.getTableName(), inv.getXLinkJunction());
            int i2 = 0;
            while (i2 < vs.size()) {
                BSTR id = vs.getValue(i2);
                BdLongSet orig = docToFields[i2];
                docToFields[i2] = null;
                if (orig != null && orig.size() > 0) {
                    BdLongSet remapped = new BdLongSet(orig.size());
                    int j = 0;
                    while (j < orig.size()) {
                        long num = orig.get(j);
                        remapped.add((Long)remap.get(num));
                        ++j;
                    }
                    BdLongSet currentSet = xgroups.groupsMap.get(id);
                    if (currentSet == null) {
                        xgroups.groupsMap.put(new BSTR(id), remapped);
                    } else {
                        currentSet.addAll(remapped);
                    }
                }
                ++i2;
            }
        }
    }
}

