/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.olap.xlink;

import com.dell.doradus.common.FieldDefinition;
import com.dell.doradus.common.TableDefinition;
import com.dell.doradus.common.Utils;
import com.dell.doradus.olap.Olap;
import com.dell.doradus.olap.xlink.DirectXLinkQueryAll;
import com.dell.doradus.olap.xlink.DirectXLinkQueryAny;
import com.dell.doradus.olap.xlink.DirectXLinkQueryCount;
import com.dell.doradus.olap.xlink.InverseXLinkQueryAll;
import com.dell.doradus.olap.xlink.InverseXLinkQueryAny;
import com.dell.doradus.olap.xlink.InverseXLinkQueryCount;
import com.dell.doradus.olap.xlink.XLinkQueryNone;
import com.dell.doradus.search.query.AndQuery;
import com.dell.doradus.search.query.IdQuery;
import com.dell.doradus.search.query.LinkCountQuery;
import com.dell.doradus.search.query.LinkCountRangeQuery;
import com.dell.doradus.search.query.LinkIdQuery;
import com.dell.doradus.search.query.LinkQuery;
import com.dell.doradus.search.query.NotQuery;
import com.dell.doradus.search.query.OrQuery;
import com.dell.doradus.search.query.Query;
import java.util.List;

public class XLinkContext {
    public String application;
    public Olap olap;
    public List<String> xshards;

    public XLinkContext(String application, Olap olap, List<String> xshards, TableDefinition tableDef) {
        this.application = application;
        this.olap = olap;
        this.xshards = xshards;
    }

    public static boolean isXLinkQuery(TableDefinition tableDef, Query query) {
        if (query instanceof AndQuery) {
            AndQuery q = (AndQuery)query;
            for (Query c : q.subqueries) {
                if (!XLinkContext.isXLinkQuery(tableDef, c)) continue;
                return true;
            }
        } else if (query instanceof OrQuery) {
            OrQuery q = (OrQuery)query;
            for (Query c : q.subqueries) {
                if (!XLinkContext.isXLinkQuery(tableDef, c)) continue;
                return true;
            }
        } else if (query instanceof NotQuery) {
            NotQuery q = (NotQuery)query;
            if (XLinkContext.isXLinkQuery(tableDef, q.innerQuery)) {
                return true;
            }
        } else if (query instanceof LinkQuery) {
            LinkQuery lq = (LinkQuery)query;
            FieldDefinition fieldDef = tableDef.getFieldDef(lq.link);
            Utils.require((fieldDef != null ? 1 : 0) != 0, (String)("Field " + lq.link + " does not exist"));
            if (fieldDef.isGroupField()) {
                return false;
            }
            if (fieldDef.isXLinkField()) {
                return true;
            }
            if (XLinkContext.isXLinkQuery(fieldDef.getInverseTableDef(), lq.innerQuery)) {
                return true;
            }
        } else if (query instanceof LinkIdQuery) {
            LinkIdQuery lq = (LinkIdQuery)query;
            FieldDefinition fieldDef = tableDef.getFieldDef(lq.link);
            Utils.require((fieldDef != null ? 1 : 0) != 0, (String)("Field " + lq.link + " does not exist"));
            if (fieldDef.isXLinkField()) {
                return true;
            }
        } else if (query instanceof LinkCountQuery) {
            LinkCountQuery lq = (LinkCountQuery)query;
            FieldDefinition fieldDef = tableDef.getFieldDef(lq.link);
            Utils.require((fieldDef != null ? 1 : 0) != 0, (String)("Field " + lq.link + " does not exist"));
            if (fieldDef.isXLinkField()) {
                return true;
            }
        } else if (query instanceof LinkCountRangeQuery) {
            LinkCountRangeQuery lq = (LinkCountRangeQuery)query;
            FieldDefinition fieldDef = tableDef.getFieldDef(lq.link);
            Utils.require((fieldDef != null ? 1 : 0) != 0, (String)("Field " + lq.link + " does not exist"));
            if (fieldDef.isXLinkField()) {
                return true;
            }
        }
        return false;
    }

    public void setupXLinkQuery(TableDefinition tableDef, Query query) {
        if (query == null) {
            return;
        }
        if (query instanceof AndQuery) {
            AndQuery q = (AndQuery)query;
            for (Query c : q.subqueries) {
                this.setupXLinkQuery(tableDef, c);
            }
        } else if (query instanceof OrQuery) {
            OrQuery q = (OrQuery)query;
            for (Query c : q.subqueries) {
                this.setupXLinkQuery(tableDef, c);
            }
        } else if (query instanceof NotQuery) {
            NotQuery q = (NotQuery)query;
            this.setupXLinkQuery(tableDef, q.innerQuery);
        } else if (query instanceof LinkQuery) {
            LinkQuery lq = (LinkQuery)query;
            FieldDefinition fieldDef = tableDef.getFieldDef(lq.link);
            Utils.require((fieldDef != null ? 1 : 0) != 0, (String)("Field " + lq.link + " does not exist"));
            this.setupXLinkQuery(fieldDef.getInverseTableDef(), lq.innerQuery);
            this.setupXLinkQuery(fieldDef.getInverseTableDef(), lq.filter);
            if (!fieldDef.isXLinkField()) {
                return;
            }
            lq.xlink = fieldDef.isXLinkInverse() ? (LinkQuery.ALL.equals(lq.quantifier) ? new InverseXLinkQueryAll(this, tableDef, lq) : new InverseXLinkQueryAny(this, tableDef, lq)) : (LinkQuery.ALL.equals(lq.quantifier) ? new DirectXLinkQueryAll(this, tableDef, lq) : new DirectXLinkQueryAny(this, tableDef, lq));
            if (LinkQuery.NONE.equals(lq.quantifier)) {
                lq.xlink = new XLinkQueryNone(lq.xlink);
            }
        } else if (query instanceof LinkIdQuery) {
            LinkIdQuery lq = (LinkIdQuery)query;
            FieldDefinition fieldDef = tableDef.getFieldDef(lq.link);
            Utils.require((fieldDef != null ? 1 : 0) != 0, (String)("Field " + lq.link + " does not exist"));
            if (!fieldDef.isXLinkField()) {
                return;
            }
            if (lq.id == null) {
                Utils.require((boolean)LinkQuery.ANY.equals(lq.quantifier), (String)"only ANY quantifier is allowed with IS NULL clause");
                LinkCountQuery q = new LinkCountQuery(lq.link, 0);
                lq.xlink = fieldDef.isXLinkInverse() ? new InverseXLinkQueryCount(this, tableDef, q) : new DirectXLinkQueryCount(this, tableDef, q);
                return;
            }
            LinkQuery q = new LinkQuery(lq.quantifier, lq.link, new IdQuery(lq.id));
            lq.xlink = fieldDef.isXLinkInverse() ? (LinkQuery.ALL.equals(lq.quantifier) ? new InverseXLinkQueryAll(this, tableDef, q) : new InverseXLinkQueryAny(this, tableDef, q)) : (LinkQuery.ALL.equals(lq.quantifier) ? new DirectXLinkQueryAll(this, tableDef, q) : new DirectXLinkQueryAny(this, tableDef, q));
            if (LinkQuery.NONE.equals(lq.quantifier)) {
                lq.xlink = new XLinkQueryNone(lq.xlink);
            }
        } else if (query instanceof LinkCountQuery) {
            LinkCountQuery lq = (LinkCountQuery)query;
            FieldDefinition fieldDef = tableDef.getFieldDef(lq.link);
            Utils.require((fieldDef != null ? 1 : 0) != 0, (String)("Field " + lq.link + " does not exist"));
            if (!fieldDef.isXLinkField()) {
                return;
            }
            this.setupXLinkQuery(fieldDef.getInverseTableDef(), lq.filter);
            lq.xlink = fieldDef.isXLinkInverse() ? new InverseXLinkQueryCount(this, tableDef, lq) : new DirectXLinkQueryCount(this, tableDef, lq);
        } else if (query instanceof LinkCountRangeQuery) {
            LinkCountRangeQuery lq = (LinkCountRangeQuery)query;
            FieldDefinition fieldDef = tableDef.getFieldDef(lq.link);
            Utils.require((fieldDef != null ? 1 : 0) != 0, (String)("Field " + lq.link + " does not exist"));
            if (!fieldDef.isXLinkField()) {
                return;
            }
            this.setupXLinkQuery(fieldDef.getInverseTableDef(), lq.filter);
            lq.xlink = fieldDef.isXLinkInverse() ? new InverseXLinkQueryCount(this, tableDef, lq) : new DirectXLinkQueryCount(this, tableDef, lq);
        }
    }
}

