/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.olap.xlink;

import com.dell.doradus.common.FieldDefinition;
import com.dell.doradus.common.TableDefinition;
import com.dell.doradus.olap.io.BSTR;
import com.dell.doradus.olap.search.Result;
import com.dell.doradus.olap.store.CubeSearcher;
import com.dell.doradus.olap.store.IdSearcher;
import com.dell.doradus.olap.xlink.XLinkContext;
import com.dell.doradus.olap.xlink.XLinkQuery;
import com.dell.doradus.olap.xlink.XQueryCount;
import com.dell.doradus.search.query.LinkCountQuery;
import com.dell.doradus.search.query.LinkCountRangeQuery;
import com.dell.doradus.search.query.Query;

public class InverseXLinkQueryCount
implements Query,
XLinkQuery {
    private FieldDefinition fieldDef;
    private XQueryCount xcount = new XQueryCount();
    private int min;
    private int max;

    public InverseXLinkQueryCount(XLinkContext ctx, TableDefinition tableDef, LinkCountQuery lq) {
        this.fieldDef = tableDef.getFieldDef(lq.link);
        this.xcount.setup(ctx, this.fieldDef, lq.filter);
        this.min = lq.count;
        this.max = lq.count + 1;
    }

    public InverseXLinkQueryCount(XLinkContext ctx, TableDefinition tableDef, LinkCountRangeQuery lq) {
        this.fieldDef = tableDef.getFieldDef(lq.link);
        this.xcount.setup(ctx, this.fieldDef, lq.filter);
        this.min = lq.range.min == null ? Integer.MIN_VALUE : Integer.parseInt(lq.range.min);
        int n = this.max = lq.range.max == null ? Integer.MAX_VALUE : Integer.parseInt(lq.range.max);
        if (!lq.range.minInclusive) {
            ++this.min;
        }
        if (lq.range.maxInclusive) {
            ++this.max;
        }
    }

    @Override
    public void search(CubeSearcher searcher, Result result) {
        IdSearcher ids = searcher.getIdSearcher(this.fieldDef.getTableDef().getTableName());
        int i = 0;
        while (i < result.size()) {
            BSTR id = ids.getId(i);
            int count = this.xcount.get(id);
            if (count >= this.min && count < this.max) {
                result.set(i);
            }
            ++i;
        }
    }
}

