/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.olap.xlink;

import com.dell.doradus.common.FieldDefinition;
import com.dell.doradus.olap.aggregate.IMetricValue;
import com.dell.doradus.olap.aggregate.MetricCounter;
import com.dell.doradus.olap.io.BSTR;
import com.dell.doradus.olap.store.CubeSearcher;
import com.dell.doradus.olap.store.FieldSearcher;
import com.dell.doradus.olap.store.IntIterator;
import com.dell.doradus.olap.store.ValueSearcher;
import com.dell.doradus.olap.xlink.XMetrics;

public class DirectXLinkMetricCounter
extends MetricCounter {
    private FieldSearcher fs;
    private IntIterator iter;
    private IMetricValue[] values;

    public DirectXLinkMetricCounter(CubeSearcher searcher, FieldDefinition fieldDef, XMetrics xmetrics) {
        ValueSearcher vs = searcher.getValueSearcher(fieldDef.getTableName(), fieldDef.getXLinkJunction());
        this.values = new IMetricValue[vs.size()];
        int i = 0;
        while (i < vs.size()) {
            IMetricValue value;
            BSTR val = vs.getValue(i);
            this.values[i] = value = xmetrics.metricsMap.get(val);
            ++i;
        }
        this.fs = searcher.getFieldSearcher(fieldDef.getTableName(), fieldDef.getXLinkJunction());
        this.iter = new IntIterator();
    }

    @Override
    public void add(int doc, IMetricValue value) {
        this.fs.fields(doc, this.iter);
        int i = 0;
        while (i < this.iter.count()) {
            int val = this.iter.get(i);
            if (this.values[val] != null) {
                value.add(this.values[val]);
            }
            ++i;
        }
    }
}

