/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.olap.xlink;

import com.dell.doradus.common.FieldDefinition;
import com.dell.doradus.olap.aggregate.mr.MFCollector;
import com.dell.doradus.olap.aggregate.mr.MGName;
import com.dell.doradus.olap.collections.BdLongSet;
import com.dell.doradus.olap.io.BSTR;
import com.dell.doradus.olap.store.CubeSearcher;
import com.dell.doradus.olap.store.FieldSearcher;
import com.dell.doradus.olap.store.IntIterator;
import com.dell.doradus.olap.store.ValueSearcher;
import com.dell.doradus.olap.xlink.XGroups;

public class DirectXLinkCollector
extends MFCollector {
    private XGroups groups;
    private FieldSearcher fs;
    private IntIterator iter;
    private BdLongSet[] fieldSets;

    public DirectXLinkCollector(CubeSearcher searcher, FieldDefinition fieldDef, XGroups groups) {
        super(searcher);
        this.groups = groups;
        ValueSearcher vs = searcher.getValueSearcher(fieldDef.getTableName(), fieldDef.getXLinkJunction());
        this.fieldSets = new BdLongSet[vs.size()];
        int i = 0;
        while (i < vs.size()) {
            BdLongSet set;
            BSTR val = vs.getValue(i);
            this.fieldSets[i] = set = groups.groupsMap.get(val);
            ++i;
        }
        this.fs = searcher.getFieldSearcher(fieldDef.getTableName(), fieldDef.getXLinkJunction());
        this.iter = new IntIterator();
    }

    @Override
    public void collect(long doc, BdLongSet values) {
        this.fs.fields((int)doc, this.iter);
        int i = 0;
        while (i < this.iter.count()) {
            int val = this.iter.get(i);
            BdLongSet set = this.fieldSets[val];
            if (set != null) {
                values.addAll(set);
            }
            ++i;
        }
    }

    @Override
    public MGName getField(long value) {
        return this.groups.groupNames.get((int)value);
    }

    @Override
    public boolean requiresOrdering() {
        return false;
    }
}

