/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.olap.store;

import com.dell.doradus.olap.io.BSTR;
import com.dell.doradus.olap.io.VDirectory;
import com.dell.doradus.olap.io.VOutputStream;

public class ValueWriter {
    public static int SPAN = 1024;
    private VDirectory m_dir;
    private String m_table;
    private String m_field;
    private VOutputStream m_stream_term;
    private VOutputStream m_stream_orig;
    private VOutputStream m_stream_term_idx;
    private VOutputStream m_stream_orig_idx;
    private int m_terms;
    private BSTR m_last = new BSTR();
    private BSTR m_orig = new BSTR();
    private long m_last_term_position = 0L;
    private long m_last_orig_position = 0L;

    public ValueWriter(VDirectory dir, String table, String field) {
        this.m_dir = dir;
        this.m_table = table;
        this.m_field = field;
        this.m_terms = 0;
        this.m_last.length = -1;
    }

    public int add(BSTR term, BSTR orig) {
        if (BSTR.isEqual(this.m_last, term)) {
            return this.m_terms - 1;
        }
        if (this.m_stream_term == null) {
            this.m_stream_term = this.m_dir.create(String.valueOf(this.m_table) + "." + this.m_field + ".term");
            this.m_stream_orig = this.m_dir.create(String.valueOf(this.m_table) + "." + this.m_field + ".orig");
            this.m_stream_term_idx = this.m_dir.create(String.valueOf(this.m_table) + "." + this.m_field + ".term.idx");
            this.m_stream_orig_idx = this.m_dir.create(String.valueOf(this.m_table) + "." + this.m_field + ".orig.idx");
        }
        if (this.m_terms % SPAN == 0) {
            this.m_stream_term_idx.write(term);
            long new_term_position = this.m_stream_term.position();
            this.m_stream_term_idx.writeVLong(new_term_position - this.m_last_term_position);
            this.m_last_term_position = new_term_position;
            this.m_stream_orig_idx.write(orig);
            long new_orig_position = this.m_stream_orig.position();
            this.m_stream_orig_idx.writeVLong(new_orig_position - this.m_last_orig_position);
            this.m_last_orig_position = new_orig_position;
        }
        this.m_stream_term.writeVString(term);
        this.m_last.set(term);
        this.m_stream_orig.writeVString(orig);
        this.m_orig.set(orig);
        return this.m_terms++;
    }

    public int size() {
        return this.m_terms;
    }

    public void close() {
        if (this.m_stream_term != null) {
            this.m_stream_term.close();
            this.m_stream_orig.close();
            this.m_stream_term_idx.close();
            this.m_stream_orig_idx.close();
        }
    }
}

