/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.olap.store;

import com.dell.doradus.olap.io.BSTR;
import com.dell.doradus.olap.io.FileDeletedException;
import com.dell.doradus.olap.io.VDirectory;
import com.dell.doradus.olap.io.VInputStream;
import com.dell.doradus.olap.store.IdWriter;
import com.dell.doradus.olap.store.SegmentStats;
import com.dell.doradus.olap.store.ValueWriter;

public class ValueSearcher {
    private VInputStream m_stream_term;
    private VInputStream m_stream_orig;
    private BSTR[] m_idx_terms;
    private BSTR[] m_idx_origs;
    private long[] m_term_offsets;
    private long[] m_orig_offsets;
    private int m_size = 0;
    private BSTR m_term = new BSTR();
    private int m_cur_term = -1;
    private BSTR m_orig = new BSTR();
    private int m_cur_orig = -1;

    public ValueSearcher(VDirectory dir, SegmentStats.Table.TextField fieldStats) {
        if (fieldStats == null) {
            return;
        }
        String table = fieldStats.table();
        String field = fieldStats.name;
        if (!dir.fileExists(String.valueOf(table) + "." + field + ".term")) {
            return;
        }
        this.m_stream_term = dir.open(String.valueOf(table) + "." + field + ".term");
        this.m_stream_term.seek(0L);
        this.m_stream_orig = dir.open(String.valueOf(table) + "." + field + ".orig");
        this.m_stream_orig.seek(0L);
        this.m_size = fieldStats.valuesCount;
        this.m_idx_terms = new BSTR[(this.m_size + ValueWriter.SPAN - 1) / ValueWriter.SPAN];
        this.m_idx_origs = new BSTR[(this.m_size + ValueWriter.SPAN - 1) / ValueWriter.SPAN];
        this.m_term_offsets = new long[this.m_idx_terms.length];
        this.m_orig_offsets = new long[this.m_idx_origs.length];
        VInputStream stream_term_idx = dir.open(String.valueOf(table) + "." + field + ".term.idx");
        long last_term_offset = 0L;
        int i = 0;
        while (i < this.m_idx_terms.length) {
            stream_term_idx.read(this.m_term);
            this.m_idx_terms[i] = new BSTR(this.m_term);
            last_term_offset = this.m_term_offsets[i] = last_term_offset + stream_term_idx.readVLong();
            ++i;
        }
        VInputStream stream_orig_idx = dir.open(String.valueOf(table) + "." + field + ".orig.idx");
        long last_orig_offset = 0L;
        int i2 = 0;
        while (i2 < this.m_idx_origs.length) {
            stream_orig_idx.read(this.m_orig);
            this.m_idx_origs[i2] = new BSTR(this.m_orig);
            last_orig_offset = this.m_orig_offsets[i2] = last_orig_offset + stream_orig_idx.readVLong();
            ++i2;
        }
        this.m_term.length = -1;
        this.m_orig.length = -1;
    }

    public ValueSearcher(ValueSearcher searcher) {
        this.m_stream_orig = searcher.m_stream_orig == null ? null : new VInputStream(searcher.m_stream_orig);
        this.m_stream_term = searcher.m_stream_term == null ? null : new VInputStream(searcher.m_stream_term);
        this.m_idx_terms = searcher.m_idx_terms;
        this.m_idx_origs = searcher.m_idx_origs;
        this.m_term_offsets = searcher.m_term_offsets;
        this.m_orig_offsets = searcher.m_orig_offsets;
        this.m_size = searcher.m_size;
        this.m_term = new BSTR(searcher.m_term);
        this.m_cur_term = searcher.m_cur_term;
        this.m_orig = new BSTR(searcher.m_orig);
        this.m_cur_orig = searcher.m_cur_orig;
    }

    public int size() {
        return this.m_size;
    }

    public BSTR getValue(int orig) {
        if (orig == this.m_cur_orig) {
            return this.m_orig;
        }
        if (this.m_stream_orig == null) {
            throw new FileDeletedException("in ValueSearcher");
        }
        if (this.m_cur_orig < orig && this.m_cur_orig / ValueWriter.SPAN == orig / ValueWriter.SPAN) {
            while (this.m_cur_orig < orig) {
                ++this.m_cur_orig;
                this.m_stream_orig.readVString(this.m_orig);
            }
        } else {
            this.m_stream_orig.seek(this.m_orig_offsets[orig / ValueWriter.SPAN]);
            this.m_orig.set(this.m_idx_origs[orig / ValueWriter.SPAN]);
            int i = 0;
            while (i <= orig % ValueWriter.SPAN) {
                this.m_stream_orig.readVString(this.m_orig);
                ++i;
            }
            this.m_cur_orig = orig;
        }
        return this.m_orig;
    }

    public int curTermNumber() {
        return this.m_cur_term;
    }

    public BSTR curTerm() {
        return this.m_term;
    }

    public void reset() {
        if (this.m_stream_term == null) {
            return;
        }
        this.m_stream_term.seek(0L);
        this.m_stream_orig.seek(0L);
        this.m_term.length = -1;
        this.m_cur_term = -1;
        this.m_orig.length = -1;
        this.m_cur_orig = -1;
    }

    public boolean next() {
        if (this.m_cur_term >= this.m_size) {
            return false;
        }
        ++this.m_cur_term;
        if (this.m_cur_term == this.m_size) {
            return false;
        }
        this.m_stream_term.readVString(this.m_term);
        return true;
    }

    public int find(BSTR term, boolean exact) {
        if (this.m_size == 0) {
            return -1;
        }
        int min = 0;
        int max = this.m_idx_terms.length;
        while (max - min > 1) {
            int mid = (max + min) / 2;
            int c = BSTR.compare(term, this.m_idx_terms[mid]);
            if (c < 0) {
                max = mid;
                continue;
            }
            min = mid;
        }
        this.m_stream_term.seek(this.m_term_offsets[min]);
        this.m_term.set(this.m_idx_terms[min]);
        this.m_cur_term = min * IdWriter.SPAN;
        this.m_stream_term.readVString(this.m_term);
        while (!this.m_stream_term.end() && BSTR.compare(term, this.m_term) > 0) {
            ++this.m_cur_term;
            this.m_stream_term.readVString(this.m_term);
        }
        if (exact && !BSTR.isEqual(term, this.m_term)) {
            return -1;
        }
        if (!exact && BSTR.compare(term, this.m_term) > 0) {
            return this.m_cur_term + 1;
        }
        return this.m_cur_term;
    }

    public long cacheSize() {
        BSTR b;
        int n;
        int n2;
        BSTR[] bSTRArray;
        long size = 1024 + this.m_term.buffer.length + this.m_orig.buffer.length;
        if (this.m_idx_terms != null) {
            bSTRArray = this.m_idx_terms;
            n2 = this.m_idx_terms.length;
            n = 0;
            while (n < n2) {
                b = bSTRArray[n];
                size += (long)b.buffer.length;
                ++n;
            }
        }
        if (this.m_idx_origs != null) {
            bSTRArray = this.m_idx_origs;
            n2 = this.m_idx_origs.length;
            n = 0;
            while (n < n2) {
                b = bSTRArray[n];
                size += (long)b.buffer.length;
                ++n;
            }
        }
        if (this.m_term_offsets != null) {
            size += (long)(8 * this.m_term_offsets.length);
        }
        if (this.m_orig_offsets != null) {
            size += (long)(8 * this.m_orig_offsets.length);
        }
        return size;
    }
}

