/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.olap.store;

import com.dell.doradus.olap.io.VDirectory;
import com.dell.doradus.olap.io.VOutputStream;
import com.dell.doradus.olap.store.BitVector;
import com.dell.doradus.olap.store.LongList;
import com.dell.doradus.olap.store.NumArray;

public class NumWriterMV {
    private LongList m_doc;
    private int[] m_len;
    private boolean m_isSingleValued = true;
    private BitVector m_mask;
    public long min = Long.MAX_VALUE;
    public long max = Long.MIN_VALUE;
    public long min_pos = Long.MAX_VALUE;
    public byte bits = 0;
    private int m_lastDoc = -1;
    private long m_lastNum = -1L;
    private long m_maxNum = -1L;
    private int m_docsCount;

    public NumWriterMV(int docsCount) {
        this.m_docsCount = docsCount;
        this.m_doc = new LongList(docsCount);
        this.m_len = new int[docsCount];
        this.m_mask = new BitVector(docsCount);
    }

    public int getDocListSize() {
        return this.m_doc.size();
    }

    public boolean isSingleValued() {
        return this.m_isSingleValued;
    }

    public int getDocsCount() {
        return this.m_docsCount;
    }

    public int getEntriesCount() {
        if (this.m_isSingleValued) {
            return this.getDocsCount();
        }
        return this.m_doc.size();
    }

    public void add(int doc, long num) {
        if (this.m_lastDoc == doc && this.m_lastNum == num) {
            return;
        }
        if (this.m_lastDoc > doc) {
            throw new RuntimeException("Invalid doc order");
        }
        this.m_mask.set(doc);
        if (this.m_maxNum < num) {
            this.m_maxNum = num;
        }
        if (this.m_lastDoc == doc) {
            this.m_isSingleValued = false;
            if (this.m_lastNum > num) {
                throw new RuntimeException("Invalid number order");
            }
        } else {
            this.m_lastDoc = doc;
        }
        int n = doc;
        this.m_len[n] = this.m_len[n] + 1;
        this.m_doc.add(num);
        this.m_lastNum = num;
        if (this.min > num) {
            this.min = num;
        }
        if (this.max < num) {
            this.max = num;
        }
        if (num > 0L && this.min_pos > num) {
            this.min_pos = num;
        }
    }

    public void close(VDirectory dir, String table, String field) {
        if (this.min_pos > this.max) {
            this.min_pos = 0L;
        }
        if (this.m_isSingleValued) {
            int setCount = this.m_mask.bitsSet();
            if (setCount == 0) {
                return;
            }
            if (setCount != this.m_docsCount) {
                VOutputStream mask_stream = dir.create(String.valueOf(table) + "." + field + ".num.mask");
                mask_stream.write(this.m_mask.getBuffer(), 0, this.m_mask.getBuffer().length);
                mask_stream.close();
            }
            long[] values = new long[this.m_docsCount];
            int pos = 0;
            int i = 0;
            while (i < this.m_docsCount) {
                if (this.m_mask.get(i)) {
                    values[i] = this.m_doc.get(pos++);
                }
                ++i;
            }
            if (pos != this.m_doc.size()) {
                throw new RuntimeException("Inconsistency in NumWriterMV");
            }
            int size = values.length;
            if (size == 0) {
                return;
            }
            VOutputStream stream = dir.create(String.valueOf(table) + "." + field + ".dat");
            this.bits = NumArray.writeArray(stream, values, values.length, this.min, this.max);
            stream.close();
        } else {
            VOutputStream out_dat = dir.create(String.valueOf(table) + "." + field + ".dat");
            VOutputStream out_pos = dir.create(String.valueOf(table) + "." + field + ".pos");
            this.bits = NumArray.writeArray(out_dat, this.m_doc.getArray(), this.m_doc.size(), this.min, this.max);
            out_dat.close();
            out_pos.writeVInt(this.m_docsCount);
            int i = 0;
            while (i < this.m_docsCount) {
                out_pos.writeVInt(this.m_len[i]);
                ++i;
            }
            out_pos.close();
        }
    }
}

