/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.olap.store;

import com.dell.doradus.olap.io.VDirectory;
import com.dell.doradus.olap.io.VOutputStream;
import com.dell.doradus.olap.store.BitVector;
import com.dell.doradus.olap.store.NumArray;

public class NumWriter {
    private long[] m_values;
    private BitVector m_mask;
    public long min = Long.MAX_VALUE;
    public long max = Long.MIN_VALUE;
    public long min_pos = Long.MAX_VALUE;
    public byte bits = 0;

    public NumWriter(int docsCount) {
        this.m_values = new long[docsCount];
        this.m_mask = new BitVector(docsCount);
    }

    public void add(int doc, long number) {
        this.m_values[doc] = number;
        this.m_mask.set(doc);
        if (this.min > number) {
            this.min = number;
        }
        if (this.max < number) {
            this.max = number;
        }
        if (number > 0L && this.min_pos > number) {
            this.min_pos = number;
        }
    }

    public void close(VDirectory dir, String table, String field) {
        int size;
        int setCount = this.m_mask.bitsSet();
        if (setCount == 0) {
            return;
        }
        if (setCount != this.m_values.length) {
            VOutputStream mask_stream = dir.create(String.valueOf(table) + "." + field + ".num.mask");
            mask_stream.write(this.m_mask.getBuffer(), 0, this.m_mask.getBuffer().length);
            mask_stream.close();
        }
        if (this.min_pos > this.max) {
            this.min_pos = 0L;
        }
        if ((size = this.m_values.length) == 0) {
            return;
        }
        VOutputStream stream = dir.create(String.valueOf(table) + "." + field + ".dat");
        this.bits = NumArray.writeArray(stream, this.m_values, this.m_values.length, this.min, this.max);
        stream.close();
    }
}

