/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.olap.store;

import com.dell.doradus.common.FieldType;
import com.dell.doradus.olap.XType;
import com.dell.doradus.olap.io.VDirectory;
import com.dell.doradus.olap.io.VInputStream;
import com.dell.doradus.olap.search.Result;
import com.dell.doradus.olap.store.BitVector;
import com.dell.doradus.olap.store.NumArray;
import com.dell.doradus.search.analyzer.DateTrie;
import java.util.Date;

public class NumSearcherMV {
    private NumArray m_values;
    private BitVector m_mask;
    private int[] m_positions;
    private boolean m_bSingleValued = true;
    private int m_documents;
    private long m_min = Long.MAX_VALUE;
    private long m_min_pos = Long.MAX_VALUE;
    private long m_max = Long.MIN_VALUE;

    public NumSearcherMV(VDirectory dir, String table, String field) {
        if (!dir.fileExists(String.valueOf(table) + "." + field + ".dat")) {
            return;
        }
        VInputStream stream = dir.open(String.valueOf(table) + "." + field + ".dat");
        this.m_values = new NumArray(stream);
        int i = 0;
        while (i < this.m_values.size()) {
            long val = this.m_values.get(i);
            if (this.m_min > val) {
                this.m_min = val;
            }
            if (this.m_max < val) {
                this.m_max = val;
            }
            if (val > 0L && this.m_min_pos > val) {
                this.m_min_pos = val;
            }
            ++i;
        }
        if (dir.fileExists(String.valueOf(table) + "." + field + ".num.mask")) {
            this.m_mask = new BitVector(this.m_values.size());
            VInputStream mask_stream = dir.open(String.valueOf(table) + "." + field + ".num.mask");
            mask_stream.read(this.m_mask.getBuffer(), 0, this.m_mask.getBuffer().length);
        }
        if (dir.fileExists(String.valueOf(table) + "." + field + ".pos")) {
            this.m_bSingleValued = false;
            VInputStream inp_pos = dir.open(String.valueOf(table) + "." + field + ".pos");
            this.m_documents = inp_pos.readVInt();
            this.m_positions = new int[this.m_documents + 1];
            this.m_positions[0] = 0;
            int i2 = 0;
            while (i2 < this.m_documents) {
                int sz = inp_pos.readVInt();
                this.m_positions[i2 + 1] = this.m_positions[i2] + sz;
                ++i2;
            }
        } else {
            this.m_documents = this.m_values.size();
        }
    }

    public int size() {
        return this.m_documents;
    }

    public long min() {
        return this.m_min;
    }

    public long max() {
        return this.m_max;
    }

    public long minPos() {
        return this.m_min_pos;
    }

    public int size(int doc) {
        if (this.m_values == null) {
            return 0;
        }
        if (this.m_bSingleValued) {
            return this.m_mask == null ? 1 : (this.m_mask.get(doc) ? 1 : 0);
        }
        return this.m_positions[doc + 1] - this.m_positions[doc];
    }

    public long get(int doc, int index) {
        int sz = this.size(doc);
        if (index < 0 || index >= sz) {
            throw new RuntimeException("Index out of range: " + index);
        }
        if (this.m_bSingleValued) {
            return this.m_values.get(doc);
        }
        return this.m_values.get(this.m_positions[doc] + index);
    }

    public boolean sv_isNull(int doc) {
        if (this.m_values == null) {
            return true;
        }
        if (this.m_bSingleValued) {
            return this.m_mask == null ? false : !this.m_mask.get(doc);
        }
        return this.m_positions[doc + 1] == this.m_positions[doc];
    }

    public long sv_get(int doc) {
        if (this.sv_isNull(doc)) {
            throw new RuntimeException("sv_get: no value");
        }
        if (this.m_bSingleValued) {
            return this.m_values.get(doc);
        }
        return this.m_values.get(this.m_positions[doc + 1] - 1);
    }

    public boolean isNull(int doc) {
        return this.size(doc) == 0;
    }

    public void fill(long value, Result r) {
        if (this.m_values == null) {
            return;
        }
        if (this.m_bSingleValued) {
            int i = 0;
            while (i < this.m_values.size()) {
                if (!this.sv_isNull(i) && this.m_values.get(i) == value) {
                    r.set(i);
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.size()) {
                int sz = this.size(i);
                int j = 0;
                while (j < sz) {
                    if (this.get(i, j) == value) {
                        r.set(i);
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    public void fillNull(Result r) {
        r.clear();
        if (this.m_values == null) {
            r.not();
            return;
        }
        if (this.m_bSingleValued) {
            if (this.m_mask == null) {
                return;
            }
            int i = 0;
            while (i < this.m_values.size()) {
                if (this.sv_isNull(i)) {
                    r.set(i);
                }
                ++i;
            }
        } else {
            this.fillCount(0, 1, r);
        }
    }

    public void fill(long start, long finish, Result r) {
        if (this.m_values == null) {
            return;
        }
        if (this.m_bSingleValued) {
            int i = 0;
            while (i < this.m_values.size()) {
                if (!this.sv_isNull(i) && this.m_values.get(i) >= start && this.m_values.get(i) < finish) {
                    r.set(i);
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.size()) {
                int sz = this.size(i);
                int j = 0;
                while (j < sz) {
                    if (this.get(i, j) >= start && this.get(i, j) < finish) {
                        r.set(i);
                        break;
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    public void fillCount(int min, int max, Result r) {
        if (this.m_values == null) {
            return;
        }
        int i = 0;
        while (i < this.size()) {
            int sz = this.size(i);
            if (sz >= min && sz < max) {
                r.set(i);
            }
            ++i;
        }
    }

    public static boolean isNumericType(FieldType type) {
        return type == FieldType.BOOLEAN || type == FieldType.INTEGER || type == FieldType.LONG || type == FieldType.TIMESTAMP || type == FieldType.DOUBLE || type == FieldType.FLOAT;
    }

    public static long parse(String value, FieldType type) {
        if (type == FieldType.BOOLEAN) {
            return value.equalsIgnoreCase("true") ? 1 : 0;
        }
        if (type == FieldType.INTEGER || type == FieldType.LONG) {
            return Long.parseLong(value);
        }
        if (type == FieldType.TIMESTAMP) {
            return new DateTrie().parse(value).getTime();
        }
        if (type == FieldType.FLOAT) {
            return Float.floatToRawIntBits(Float.parseFloat(value));
        }
        if (type == FieldType.DOUBLE) {
            return Double.doubleToRawLongBits(Double.parseDouble(value));
        }
        throw new RuntimeException("Invalid numeric type: " + type);
    }

    public static String format(long value, FieldType type) {
        if (type == FieldType.BOOLEAN) {
            return value == 1L ? "True" : "False";
        }
        if (type == FieldType.INTEGER || type == FieldType.LONG) {
            return "" + value;
        }
        if (type == FieldType.TIMESTAMP) {
            return value == 0L ? null : XType.toString(new Date(value));
        }
        if (type == FieldType.FLOAT) {
            return Double.toString(Float.intBitsToFloat((int)value));
        }
        if (type == FieldType.DOUBLE) {
            return Double.toString(Double.longBitsToDouble(value));
        }
        throw new RuntimeException("Invalid numeric type: " + type);
    }

    public long cacheSize() {
        return 16L + (this.m_values == null ? 0L : this.m_values.cacheSize()) + (long)(this.m_mask == null ? 0 : this.m_mask.getBuffer().length);
    }
}

