/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.olap.store;

import com.dell.doradus.olap.io.VInputStream;
import com.dell.doradus.olap.io.VOutputStream;
import com.dell.doradus.olap.store.BitVector;

public class NumArray {
    private int m_bits;
    private NumA m_array;

    public NumArray(VInputStream input) {
        int size = input.readVInt();
        this.m_bits = input.readByte();
        if (this.m_bits == 0) {
            this.m_array = new ZeroA(size, input);
        } else if (this.m_bits == 1) {
            this.m_array = new BitA(size, input);
        } else if (this.m_bits == 8) {
            this.m_array = new ByteA(size, input);
        } else if (this.m_bits == 16) {
            this.m_array = new ShortA(size, input);
        } else if (this.m_bits == 32) {
            this.m_array = new IntA(size, input);
        } else if (this.m_bits == 64) {
            this.m_array = new LongA(size, input);
        } else {
            throw new RuntimeException("Unknown bits: " + this.m_bits);
        }
    }

    public int size() {
        return this.m_array.size();
    }

    public long get(int index) {
        return this.m_array.get(index);
    }

    public static byte writeArray(VOutputStream output, long[] values, int size, long min, long max) {
        output.writeVInt(size);
        byte bits = -1;
        if (size == 0 || max == 0L && min == 0L) {
            bits = 0;
            output.writeByte(bits);
            ZeroA.writeData(output, values, size);
        } else if (max <= 1L && min >= 0L) {
            bits = 1;
            output.writeByte(bits);
            BitA.writeData(output, values, size);
        } else if (max <= 127L && min >= -128L) {
            bits = 8;
            output.writeByte(bits);
            ByteA.writeData(output, values, size);
        } else if (max <= 32767L && min >= -32768L) {
            bits = 16;
            output.writeByte(bits);
            ShortA.writeData(output, values, size);
        } else if (max <= Integer.MAX_VALUE && min >= Integer.MIN_VALUE) {
            bits = 32;
            output.writeByte(bits);
            IntA.writeData(output, values, size);
        } else {
            bits = 64;
            output.writeByte(bits);
            LongA.writeData(output, values, size);
        }
        return bits;
    }

    public long cacheSize() {
        return 8 + this.m_array.cacheSize();
    }

    public static class BitA
    implements NumA {
        private BitVector m_bitArray;

        public BitA(int size, VInputStream input) {
            this.m_bitArray = new BitVector(size);
            input.read(this.m_bitArray.getBuffer(), 0, this.m_bitArray.getBuffer().length);
        }

        @Override
        public int cacheSize() {
            return 4 + this.m_bitArray.getBuffer().length;
        }

        @Override
        public int size() {
            return this.m_bitArray.size();
        }

        @Override
        public long get(int index) {
            return this.m_bitArray.get(index) ? 1 : 0;
        }

        public static void writeData(VOutputStream output, long[] values, int size) {
            BitVector bitArray = new BitVector(size);
            int i = 0;
            while (i < size) {
                if (values[i] != 0L) {
                    bitArray.set(i);
                }
                ++i;
            }
            byte[] buf = bitArray.getBuffer();
            output.write(buf, 0, buf.length);
        }
    }

    public static class ByteA
    implements NumA {
        private byte[] m_array;

        public ByteA(int size, VInputStream input) {
            this.m_array = new byte[size];
            input.read(this.m_array, 0, this.m_array.length);
        }

        @Override
        public int cacheSize() {
            return 4 + this.m_array.length;
        }

        @Override
        public int size() {
            return this.m_array.length;
        }

        @Override
        public long get(int index) {
            return this.m_array[index];
        }

        public static void writeData(VOutputStream output, long[] values, int size) {
            int i = 0;
            while (i < size) {
                output.writeByte((byte)values[i]);
                ++i;
            }
        }
    }

    public static class IntA
    implements NumA {
        private int[] m_array;

        public IntA(int size, VInputStream input) {
            this.m_array = new int[size];
            int i = 0;
            while (i < this.m_array.length) {
                this.m_array[i] = input.readInt();
                ++i;
            }
        }

        @Override
        public int cacheSize() {
            return 4 + this.m_array.length * 4;
        }

        @Override
        public int size() {
            return this.m_array.length;
        }

        @Override
        public long get(int index) {
            return this.m_array[index];
        }

        public static void writeData(VOutputStream output, long[] values, int size) {
            int i = 0;
            while (i < size) {
                output.writeInt((int)values[i]);
                ++i;
            }
        }
    }

    public static class LongA
    implements NumA {
        private long[] m_array;

        public LongA(int size, VInputStream input) {
            this.m_array = new long[size];
            int i = 0;
            while (i < this.m_array.length) {
                this.m_array[i] = input.readLong();
                ++i;
            }
        }

        @Override
        public int cacheSize() {
            return 4 + this.m_array.length * 8;
        }

        @Override
        public int size() {
            return this.m_array.length;
        }

        @Override
        public long get(int index) {
            return this.m_array[index];
        }

        public static void writeData(VOutputStream output, long[] values, int size) {
            int i = 0;
            while (i < size) {
                output.writeLong(values[i]);
                ++i;
            }
        }
    }

    public static class MinA
    implements NumA {
        private long m_min;
        private NumA m_array;

        public MinA(int size, VInputStream input) {
            this.m_min = input.readVLong();
            int bits = input.readByte();
            if (bits == 0) {
                this.m_array = new ZeroA(size, input);
            } else if (bits == 1) {
                this.m_array = new BitA(size, input);
            } else if (bits == 8) {
                this.m_array = new ByteA(size, input);
            } else if (bits == 16) {
                this.m_array = new ShortA(size, input);
            } else if (bits == 32) {
                this.m_array = new IntA(size, input);
            } else {
                throw new RuntimeException("Invalid bits in MinA: " + bits);
            }
        }

        @Override
        public int cacheSize() {
            return 4 + this.m_array.cacheSize();
        }

        @Override
        public int size() {
            return this.m_array.size();
        }

        @Override
        public long get(int index) {
            return this.m_array.get(index) + this.m_min;
        }

        public static void writeData(VOutputStream output, long[] values, int size, long min, byte bits) {
            output.writeVLong(min);
            output.writeByte(bits);
            if (bits == 0) {
                ZeroA.writeData(output, values, size);
            } else if (bits == 1) {
                BitA.writeData(output, values, size);
            } else if (bits == 8) {
                ByteA.writeData(output, values, size);
            } else if (bits == 16) {
                ShortA.writeData(output, values, size);
            } else if (bits == 32) {
                IntA.writeData(output, values, size);
            } else {
                throw new RuntimeException("Invalid bits in MinA: " + bits);
            }
        }
    }

    public static interface NumA {
        public int cacheSize();

        public int size();

        public long get(int var1);
    }

    public static class ShortA
    implements NumA {
        private short[] m_array;

        public ShortA(int size, VInputStream input) {
            this.m_array = new short[size];
            int i = 0;
            while (i < this.m_array.length) {
                this.m_array[i] = input.readShort();
                ++i;
            }
        }

        @Override
        public int cacheSize() {
            return 4 + this.m_array.length * 2;
        }

        @Override
        public int size() {
            return this.m_array.length;
        }

        @Override
        public long get(int index) {
            return this.m_array[index];
        }

        public static void writeData(VOutputStream output, long[] values, int size) {
            int i = 0;
            while (i < size) {
                output.writeShort((short)values[i]);
                ++i;
            }
        }
    }

    public static class ZeroA
    implements NumA {
        private int m_size;

        public ZeroA(int size, VInputStream input) {
            this.m_size = size;
        }

        @Override
        public int cacheSize() {
            return 4;
        }

        @Override
        public int size() {
            return this.m_size;
        }

        @Override
        public long get(int index) {
            return 0L;
        }

        public static void writeData(VOutputStream output, long[] values, int size) {
        }
    }
}

