/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.olap.store;

import java.util.Arrays;

public class LongList {
    private long[] m_array;
    private int m_position = 0;

    public LongList() {
        this(1024);
    }

    public LongList(int capacity) {
        this.m_array = new long[capacity];
    }

    public void add(long value) {
        if (this.m_position == this.m_array.length) {
            this.resize();
        }
        this.m_array[this.m_position++] = value;
    }

    public long get(int index) {
        if (index < 0 || index >= this.m_position) {
            throw new RuntimeException("LongList out of bounds: index=" + index + "; size=" + this.m_position);
        }
        return this.m_array[index];
    }

    public void set(int index, long value) {
        this.m_array[index] = value;
    }

    public int size() {
        return this.m_position;
    }

    private void resize() {
        long[] array = new long[this.m_array.length * 2];
        int i = 0;
        while (i < this.m_array.length) {
            array[i] = this.m_array[i];
            ++i;
        }
        this.m_array = array;
    }

    public long[] getArray() {
        return this.m_array;
    }

    public void clear() {
        this.m_position = 0;
    }

    public void sort() {
        Arrays.sort(this.m_array, 0, this.m_position);
    }

    public void shrinkToSize() {
        if (this.m_position == this.m_array.length) {
            return;
        }
        long[] array = new long[this.m_position];
        int i = 0;
        while (i < this.m_position) {
            array[i] = this.m_array[i];
            ++i;
        }
        this.m_array = array;
    }
}

