/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.olap.store;

import com.dell.doradus.olap.store.IntIterator;
import java.util.Arrays;

public class IntList {
    private int[] m_array;
    private int m_position = 0;

    public IntList() {
        this(1024);
    }

    public IntList(int capacity) {
        this.m_array = new int[capacity];
    }

    public void add(int value) {
        if (this.m_position == this.m_array.length) {
            this.resize();
        }
        this.m_array[this.m_position++] = value;
    }

    public int get(int index) {
        if (index < 0 || index >= this.m_position) {
            throw new RuntimeException("IntList out of bounds: index=" + index + "; size=" + this.m_position);
        }
        return this.m_array[index];
    }

    public void set(int index, int value) {
        this.m_array[index] = value;
    }

    public int size() {
        return this.m_position;
    }

    public void setLength(int length) {
        this.m_position = length;
    }

    public void set(IntIterator iter) {
        iter.setup(this.m_array, 0, this.m_position);
    }

    public int[] getArray() {
        return this.m_array;
    }

    public void sort() {
        Arrays.sort(this.m_array, 0, this.m_position);
    }

    public void clear() {
        this.m_position = 0;
    }

    private void resize() {
        int[] array = new int[this.m_array.length * 2];
        int i = 0;
        while (i < this.m_array.length) {
            array[i] = this.m_array[i];
            ++i;
        }
        this.m_array = array;
    }

    public void shrinkToSize() {
        if (this.m_position == this.m_array.length) {
            return;
        }
        int[] array = new int[this.m_position];
        int i = 0;
        while (i < this.m_position) {
            array[i] = this.m_array[i];
            ++i;
        }
        this.m_array = array;
    }
}

