/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.olap.store;

import com.dell.doradus.olap.io.BSTR;
import com.dell.doradus.olap.io.VDirectory;
import com.dell.doradus.olap.io.VOutputStream;
import com.dell.doradus.olap.store.BitVector;

public class IdWriter {
    public static int SPAN = 1024;
    private VDirectory m_dir;
    private String m_table;
    private VOutputStream m_stream_id;
    private VOutputStream m_stream_idx;
    private int m_documents;
    private BSTR m_last = new BSTR();
    private long m_last_position = 0L;

    public IdWriter(VDirectory dir, String table) {
        this.m_dir = dir;
        this.m_table = table;
        this.m_documents = 0;
        this.m_last.length = -1;
    }

    public int add(BSTR id) {
        if (!BSTR.isEqual(this.m_last, id)) {
            this.flush();
            this.m_last.set(id);
        }
        return this.m_documents;
    }

    public void removeLastId(BSTR id) {
        if (this.m_last.length != -1 && !BSTR.isEqual(id, this.m_last)) {
            throw new RuntimeException("Wrong canceled ID specified");
        }
        this.m_last.length = -1;
    }

    private void flush() {
        if (this.m_last.length < 0) {
            return;
        }
        if (this.m_stream_id == null) {
            this.m_stream_id = this.m_dir.create(String.valueOf(this.m_table) + "._id");
            this.m_stream_idx = this.m_dir.create(String.valueOf(this.m_table) + ".idx");
        }
        if (this.m_documents % SPAN == 0) {
            this.m_stream_idx.write(this.m_last);
            long new_position = this.m_stream_id.position();
            this.m_stream_idx.writeVLong(new_position - this.m_last_position);
            this.m_last_position = new_position;
        }
        this.m_stream_id.writeVString(this.m_last);
        this.m_last.length = -1;
        ++this.m_documents;
    }

    public void setDeletedVector(BitVector bvDeleted) {
        VOutputStream del_stream = this.m_dir.create(String.valueOf(this.m_table) + "._id.deleted");
        del_stream.writeVInt(bvDeleted.size());
        del_stream.write(bvDeleted.getBuffer(), 0, bvDeleted.getBuffer().length);
        del_stream.close();
    }

    public int size() {
        return this.m_documents + (this.m_last.length == -1 ? 0 : 1);
    }

    public void close() {
        this.flush();
        if (this.m_stream_id != null) {
            this.m_stream_id.close();
            this.m_stream_idx.close();
        }
    }
}

