/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.olap.store;

import com.dell.doradus.olap.io.BSTR;
import com.dell.doradus.olap.io.VDirectory;
import com.dell.doradus.olap.io.VInputStream;
import com.dell.doradus.olap.store.IdWriter;
import com.dell.doradus.olap.store.SegmentStats;

public class IdSearcher {
    private VInputStream m_stream_id;
    private BSTR[] m_idx_ids;
    private long[] m_idx_offsets;
    private int m_size = 0;
    private BSTR m_bstr = new BSTR();
    private int m_cur_doc = -1;

    public IdSearcher(IdSearcher searcher) {
        this.m_stream_id = searcher.m_stream_id == null ? null : new VInputStream(searcher.m_stream_id);
        this.m_idx_ids = searcher.m_idx_ids;
        this.m_idx_offsets = searcher.m_idx_offsets;
        this.m_size = searcher.m_size;
        this.m_bstr = new BSTR(searcher.m_bstr);
        this.m_cur_doc = searcher.m_cur_doc;
    }

    public IdSearcher(VDirectory dir, SegmentStats.Table tableStats) {
        if (tableStats == null) {
            return;
        }
        String table = tableStats.name;
        this.m_size = tableStats.documents;
        this.m_bstr.length = -1;
        if (!dir.fileExists(String.valueOf(table) + "._id")) {
            return;
        }
        this.m_stream_id = dir.open(String.valueOf(table) + "._id");
        this.m_stream_id.seek(0L);
        this.m_idx_ids = new BSTR[(this.m_size + IdWriter.SPAN - 1) / IdWriter.SPAN];
        this.m_idx_offsets = new long[this.m_idx_ids.length];
        VInputStream stream_idx = dir.open(String.valueOf(table) + ".idx");
        long last_offset = 0L;
        int i = 0;
        while (i < this.m_idx_ids.length) {
            stream_idx.read(this.m_bstr);
            this.m_idx_ids[i] = new BSTR(this.m_bstr);
            last_offset = this.m_idx_offsets[i] = last_offset + stream_idx.readVLong();
            ++i;
        }
    }

    public int size() {
        return this.m_size;
    }

    public int curDoc() {
        return this.m_cur_doc;
    }

    public BSTR curId() {
        return this.m_bstr;
    }

    public BSTR getId(int doc) {
        if (doc == this.m_cur_doc) {
            return this.m_bstr;
        }
        if (this.m_cur_doc < doc && this.m_cur_doc / IdWriter.SPAN == doc / IdWriter.SPAN) {
            while (this.m_cur_doc < doc) {
                ++this.m_cur_doc;
                this.m_stream_id.readVString(this.m_bstr);
            }
        } else {
            this.m_stream_id.seek(this.m_idx_offsets[doc / IdWriter.SPAN]);
            this.m_bstr.set(this.m_idx_ids[doc / IdWriter.SPAN]);
            int i = 0;
            while (i <= doc % IdWriter.SPAN) {
                this.m_stream_id.readVString(this.m_bstr);
                ++i;
            }
            this.m_cur_doc = doc;
        }
        return this.m_bstr;
    }

    public void reset() {
        if (this.m_stream_id == null) {
            return;
        }
        this.m_stream_id.seek(0L);
        this.m_bstr.length = -1;
        this.m_cur_doc = -1;
    }

    public boolean next() {
        if (this.m_cur_doc >= this.m_size) {
            throw new RuntimeException("Read past the end of IDSearcher");
        }
        ++this.m_cur_doc;
        if (this.m_cur_doc >= this.m_size) {
            return false;
        }
        this.m_stream_id.readVString(this.m_bstr);
        return true;
    }

    public int find(BSTR id, boolean exact) {
        if (this.m_size == 0) {
            return -1;
        }
        int min = 0;
        int max = this.m_idx_ids.length;
        while (max - min > 1) {
            int mid = (max + min) / 2;
            int c = BSTR.compare(id, this.m_idx_ids[mid]);
            if (c < 0) {
                max = mid;
                continue;
            }
            min = mid;
        }
        this.m_stream_id.seek(this.m_idx_offsets[min]);
        this.m_cur_doc = min * IdWriter.SPAN;
        this.m_bstr.set(this.m_idx_ids[min]);
        this.m_stream_id.readVString(this.m_bstr);
        while (!this.m_stream_id.end() && BSTR.compare(id, this.m_bstr) > 0) {
            ++this.m_cur_doc;
            this.m_stream_id.readVString(this.m_bstr);
        }
        if (exact && !BSTR.isEqual(id, this.m_bstr)) {
            return -1;
        }
        return this.m_cur_doc;
    }

    public int findNext(BSTR id) {
        if (this.m_size == 0) {
            return -1;
        }
        if (this.m_cur_doc == -1) {
            return this.find(id, true);
        }
        if (this.m_cur_doc >= this.m_size) {
            return -1;
        }
        int curIdx = this.m_cur_doc / IdWriter.SPAN;
        if (curIdx == this.m_idx_ids.length - 1 || BSTR.compare(id, this.m_bstr) >= 0 && BSTR.compare(id, this.m_idx_ids[curIdx + 1]) < 0) {
            while (!this.m_stream_id.end() && BSTR.compare(id, this.m_bstr) > 0) {
                ++this.m_cur_doc;
                this.m_stream_id.readVString(this.m_bstr);
            }
            if (!BSTR.isEqual(id, this.m_bstr)) {
                return -1;
            }
            return this.m_cur_doc;
        }
        return this.find(id, true);
    }

    public long cacheSize() {
        long size = 1024 + this.m_bstr.buffer.length;
        if (this.m_idx_ids != null) {
            BSTR[] bSTRArray = this.m_idx_ids;
            int n = this.m_idx_ids.length;
            int n2 = 0;
            while (n2 < n) {
                BSTR b = bSTRArray[n2];
                size += (long)b.buffer.length;
                ++n2;
            }
        }
        if (this.m_idx_offsets != null) {
            size += (long)(8 * this.m_idx_offsets.length);
        }
        return size;
    }
}

