/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.olap.store;

import com.dell.doradus.olap.io.VDirectory;
import com.dell.doradus.olap.io.VOutputStream;

public class FieldWriterSV {
    private int[] m_docs;
    private int m_maxTerm = -1;
    private int m_docsCount;

    public FieldWriterSV(int docsCount) {
        this.m_docsCount = docsCount;
        this.m_docs = new int[docsCount];
        int i = 0;
        while (i < docsCount) {
            this.m_docs[i] = -1;
            ++i;
        }
    }

    public int getDocsCount() {
        return this.m_docsCount;
    }

    public int getValuesCount() {
        return this.m_maxTerm + 1;
    }

    public void set(int doc, int term) {
        if (term < 0) {
            return;
        }
        if (this.m_maxTerm < term) {
            this.m_maxTerm = term;
        }
        this.m_docs[doc] = term;
    }

    public void close(VDirectory dir, String table, String field) {
        if (this.m_maxTerm == -1) {
            return;
        }
        VOutputStream out_doc = dir.create(String.valueOf(table) + "." + field + ".doc");
        out_doc.writeVInt(this.m_docsCount);
        int i = 0;
        while (i < this.m_docs.length) {
            out_doc.writeVInt(this.m_docs[i] + 1);
            ++i;
        }
        out_doc.close();
    }
}

