/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.olap.store;

import com.dell.doradus.olap.io.VDirectory;
import com.dell.doradus.olap.io.VOutputStream;
import com.dell.doradus.olap.store.IntList;

public class FieldWriter {
    private IntList m_doc;
    private int[] m_len;
    private boolean m_isSingleValued = true;
    private int m_lastDoc = -1;
    private int m_lastTerm = -1;
    private int m_maxTerm = -1;
    private int m_docsCount;

    public FieldWriter(int docsCount) {
        this.m_docsCount = docsCount;
        this.m_doc = new IntList(docsCount);
        this.m_len = new int[docsCount];
    }

    public boolean isSingleValued() {
        return this.m_isSingleValued;
    }

    public int getDocsCount() {
        return this.m_docsCount;
    }

    public int getEntriesCount() {
        if (this.m_isSingleValued) {
            return this.getDocsCount();
        }
        return this.m_doc.size();
    }

    public int getValuesCount() {
        return this.m_maxTerm + 1;
    }

    public void add(int doc, int term) {
        if (this.m_lastDoc == doc && this.m_lastTerm == term) {
            return;
        }
        if (this.m_lastDoc > doc) {
            throw new RuntimeException("Invalid doc order");
        }
        if (this.m_maxTerm < term) {
            this.m_maxTerm = term;
        }
        if (this.m_lastDoc == doc) {
            this.m_isSingleValued = false;
            if (this.m_lastTerm > term) {
                throw new RuntimeException("Invalid term order");
            }
        } else {
            this.m_lastDoc = doc;
        }
        this.m_doc.add(term);
        int n = doc;
        this.m_len[n] = this.m_len[n] + 1;
        this.m_lastTerm = term;
    }

    public void close(VDirectory dir, String table, String field) {
        if (this.m_isSingleValued) {
            VOutputStream out_doc = dir.create(String.valueOf(table) + "." + field + ".doc");
            out_doc.writeVInt(this.m_len.length);
            int start = 0;
            int i = 0;
            while (i < this.m_len.length) {
                int len = this.m_len[i];
                if (len == 0) {
                    out_doc.writeVInt(0);
                } else {
                    int j = 0;
                    while (j < len) {
                        out_doc.writeVInt(this.m_doc.get(start++) + 1);
                        ++j;
                    }
                }
                ++i;
            }
            out_doc.close();
            if (start != this.m_doc.size()) {
                throw new RuntimeException("FieldWriter: inconsistency in sv mode");
            }
        } else {
            VOutputStream out_doc = dir.create(String.valueOf(table) + "." + field + ".doc");
            VOutputStream out_pos = dir.create(String.valueOf(table) + "." + field + ".pos");
            out_pos.writeVInt(this.m_len.length);
            out_doc.writeVInt(this.m_doc.size());
            int start = 0;
            int i = 0;
            while (i < this.m_len.length) {
                int len = this.m_len[i];
                out_pos.writeVInt(len);
                int doc = 0;
                int j = 0;
                while (j < len) {
                    int next_doc = this.m_doc.get(start++);
                    out_doc.writeVInt(next_doc - doc);
                    doc = next_doc;
                    ++j;
                }
                ++i;
            }
            out_doc.close();
            out_pos.close();
            if (start != this.m_doc.size()) {
                throw new RuntimeException("FieldWriter: inconsistency in mv mode");
            }
        }
    }
}

