/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.olap.store;

import com.dell.doradus.olap.io.VDirectory;
import com.dell.doradus.olap.io.VInputStream;
import com.dell.doradus.olap.search.Result;
import com.dell.doradus.olap.store.IntIterator;

public class FieldSearcher {
    private int m_documents;
    private int m_fields;
    private boolean m_bSingleValued;
    private int[] m_docterms;
    private int[] m_positions;

    public FieldSearcher(VDirectory dir, String table, String field) {
        if (dir.fileExists(table + "." + field + ".inverse")) {
            int i;
            int fld;
            int j;
            int len;
            int doc;
            VInputStream input = dir.open(table + "." + field + ".inverse");
            String inv_table = input.readString();
            String inv_field = input.readString();
            this.m_documents = input.readVInt();
            this.m_fields = input.readVInt();
            FieldSearcher searcher = new FieldSearcher(dir, inv_table, inv_field);
            this.m_bSingleValued = true;
            boolean m_bEmpty = true;
            int[] lengths = new int[this.m_documents];
            for (doc = 0; doc < searcher.size(); ++doc) {
                len = searcher.fieldsCount(doc);
                for (j = 0; j < len; ++j) {
                    int n = fld = searcher.getField(doc, j);
                    lengths[n] = lengths[n] + 1;
                    m_bEmpty = false;
                    if (lengths[fld] <= 1) continue;
                    this.m_bSingleValued = false;
                }
            }
            if (m_bEmpty) {
                return;
            }
            if (this.m_bSingleValued) {
                this.m_docterms = new int[this.m_documents];
                for (i = 0; i < this.m_docterms.length; ++i) {
                    this.m_docterms[i] = -1;
                }
                for (doc = 0; doc < searcher.size(); ++doc) {
                    len = searcher.fieldsCount(doc);
                    for (j = 0; j < len; ++j) {
                        fld = searcher.getField(doc, j);
                        this.m_docterms[fld] = doc;
                    }
                }
            } else {
                this.m_positions = new int[this.m_documents + 1];
                this.m_positions[0] = 0;
                for (i = 0; i < this.m_documents; ++i) {
                    this.m_positions[i + 1] = this.m_positions[i] + lengths[i];
                }
                this.m_docterms = new int[this.m_positions[this.m_documents]];
                for (i = 0; i < this.m_docterms.length; ++i) {
                    this.m_docterms[i] = -1;
                }
                for (i = 0; i < this.m_documents; ++i) {
                    lengths[i] = 0;
                }
                for (doc = 0; doc < searcher.size(); ++doc) {
                    len = searcher.fieldsCount(doc);
                    for (j = 0; j < len; ++j) {
                        fld = searcher.getField(doc, j);
                        this.m_docterms[this.m_positions[fld] + lengths[fld]] = doc;
                        int n = fld;
                        lengths[n] = lengths[n] + 1;
                    }
                }
            }
            return;
        }
        if (!dir.fileExists(table + "." + field + ".doc")) {
            return;
        }
        if (dir.fileExists(table + "." + field + ".pos")) {
            this.m_bSingleValued = false;
            VInputStream inp_pos = dir.open(table + "." + field + ".pos");
            VInputStream inp_doc = dir.open(table + "." + field + ".doc");
            this.m_documents = inp_pos.readVInt();
            this.m_positions = new int[this.m_documents + 1];
            int docsSize = inp_doc.readVInt();
            this.m_docterms = new int[docsSize];
            this.m_positions[0] = 0;
            for (int i = 0; i < this.m_documents; ++i) {
                int sz = inp_pos.readVInt();
                this.m_positions[i + 1] = this.m_positions[i] + sz;
                int term = 0;
                for (int j = 0; j < sz; ++j) {
                    if (this.m_fields < (term += inp_doc.readVInt()) + 1) {
                        this.m_fields = term + 1;
                    }
                    this.m_docterms[this.m_positions[i] + j] = term;
                }
            }
        } else {
            this.m_bSingleValued = true;
            VInputStream inp_doc = dir.open(table + "." + field + ".doc");
            this.m_documents = inp_doc.readVInt();
            this.m_docterms = new int[this.m_documents];
            for (int i = 0; i < this.m_documents; ++i) {
                int term;
                this.m_docterms[i] = term = inp_doc.readVInt() - 1;
                if (this.m_fields >= term + 1) continue;
                this.m_fields = term + 1;
            }
        }
    }

    public int size() {
        if (this.m_docterms == null) {
            return 0;
        }
        return this.m_bSingleValued ? this.m_docterms.length : this.m_positions.length - 1;
    }

    public int fields() {
        return this.m_fields;
    }

    public boolean isSingleValued() {
        return this.m_bSingleValued;
    }

    public int sv_get(int doc) {
        if (this.m_docterms == null) {
            return -1;
        }
        if (this.m_bSingleValued) {
            return this.m_docterms[doc];
        }
        return this.m_positions[doc] == this.m_positions[doc + 1] ? -1 : this.m_docterms[this.m_positions[doc]];
    }

    public int fieldsCount(int doc) {
        if (this.m_docterms == null) {
            return 0;
        }
        if (this.m_bSingleValued) {
            return this.m_docterms[doc] < 0 ? 0 : 1;
        }
        return this.m_positions[doc + 1] - this.m_positions[doc];
    }

    public int getField(int doc, int index) {
        if (this.m_bSingleValued) {
            return this.m_docterms[doc];
        }
        return this.m_docterms[this.m_positions[doc] + index];
    }

    public void fields(int doc, IntIterator iter) {
        if (this.m_docterms == null) {
            iter.setup(null, 0, 0);
        } else if (this.m_bSingleValued) {
            iter.setup(this.m_docterms, doc, this.m_docterms[doc] < 0 ? 0 : 1);
        } else {
            iter.setup(this.m_docterms, this.m_positions[doc], this.m_positions[doc + 1] - this.m_positions[doc]);
        }
    }

    public void fields(Result src, Result dst) {
        if (this.m_docterms == null) {
            return;
        }
        if (this.m_bSingleValued) {
            for (int i = 0; i < this.m_documents; ++i) {
                if (!src.get(i) || this.m_docterms[i] == -1) continue;
                dst.set(this.m_docterms[i]);
            }
        } else {
            for (int i = 0; i < this.m_documents; ++i) {
                if (!src.get(i)) continue;
                int st = this.m_positions[i];
                int fn = this.m_positions[i + 1];
                for (int j = st; j < fn; ++j) {
                    dst.set(this.m_docterms[j]);
                }
            }
        }
    }

    public void fillDocs(Result valuesSet, Result docsSet) {
        if (this.m_docterms == null) {
            return;
        }
        if (this.m_bSingleValued) {
            for (int i = 0; i < this.m_documents; ++i) {
                int value = this.m_docterms[i];
                if (value == -1 || !valuesSet.get(value)) continue;
                docsSet.set(i);
            }
        } else {
            block1: for (int i = 0; i < this.m_documents; ++i) {
                int st = this.m_positions[i];
                int fn = this.m_positions[i + 1];
                for (int j = st; j < fn; ++j) {
                    int value = this.m_docterms[j];
                    if (value == -1 || !valuesSet.get(value)) continue;
                    docsSet.set(i);
                    continue block1;
                }
            }
        }
    }

    public void fillValues(Result docsSet, Result valuesSet) {
        if (this.m_docterms == null) {
            return;
        }
        if (this.m_bSingleValued) {
            for (int i = 0; i < this.m_documents; ++i) {
                int value;
                if (!docsSet.get(i) || (value = this.m_docterms[i]) == -1) continue;
                valuesSet.set(value);
            }
        } else {
            for (int i = 0; i < this.m_documents; ++i) {
                if (!docsSet.get(i)) continue;
                int st = this.m_positions[i];
                int fn = this.m_positions[i + 1];
                for (int j = st; j < fn; ++j) {
                    int value = this.m_docterms[j];
                    if (value == -1) continue;
                    valuesSet.set(value);
                }
            }
        }
    }

    public void fill(int term, Result r) {
        if (this.m_docterms == null) {
            return;
        }
        if (this.m_bSingleValued) {
            for (int i = 0; i < this.m_documents; ++i) {
                if (this.m_docterms[i] != term) continue;
                r.set(i);
            }
        } else {
            for (int i = 0; i < this.m_documents; ++i) {
                int st = this.m_positions[i];
                int fn = this.m_positions[i + 1];
                for (int j = st; j < fn; ++j) {
                    if (this.m_docterms[j] != term) continue;
                    r.set(i);
                }
            }
        }
    }

    public void fill(int min, int max, Result r) {
        if (this.m_docterms == null) {
            return;
        }
        if (this.m_bSingleValued) {
            for (int i = 0; i < this.m_documents; ++i) {
                if (this.m_docterms[i] < min || this.m_docterms[i] >= max || this.m_docterms[i] == -1) continue;
                r.set(i);
            }
        } else {
            for (int i = 0; i < this.m_documents; ++i) {
                int st = this.m_positions[i];
                int fn = this.m_positions[i + 1];
                for (int j = st; j < fn; ++j) {
                    if (this.m_docterms[j] < min || this.m_docterms[j] >= max) continue;
                    r.set(i);
                }
            }
        }
    }

    public void fillCount(int min, int max, Result r) {
        if (this.m_docterms == null) {
            r.clear();
            if (min <= 0 && max > 0) {
                r.not();
            }
            return;
        }
        if (this.m_bSingleValued) {
            for (int i = 0; i < this.m_documents; ++i) {
                int count;
                int n = count = this.m_docterms[i] == -1 ? 0 : 1;
                if (min > count || max <= count) continue;
                r.set(i);
            }
        } else {
            for (int i = 0; i < this.m_documents; ++i) {
                int count = this.m_positions[i + 1] - this.m_positions[i];
                if (min > count || max <= count) continue;
                r.set(i);
            }
        }
    }

    public void fillCount(int min, int max, Result filter, Result r) {
        if (this.m_docterms == null) {
            r.clear();
            if (min <= 0 && max > 0) {
                r.not();
            }
            return;
        }
        IntIterator iter = new IntIterator();
        for (int doc = 0; doc < this.m_documents; ++doc) {
            this.fields(doc, iter);
            int count = 0;
            for (int i = 0; i < iter.count(); ++i) {
                int field = iter.get(i);
                if (!filter.get(field)) continue;
                ++count;
            }
            if (min > count || max <= count) continue;
            r.set(doc);
        }
    }

    public long cacheSize() {
        return 16L + (long)(this.m_docterms == null ? 0 : this.m_docterms.length * 4) + (long)(this.m_positions == null ? 0 : this.m_positions.length * 4);
    }
}

