/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.olap.store;

import com.dell.doradus.olap.FieldsCache;
import com.dell.doradus.olap.io.VDirectory;
import com.dell.doradus.olap.store.FieldSearcher;
import com.dell.doradus.olap.store.IdSearcher;
import com.dell.doradus.olap.store.NumSearcherMV;
import com.dell.doradus.olap.store.SegmentStats;
import com.dell.doradus.olap.store.ValueSearcher;

public class CubeSearcher {
    private VDirectory m_directory;
    private SegmentStats m_stats;
    private FieldsCache m_fieldsCache;

    public CubeSearcher(VDirectory directory, FieldsCache fieldsCache) {
        this.m_directory = directory;
        this.m_stats = SegmentStats.load(directory);
        this.m_fieldsCache = fieldsCache;
    }

    public String getId() {
        return this.m_directory.getRow();
    }

    public SegmentStats getStats() {
        return this.m_stats;
    }

    public int getDocs(String table) {
        SegmentStats.Table t = this.m_stats.getTable(table);
        return t == null ? 0 : t.documents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IdSearcher getIdSearcher(String table) {
        String key = String.valueOf(this.getId()) + "/id/" + table;
        CubeSearcher cubeSearcher = this;
        synchronized (cubeSearcher) {
            IdSearcher s = (IdSearcher)this.m_fieldsCache.get(key);
            if (s == null) {
                s = new IdSearcher(this.m_directory, this.m_stats.getTable(table));
                this.m_fieldsCache.put(key, s, s.cacheSize() + (long)(2 * key.length()));
            }
            return new IdSearcher(s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FieldSearcher getFieldSearcher(String table, String field) {
        String key = String.valueOf(this.getId()) + "/fld/" + table + "/" + field;
        CubeSearcher cubeSearcher = this;
        synchronized (cubeSearcher) {
            FieldSearcher s = (FieldSearcher)this.m_fieldsCache.get(key);
            if (s == null) {
                s = new FieldSearcher(this.m_directory, table, field);
                this.m_fieldsCache.put(key, s, s.cacheSize() + (long)(2 * key.length()));
            }
            return s;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NumSearcherMV getNumSearcher(String table, String field) {
        String key = String.valueOf(this.getId()) + "/num/" + table + "/" + field;
        CubeSearcher cubeSearcher = this;
        synchronized (cubeSearcher) {
            NumSearcherMV s = (NumSearcherMV)this.m_fieldsCache.get(key);
            if (s == null) {
                s = new NumSearcherMV(this.m_directory, table, field);
                this.m_fieldsCache.put(key, s, s.cacheSize() + (long)(2 * key.length()));
            }
            return s;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ValueSearcher getValueSearcher(String table, String field) {
        String key = String.valueOf(this.getId()) + "/val/" + table + "/" + field;
        CubeSearcher cubeSearcher = this;
        synchronized (cubeSearcher) {
            ValueSearcher s = (ValueSearcher)this.m_fieldsCache.get(key);
            if (s == null) {
                s = new ValueSearcher(this.m_directory, this.m_stats.getTextField(table, field));
                this.m_fieldsCache.put(key, s, s.cacheSize() + (long)(2 * key.length()));
            }
            return new ValueSearcher(s);
        }
    }

    public VDirectory getDirectory() {
        return this.m_directory;
    }
}

