/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.olap.store;

import com.dell.doradus.olap.collections.BitPacker;
import com.dell.doradus.olap.collections.NumericUtils;
import com.dell.doradus.olap.io.VOutputStream;

public class CompressedNumWriter {
    private VOutputStream m_output;
    private long[] m_array;
    private long[] m_packed;
    private long[] m_temp;
    private int m_position;

    public CompressedNumWriter(VOutputStream output, int chunkSize) {
        this.m_output = output;
        this.m_array = new long[chunkSize];
        this.m_packed = new long[chunkSize];
        this.m_temp = new long[chunkSize];
        this.m_output.writeVInt(chunkSize);
    }

    public void add(long value) {
        this.m_array[this.m_position++] = value;
        if (this.m_position == this.m_array.length) {
            this.flush();
        }
    }

    public void close() {
        this.flush();
    }

    public void flush() {
        long value;
        int i;
        int count = this.m_position;
        this.m_position = 0;
        if (count == 0) {
            return;
        }
        long minValue = Long.MAX_VALUE;
        long maxValue = Long.MIN_VALUE;
        int i2 = 0;
        while (i2 < count) {
            long value2 = this.m_array[i2];
            if (minValue > value2) {
                minValue = value2;
            }
            if (maxValue < value2) {
                maxValue = value2;
            }
            ++i2;
        }
        long range = maxValue - minValue;
        if (range < 0L) {
            minValue = 0L;
        }
        if (range == 0L) {
            this.m_output.writeByte((byte)3);
            this.m_output.writeVInt(count);
            this.m_output.writeVLong(minValue);
            return;
        }
        if (minValue != 0L) {
            int i3 = 0;
            while (i3 < count) {
                int n = i3++;
                this.m_array[n] = this.m_array[n] - minValue;
            }
        }
        long gcd = 0L;
        if (range > 0L) {
            i = 0;
            while (i < count) {
                long value3 = this.m_array[i];
                if ((gcd = NumericUtils.gcd(value3, gcd)) != 1L) {
                    ++i;
                    continue;
                }
                break;
            }
        } else {
            gcd = 1L;
        }
        if (gcd > 1L) {
            i = 0;
            while (i < count) {
                int n = i++;
                this.m_array[n] = this.m_array[n] / gcd;
            }
            range /= gcd;
        }
        boolean isAscending = true;
        long prev = 0L;
        int i4 = 0;
        while (i4 < count) {
            value = this.m_array[i4];
            if (value < prev) {
                isAscending = false;
                break;
            }
            prev = value;
            ++i4;
        }
        if (isAscending) {
            prev = 0L;
            range = 0L;
            i4 = 0;
            while (i4 < count) {
                value = this.m_array[i4];
                int n = i4;
                this.m_array[n] = this.m_array[n] - prev;
                prev = value;
                if (this.m_array[i4] > range) {
                    range = this.m_array[i4];
                }
                ++i4;
            }
        }
        boolean runlength = false;
        if (range > 0L) {
            long newrange = range + 1L;
            int src_pos = 0;
            int dst_pos = 0;
            int repeats = 1;
            while (src_pos < count) {
                long value4 = this.m_array[src_pos];
                repeats = 1;
                while (src_pos + repeats < count && this.m_array[src_pos + repeats] == value4) {
                    ++repeats;
                }
                if (repeats >= 16) {
                    this.m_temp[dst_pos++] = 0L;
                    this.m_temp[dst_pos++] = repeats;
                    this.m_temp[dst_pos++] = value4;
                    if (newrange < (long)repeats) {
                        newrange = repeats;
                    }
                    src_pos += repeats;
                    continue;
                }
                this.m_temp[dst_pos++] = value4 + 1L;
                ++src_pos;
            }
            int est_count = (count * BitPacker.bits(range) + 63) / 64;
            int new_est_count = (count * BitPacker.bits(newrange) + 63) / 64;
            if (new_est_count < est_count) {
                System.out.println("RUNLEN: " + count + "( " + range + ") => " + dst_pos + "( " + newrange + ")");
                runlength = true;
                System.arraycopy(this.m_temp, 0, this.m_array, 0, dst_pos);
                count = dst_pos;
                range = newrange;
                est_count = new_est_count;
            }
        }
        int bits = BitPacker.bits(range);
        boolean vint = false;
        if (bits > 8) {
            int packed_bytes = (count * bits + 63) / 64 * 8;
            int bytes = 0;
            int i5 = 0;
            while (i5 < count) {
                long value5 = this.m_array[i5];
                while (++bytes <= packed_bytes && (value5 >>= 7) > 0L) {
                }
                ++i5;
            }
            if (bytes < packed_bytes) {
                vint = true;
            }
        }
        int state = vint ? 2 : 1;
        this.m_output.writeByte((byte)state);
        this.m_output.writeVInt(count);
        this.m_output.writeVLong(minValue);
        this.m_output.writeVLong(gcd);
        this.m_output.writeByte(isAscending ? (byte)1 : 0);
        this.m_output.writeByte(runlength ? (byte)1 : 0);
        if (vint) {
            int i6 = 0;
            while (i6 < count) {
                this.m_output.writeVLong(this.m_array[i6]);
                ++i6;
            }
        } else {
            this.writePacked(this.m_array, count, bits);
        }
    }

    private void writePacked(long[] array, int count, int bits) {
        this.m_output.writeVInt(count);
        this.m_output.writeByte((byte)bits);
        int packedSize = BitPacker.pack(array, this.m_packed, count, bits);
        int i = 0;
        while (i < packedSize) {
            this.m_output.writeLong(this.m_packed[i]);
            ++i;
        }
    }
}

