/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.olap.store;

import com.dell.doradus.olap.collections.BitPacker;
import com.dell.doradus.olap.io.VInputStream;

public class CompressedNumReader {
    private VInputStream m_input;
    private long[] m_array;
    private long[] m_packed;
    private long[] m_temp;
    private int m_position;
    private int m_chunkSize;
    private int m_count;

    public CompressedNumReader(VInputStream input) {
        this.m_input = input;
        this.m_chunkSize = this.m_input.readVInt();
        this.m_array = new long[this.m_chunkSize];
        this.m_packed = new long[this.m_chunkSize];
        this.m_temp = new long[this.m_chunkSize];
        this.m_count = 0;
    }

    public long get() {
        if (this.m_position == this.m_count) {
            this.readChunk();
        }
        return this.m_array[this.m_position++];
    }

    public boolean isEnd() {
        return this.m_position == this.m_count && this.m_input.end();
    }

    private void readChunk() {
        int i;
        boolean isRunLength;
        this.m_position = 0;
        int state = this.m_input.readByte();
        this.m_count = this.m_input.readVInt();
        if (state == 3) {
            long value = this.m_input.readVLong();
            int i2 = 0;
            while (i2 < this.m_count) {
                this.m_array[i2] = value;
                ++i2;
            }
            return;
        }
        long min = this.m_input.readVLong();
        long gcd = this.m_input.readVLong();
        boolean isAscending = 1 == this.m_input.readByte();
        boolean bl = isRunLength = 1 == this.m_input.readByte();
        if (state == 2) {
            i = 0;
            while (i < this.m_count) {
                this.m_array[i] = this.m_input.readVLong();
                ++i;
            }
        } else if (state == 1) {
            this.m_count = this.readPacked(this.m_array);
        } else {
            throw new RuntimeException("Invalid state: " + state);
        }
        if (isRunLength) {
            int src_pos = 0;
            int dst_pos = 0;
            while (src_pos < this.m_count) {
                long value;
                if ((value = this.m_array[src_pos++]) != 0L) {
                    this.m_temp[dst_pos++] = value - 1L;
                    continue;
                }
                int repeats = (int)this.m_array[src_pos++];
                value = this.m_array[src_pos++];
                int j = 0;
                while (j < repeats) {
                    this.m_temp[dst_pos++] = value;
                    ++j;
                }
            }
            System.arraycopy(this.m_temp, 0, this.m_array, 0, dst_pos);
            this.m_count = dst_pos;
        }
        if (isAscending) {
            i = 1;
            while (i < this.m_count) {
                int n = i;
                this.m_array[n] = this.m_array[n] + this.m_array[i - 1];
                ++i;
            }
        }
        if (gcd != 1L) {
            i = 0;
            while (i < this.m_count) {
                int n = i++;
                this.m_array[n] = this.m_array[n] * gcd;
            }
        }
        if (min != 0L) {
            i = 0;
            while (i < this.m_count) {
                int n = i++;
                this.m_array[n] = this.m_array[n] + min;
            }
        }
    }

    private int readPacked(long[] array) {
        int count = this.m_input.readVInt();
        int bits = this.m_input.readByte();
        int packedSize = (count * bits + 63) / 64;
        int i = 0;
        while (i < packedSize) {
            this.m_packed[i] = this.m_input.readLong();
            ++i;
        }
        BitPacker.unpack(this.m_packed, array, count, bits);
        return count;
    }
}

