/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.olap.store;

import com.dell.doradus.olap.store.IntList;

public class BitVector {
    private static final int[] COUNTS = new int[256];
    private int m_size;
    private byte[] m_buffer;
    private byte m_lastMask;

    static {
        int b = 0;
        while (b < 256) {
            int cnt = 0;
            if ((b & 1) != 0) {
                ++cnt;
            }
            if ((b & 2) != 0) {
                ++cnt;
            }
            if ((b & 4) != 0) {
                ++cnt;
            }
            if ((b & 8) != 0) {
                ++cnt;
            }
            if ((b & 0x10) != 0) {
                ++cnt;
            }
            if ((b & 0x20) != 0) {
                ++cnt;
            }
            if ((b & 0x40) != 0) {
                ++cnt;
            }
            if ((b & 0x80) != 0) {
                // empty if block
            }
            BitVector.COUNTS[b] = ++cnt;
            ++b;
        }
    }

    public BitVector(int size) {
        this.m_size = size;
        this.m_buffer = new byte[(size + 7) / 8];
        this.m_lastMask = (byte)((1 << size % 8) - 1);
    }

    public int size() {
        return this.m_size;
    }

    public byte[] getBuffer() {
        return this.m_buffer;
    }

    public void set(int i) {
        int n = i / 8;
        this.m_buffer[n] = (byte)(this.m_buffer[n] | 1 << i % 8);
    }

    public void clear(int i) {
        int n = i / 8;
        this.m_buffer[n] = (byte)(this.m_buffer[n] & ~(1 << i % 8));
    }

    public boolean get(int i) {
        return (this.m_buffer[i / 8] & 1 << i % 8) != 0;
    }

    public int bitsSet() {
        int cnt = 0;
        int i = 0;
        while (i < this.m_buffer.length) {
            cnt += COUNTS[this.m_buffer[i] & 0xFF];
            ++i;
        }
        return cnt;
    }

    public void and(BitVector bv) {
        int i = 0;
        while (i < this.m_buffer.length) {
            int n = i;
            this.m_buffer[n] = (byte)(this.m_buffer[n] & bv.m_buffer[i]);
            ++i;
        }
    }

    public void or(BitVector bv) {
        int i = 0;
        while (i < this.m_buffer.length) {
            int n = i;
            this.m_buffer[n] = (byte)(this.m_buffer[n] | bv.m_buffer[i]);
            ++i;
        }
    }

    public void andNot(BitVector bv) {
        int i = 0;
        while (i < this.m_buffer.length) {
            int n = i;
            this.m_buffer[n] = (byte)(this.m_buffer[n] & ~bv.m_buffer[i]);
            ++i;
        }
    }

    public void not() {
        int i = 0;
        while (i < this.m_buffer.length) {
            this.m_buffer[i] = ~this.m_buffer[i];
            ++i;
        }
        if (this.m_lastMask != 0) {
            int n = this.m_buffer.length - 1;
            this.m_buffer[n] = (byte)(this.m_buffer[n] & this.m_lastMask);
        }
    }

    public void clearAll() {
        int i = 0;
        while (i < this.m_buffer.length) {
            this.m_buffer[i] = 0;
            ++i;
        }
    }

    public void setAll() {
        int i = 0;
        while (i < this.m_buffer.length) {
            this.m_buffer[i] = -1;
            ++i;
        }
    }

    public IntList getList() {
        IntList list = new IntList();
        int i = 0;
        while (i < this.m_buffer.length) {
            int j = i * 8;
            byte b = this.m_buffer[i];
            if (b != 0) {
                if ((b & 1) != 0) {
                    list.add(j + 0);
                }
                if ((b & 2) != 0) {
                    list.add(j + 1);
                }
                if ((b & 4) != 0) {
                    list.add(j + 2);
                }
                if ((b & 8) != 0) {
                    list.add(j + 3);
                }
                if ((b & 0x10) != 0) {
                    list.add(j + 4);
                }
                if ((b & 0x20) != 0) {
                    list.add(j + 5);
                }
                if ((b & 0x40) != 0) {
                    list.add(j + 6);
                }
                if ((b & 0x80) != 0) {
                    list.add(j + 7);
                }
            }
            ++i;
        }
        list.shrinkToSize();
        return list;
    }
}

