/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.olap.search;

import com.dell.doradus.olap.collections.BdLongSet;

public class SortValue
implements Comparable<SortValue> {
    private boolean m_accending;
    private long[] m_values;
    private int m_count;

    public SortValue(boolean accending) {
        this.m_accending = accending;
        this.m_values = new long[10];
        this.m_count = 0;
    }

    public void set(BdLongSet values) {
        values.sort();
        this.m_count = Math.min(this.m_values.length, values.size());
        if (this.m_accending) {
            int i = 0;
            while (i < this.m_count) {
                this.m_values[i] = values.get(i);
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.m_count) {
                this.m_values[i] = values.get(values.size() - i - 1);
                ++i;
            }
        }
    }

    @Override
    public int compareTo(SortValue other) {
        if (this.m_accending != other.m_accending) {
            throw new RuntimeException("Invalid sort order");
        }
        int minCount = Math.min(this.m_count, other.m_count);
        int c = 0;
        int i = 0;
        while (i < minCount) {
            int n = this.m_values[i] > other.m_values[i] ? 1 : (c = this.m_values[i] < other.m_values[i] ? -1 : 0);
            if (c != 0) {
                return this.m_accending ? c : -c;
            }
            ++i;
        }
        c = this.m_count > other.m_count ? 1 : (this.m_count < other.m_count ? -1 : 0);
        return this.m_accending ? c : -c;
    }
}

