/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.olap.search;

import com.dell.doradus.common.ApplicationDefinition;
import com.dell.doradus.common.TableDefinition;
import com.dell.doradus.olap.Olap;
import com.dell.doradus.olap.OlapQuery;
import com.dell.doradus.olap.io.FileDeletedException;
import com.dell.doradus.olap.merge.MergeResult;
import com.dell.doradus.olap.search.MetricsInSearch;
import com.dell.doradus.olap.search.Result;
import com.dell.doradus.olap.search.ResultBuilder;
import com.dell.doradus.olap.search.SearchResultBuilder;
import com.dell.doradus.olap.store.CubeSearcher;
import com.dell.doradus.olap.xlink.XLinkContext;
import com.dell.doradus.search.FieldSet;
import com.dell.doradus.search.SearchResult;
import com.dell.doradus.search.SearchResultList;
import com.dell.doradus.search.aggregate.SortOrder;
import com.dell.doradus.search.parser.AggregationQueryBuilder;
import com.dell.doradus.search.parser.DoradusQueryBuilder;
import com.dell.doradus.search.query.AndQuery;
import com.dell.doradus.search.query.IdRangeQuery;
import com.dell.doradus.search.query.Query;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Searcher {
    private static Logger LOG = LoggerFactory.getLogger((String)"Olap.Searcher");

    public static SearchResultList search(Olap olap, ApplicationDefinition appDef, String table, OlapQuery olapQuery) {
        SearchResultList result;
        olapQuery.fixPairParameter();
        TableDefinition tableDef = appDef.getTableDef(table);
        String application = appDef.getAppName();
        if (tableDef == null) {
            throw new IllegalArgumentException("Table " + table + " does not exist");
        }
        Query query = DoradusQueryBuilder.Build(olapQuery.getQuery(), tableDef);
        if (olapQuery.getContinueAfter() != null) {
            query = new AndQuery(new IdRangeQuery(olapQuery.getContinueAfter(), false, null, false), query);
        }
        if (olapQuery.getContinueAt() != null) {
            query = new AndQuery(new IdRangeQuery(olapQuery.getContinueAt(), true, null, false), query);
        }
        FieldSet fieldSet = new FieldSet(tableDef, olapQuery.getFieldSet());
        fieldSet.expand();
        SortOrder[] sortOrders = AggregationQueryBuilder.BuildSortOrders(olapQuery.getSortOrder(), tableDef);
        List<String> shardsList = olapQuery.getShards(appDef, olap);
        List<String> xshardsList = olapQuery.getXShards(appDef, olap);
        XLinkContext xcontext = new XLinkContext(application, olap, xshardsList, tableDef);
        xcontext.setupXLinkQuery(tableDef, query);
        SearchResultList searchResultList = result = Olap.getSearchThreadPool() == null ? Searcher.searchSinglethreaded(olap, appDef, shardsList, tableDef, query, fieldSet, olapQuery, sortOrders) : Searcher.searchMultithreaded(olap, appDef, shardsList, tableDef, query, fieldSet, olapQuery, sortOrders);
        if (olapQuery.getSkip() > 0) {
            int sz = result.results.size();
            result.results = new ArrayList<SearchResult>(result.results.subList(Math.min(olapQuery.getSkip(), sz), sz));
        }
        if (olapQuery.getMetrics() != null) {
            MetricsInSearch.addMetricsInSearch(olap, tableDef, result, olapQuery);
        }
        return result;
    }

    private static SearchResultList searchSinglethreaded(Olap olap, ApplicationDefinition appDef, List<String> shardsList, TableDefinition tableDef, Query query, FieldSet fieldSet, OlapQuery olapQuery, SortOrder[] sortOrders) {
        ArrayList<SearchResultList> results = new ArrayList<SearchResultList>();
        for (String shard : shardsList) {
            results.add(Searcher.search(olap, appDef, shard, tableDef, query, fieldSet, olapQuery, sortOrders));
        }
        SearchResultList result = MergeResult.merge(results, fieldSet);
        return result;
    }

    private static SearchResultList searchMultithreaded(Olap olap, ApplicationDefinition appDef, List<String> shardsList, TableDefinition tableDef, Query query, FieldSet fieldSet, OlapQuery olapQuery, SortOrder[] sortOrders) {
        try {
            final ArrayList<SearchResultList> results = new ArrayList<SearchResultList>();
            ArrayList futures = new ArrayList();
            for (String string : shardsList) {
                final Olap f_olap = olap;
                final ApplicationDefinition f_appDef = appDef;
                final String f_shard = string;
                final TableDefinition f_tableDef = tableDef;
                final Query f_query = query;
                final FieldSet f_fieldSet = fieldSet;
                final OlapQuery f_olapQuery = olapQuery;
                final SortOrder[] f_sortOrders = sortOrders;
                futures.add(Olap.getSearchThreadPool().submit(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        SearchResultList r = Searcher.search(f_olap, f_appDef, f_shard, f_tableDef, f_query, f_fieldSet, f_olapQuery, f_sortOrders);
                        List list = results;
                        synchronized (list) {
                            results.add(r);
                        }
                    }
                }));
            }
            for (Future future : futures) {
                future.get();
            }
            futures.clear();
            SearchResultList searchResultList = MergeResult.merge(results, fieldSet);
            return searchResultList;
        }
        catch (ExecutionException ee) {
            throw new RuntimeException(ee);
        }
        catch (InterruptedException ee) {
            throw new RuntimeException(ee);
        }
    }

    public static SearchResultList search(Olap olap, ApplicationDefinition appDef, String shard, TableDefinition tableDef, Query query, FieldSet fieldSet, OlapQuery olapQuery, SortOrder[] sortOrders) {
        int i = 0;
        while (i <= 2) {
            try {
                CubeSearcher s = olap.getSearcher(appDef, shard);
                SearchResultList result = Searcher.search(s, tableDef, query, fieldSet, olapQuery.getPageSizeWithSkip(), sortOrders);
                for (SearchResult sr : result.results) {
                    sr.scalars.put("_shard", shard);
                }
                return result;
            }
            catch (FileDeletedException ex) {
                LOG.warn(String.valueOf(ex.getMessage()) + " - retrying: " + i);
                ++i;
            }
        }
        CubeSearcher s = olap.getSearcher(appDef, shard);
        return Searcher.search(s, tableDef, query, fieldSet, olapQuery.getPageSizeWithSkip(), sortOrders);
    }

    public static SearchResultList search(CubeSearcher searcher, TableDefinition tableDef, Query query, FieldSet fieldSet, int size, SortOrder[] sortOrders) {
        Result documents = ResultBuilder.search(tableDef, query, searcher);
        SearchResultList list = SearchResultBuilder.build(searcher, documents, fieldSet, size, sortOrders);
        return list;
    }
}

