/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.olap.search;

import com.dell.doradus.common.FieldDefinition;
import com.dell.doradus.common.FieldType;
import com.dell.doradus.olap.search.FieldSetCreator;
import com.dell.doradus.olap.search.Result;
import com.dell.doradus.olap.search.SearchResultComparer;
import com.dell.doradus.olap.store.CubeSearcher;
import com.dell.doradus.olap.store.FieldSearcher;
import com.dell.doradus.olap.store.IdSearcher;
import com.dell.doradus.olap.store.IntIterator;
import com.dell.doradus.olap.store.NumSearcherMV;
import com.dell.doradus.olap.store.ValueSearcher;
import com.dell.doradus.search.FieldSet;
import com.dell.doradus.search.SearchResult;
import com.dell.doradus.search.SearchResultList;
import com.dell.doradus.search.aggregate.SortOrder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SearchResultBuilder {
    public static SearchResultList build(CubeSearcher searcher, Result documents, FieldSet fieldSet, int size, SortOrder[] orders) {
        if (size == 0) {
            size = Integer.MAX_VALUE;
        }
        fieldSet.limit = size;
        FieldSetCreator fieldSetCreator = new FieldSetCreator(searcher, fieldSet, orders);
        FVS fvs = new FVS();
        IntIterator documents_iter = SearchResultComparer.sort(searcher, documents, orders, size);
        IntIterator iter = new IntIterator();
        SearchResultBuilder.fill(searcher, documents_iter, fvs, fieldSetCreator, iter);
        fvs.resolve(searcher);
        SearchResultList list = new SearchResultList();
        list.documentsCount = documents.countSet();
        int doc = 0;
        while (doc < documents_iter.count()) {
            int d = documents_iter.get(doc);
            SearchResult child = SearchResultBuilder.build(searcher, d, fvs, fieldSetCreator, iter);
            child.orders = orders;
            list.results.add(child);
            ++doc;
        }
        Collections.sort(list.results);
        if (list.results.size() > size) {
            List<SearchResult> subList = list.results.subList(0, size);
            list.results = new ArrayList<SearchResult>(subList);
        }
        if (list.results.size() < list.documentsCount && list.results.size() > 0) {
            list.continuation_token = list.results.get(list.results.size() - 1).id();
        }
        return list;
    }

    private static void fill(CubeSearcher searcher, IntIterator documents, FVS fvs, FieldSetCreator fieldSetCreator, IntIterator iter) {
        String table = fieldSetCreator.tableDef.getTableName();
        fvs.add(table, "_ID", fieldSetCreator.filter, documents, fieldSetCreator.limit);
        block0: for (String string : fieldSetCreator.scalarFields) {
            FieldDefinition fieldDef = fieldSetCreator.tableDef.getFieldDef(string);
            if (fieldDef == null) {
                throw new IllegalArgumentException("Unknown field: " + string);
            }
            FieldType type = fieldDef.getType();
            if (type != FieldType.TEXT && type != FieldType.BINARY) continue;
            FieldSearcher field_searcher = searcher.getFieldSearcher(table, string);
            int num = 0;
            int doc = 0;
            while (doc < documents.count()) {
                if (num >= fieldSetCreator.limit) continue block0;
                int d = documents.get(doc);
                if (fieldSetCreator.filter == null || fieldSetCreator.filter.get(d)) {
                    field_searcher.fields(d, iter);
                    fvs.add(table, string, null, iter, Integer.MAX_VALUE);
                    ++num;
                }
                ++doc;
            }
        }
        for (Map.Entry entry : fieldSetCreator.links.entrySet()) {
            String link = (String)entry.getKey();
            List linkedSetList = (List)entry.getValue();
            block3: for (FieldSetCreator linkedSet : linkedSetList) {
                FieldSearcher field_searcher = searcher.getFieldSearcher(table, link);
                IntIterator iter2 = new IntIterator();
                int num = 0;
                int doc = 0;
                while (doc < documents.count()) {
                    if (num >= fieldSetCreator.limit) continue block3;
                    int d = documents.get(doc);
                    if (fieldSetCreator.filter == null || fieldSetCreator.filter.get(d)) {
                        field_searcher.fields(d, iter);
                        SearchResultBuilder.fill(searcher, iter, fvs, linkedSet, iter2);
                        ++num;
                    }
                    ++doc;
                }
            }
        }
    }

    private static SearchResult build(CubeSearcher searcher, int document, FVS fvs, FieldSetCreator fieldSetCreator, IntIterator iter) {
        SearchResult sr = new SearchResult();
        sr.fieldSet = fieldSetCreator.fieldSet;
        String table = fieldSetCreator.tableDef.getTableName();
        sr.scalars.put("_ID", fvs.get(table, "_ID", document));
        for (String string : fieldSetCreator.scalarFields) {
            String value;
            FieldDefinition fieldDef = fieldSetCreator.tableDef.getFieldDef(string);
            if (fieldDef == null) {
                throw new IllegalArgumentException("Unknown field: " + string);
            }
            FieldType type = fieldDef.getType();
            if (type == FieldType.TEXT || type == FieldType.BINARY) {
                FieldSearcher field_searcher = searcher.getFieldSearcher(table, string);
                field_searcher.fields(document, iter);
                if (iter.count() == 0) continue;
                value = "";
                int i = 0;
                while (i < iter.count()) {
                    if (value.length() > 0) {
                        value = String.valueOf(value) + "\ufffe";
                    }
                    value = String.valueOf(value) + fvs.get(table, string, iter.get(i));
                    ++i;
                }
                sr.scalars.put(string, value);
                continue;
            }
            if (NumSearcherMV.isNumericType(type)) {
                NumSearcherMV num_searcher = searcher.getNumSearcher(table, string);
                if (num_searcher.isNull(document)) continue;
                value = "";
                int size = num_searcher.size(document);
                if (size == 0) continue;
                int i = 0;
                while (i < size) {
                    if (value.length() > 0) {
                        value = String.valueOf(value) + "\ufffe";
                    }
                    value = String.valueOf(value) + NumSearcherMV.format(num_searcher.get(document, i), type);
                    ++i;
                }
                sr.scalars.put(string, value);
                continue;
            }
            throw new IllegalArgumentException("Invalid type: " + type + " for field " + string);
        }
        for (Map.Entry entry : fieldSetCreator.links.entrySet()) {
            String link = (String)entry.getKey();
            List linkedSetList = (List)entry.getValue();
            ArrayList<SearchResultList> childrenList = new ArrayList<SearchResultList>();
            sr.links.put(link, childrenList);
            for (FieldSetCreator linkedSet : linkedSetList) {
                FieldSearcher field_searcher = searcher.getFieldSearcher(table, link);
                IntIterator iter2 = new IntIterator();
                field_searcher.fields(document, iter);
                SearchResultList childList = new SearchResultList();
                int num = 0;
                int doc = 0;
                while (doc < iter.count()) {
                    if (num >= linkedSet.limit) break;
                    int d = iter.get(doc);
                    if (linkedSet.filter == null || linkedSet.filter.get(d)) {
                        SearchResult child = SearchResultBuilder.build(searcher, iter.get(doc), fvs, linkedSet, iter2);
                        childList.results.add(child);
                        ++num;
                    }
                    ++doc;
                }
                childrenList.add(childList);
            }
        }
        return sr;
    }

    static class FV {
        public String table;
        public String field;
        public Map<Integer, String> values = new HashMap<Integer, String>();

        public FV(String table, String field) {
            this.table = table;
            this.field = field;
        }

        public void add(int i) {
            this.values.put(i, null);
        }

        public String get(int i) {
            String val = this.values.get(i);
            return val;
        }

        public void resolve(CubeSearcher searcher) {
            if (this.field == "_ID") {
                IdSearcher id_searcher = searcher.getIdSearcher(this.table);
                ArrayList<Integer> li = new ArrayList<Integer>();
                li.addAll(this.values.keySet());
                Collections.sort(li);
                Iterator iterator = li.iterator();
                while (iterator.hasNext()) {
                    int i = (Integer)iterator.next();
                    this.values.put(i, id_searcher.getId(i).toString());
                }
            } else {
                ValueSearcher value_searcher = searcher.getValueSearcher(this.table, this.field);
                ArrayList<Integer> li = new ArrayList<Integer>();
                li.addAll(this.values.keySet());
                Collections.sort(li);
                Iterator iterator = li.iterator();
                while (iterator.hasNext()) {
                    int i = (Integer)iterator.next();
                    this.values.put(i, value_searcher.getValue(i).toString());
                }
            }
        }
    }

    static class FVS {
        public Map<String, FV> fvs = new HashMap<String, FV>();

        FVS() {
        }

        public String get(String table, String field, int term) {
            return this.fvs.get(String.valueOf(table) + "." + field).get(term);
        }

        public void add(String table, String field, Result filter, IntIterator terms, int size) {
            String key = String.valueOf(table) + "." + field;
            FV fv = this.fvs.get(key);
            if (fv == null) {
                fv = new FV(table, field);
                this.fvs.put(key, fv);
            }
            int num = 0;
            if (size < 0) {
                size = Integer.MAX_VALUE;
            }
            int i = 0;
            while (i < terms.count()) {
                if (num >= size) break;
                int t = terms.get(i);
                if (filter == null || filter.get(t)) {
                    fv.add(t);
                    ++num;
                }
                ++i;
            }
        }

        public void resolve(CubeSearcher searcher) {
            for (FV fv : this.fvs.values()) {
                fv.resolve(searcher);
            }
        }
    }
}

