/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.olap.search;

import com.dell.doradus.common.FieldDefinition;
import com.dell.doradus.common.FieldType;
import com.dell.doradus.common.TableDefinition;
import com.dell.doradus.common.Utils;
import com.dell.doradus.core.ServerConfig;
import com.dell.doradus.olap.io.BSTR;
import com.dell.doradus.olap.search.Result;
import com.dell.doradus.olap.store.CubeSearcher;
import com.dell.doradus.olap.store.FieldSearcher;
import com.dell.doradus.olap.store.IdSearcher;
import com.dell.doradus.olap.store.NumSearcherMV;
import com.dell.doradus.olap.store.ValueSearcher;
import com.dell.doradus.olap.xlink.XLinkContext;
import com.dell.doradus.olap.xlink.XLinkQuery;
import com.dell.doradus.search.filter.FilterContains;
import com.dell.doradus.search.query.AllQuery;
import com.dell.doradus.search.query.AndQuery;
import com.dell.doradus.search.query.BinaryQuery;
import com.dell.doradus.search.query.DatePartBinaryQuery;
import com.dell.doradus.search.query.FieldCountQuery;
import com.dell.doradus.search.query.FieldCountRangeQuery;
import com.dell.doradus.search.query.IdInQuery;
import com.dell.doradus.search.query.IdQuery;
import com.dell.doradus.search.query.IdRangeQuery;
import com.dell.doradus.search.query.LinkCountQuery;
import com.dell.doradus.search.query.LinkCountRangeQuery;
import com.dell.doradus.search.query.LinkIdQuery;
import com.dell.doradus.search.query.LinkQuery;
import com.dell.doradus.search.query.MVSBinaryQuery;
import com.dell.doradus.search.query.NoneQuery;
import com.dell.doradus.search.query.NotQuery;
import com.dell.doradus.search.query.OrQuery;
import com.dell.doradus.search.query.Query;
import com.dell.doradus.search.query.RangeQuery;
import com.dell.doradus.search.query.TransitiveLinkQuery;
import com.dell.doradus.search.util.LRUSizeCache;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.TimeZone;
import java.util.regex.Pattern;

public class ResultBuilder {
    private static int queryCache = -1;
    private static LRUSizeCache<String, Result> m_cache;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Result search(TableDefinition tableDef, Query query, CubeSearcher searcher) {
        Class<ResultBuilder> clazz = ResultBuilder.class;
        synchronized (ResultBuilder.class) {
            boolean skipCache;
            if (queryCache == -1 && (queryCache = ServerConfig.getInstance().olap_query_cache_size_mb) > 0) {
                m_cache = new LRUSizeCache(0, (long)queryCache * 1024L * 1024L);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            boolean bl = skipCache = m_cache == null || XLinkContext.isXLinkQuery(tableDef, query);
            if (skipCache) {
                return ResultBuilder.searchInternal(tableDef, query, searcher);
            }
            String key = String.valueOf(searcher.getId()) + "/" + tableDef.getTableName() + "/" + query.toString();
            Result result = m_cache.get(key);
            if (result != null) {
                Result newResult = new Result(result);
                return newResult;
            }
            result = ResultBuilder.searchInternal(tableDef, query, searcher);
            m_cache.put(key, result, result.getBitVector().getBuffer().length + 2 * key.length() + 16);
            Result newResult = new Result(result);
            return newResult;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Result searchInternal(TableDefinition tableDef, Query query, CubeSearcher searcher) {
        Result r = new Result(searcher.getDocs(tableDef.getTableName()));
        if (query instanceof AllQuery) {
            r.not();
            return r;
        } else if (query instanceof AndQuery) {
            r.not();
            for (Query qu : ((AndQuery)query).subqueries) {
                Result c = ResultBuilder.search(tableDef, qu, searcher);
                r.and(c);
            }
            return r;
        } else {
            if (query instanceof NoneQuery) return r;
            if (query instanceof OrQuery) {
                IdInQuery iiq = IdInQuery.tryCreate((OrQuery)query);
                if (iiq != null) {
                    return ResultBuilder.searchInternal(tableDef, iiq, searcher);
                }
                for (Query qu : ((OrQuery)query).subqueries) {
                    Result c = ResultBuilder.search(tableDef, qu, searcher);
                    r.or(c);
                }
                return r;
            } else if (query instanceof NotQuery) {
                r = ResultBuilder.search(tableDef, ((NotQuery)query).innerQuery, searcher);
                r.not();
                return r;
            } else if (query instanceof IdInQuery) {
                IdInQuery iiq = (IdInQuery)query;
                ArrayList<BSTR> ids = new ArrayList<BSTR>(iiq.ids.size());
                for (String id : iiq.ids) {
                    ids.add(new BSTR(id));
                }
                Collections.sort(ids);
                IdSearcher id_searcher = searcher.getIdSearcher(tableDef.getTableName());
                id_searcher.reset();
                for (BSTR id : ids) {
                    int doc = id_searcher.findNext(id);
                    if (doc < 0) continue;
                    r.set(doc);
                }
                return r;
            } else if (query instanceof BinaryQuery) {
                BinaryQuery bq = (BinaryQuery)query;
                String field = bq.field;
                String value = bq.value;
                if (field == null && "*".equals(value)) {
                    r.not();
                    return r;
                }
                if (field == null || "*".equals(field)) {
                    throw new IllegalArgumentException("All-fields search not supported");
                }
                FieldDefinition f = tableDef.getFieldDef(field);
                if (f == null) {
                    throw new IllegalArgumentException("Field '" + field + "' not found");
                }
                if (f.getType() == FieldType.TEXT) {
                    if (value == null) {
                        FieldSearcher field_searcher = searcher.getFieldSearcher(tableDef.getTableName(), field);
                        field_searcher.fillCount(0, 1, r);
                        return r;
                    }
                    if ("*".equals(value)) {
                        FieldSearcher field_searcher = searcher.getFieldSearcher(tableDef.getTableName(), field);
                        field_searcher.fillCount(0, 1, r);
                        r.not();
                        return r;
                    }
                    value = value.toLowerCase();
                    ValueSearcher vs = searcher.getValueSearcher(tableDef.getTableName(), field);
                    if (bq.operation.equals(BinaryQuery.EQUALS)) {
                        int idx = value.indexOf(42);
                        int idx2 = value.indexOf(63);
                        if (idx < 0) {
                            idx = idx2;
                        } else if (idx2 >= 0 && idx2 < idx) {
                            idx = idx2;
                        }
                        if (idx >= 0 && idx != value.length() - 1) {
                            Result vr = new Result(vs.size());
                            int i = 0;
                            while (i < vs.size()) {
                                String str = vs.getValue(i).toString();
                                if (Utils.matchesPattern((String)str, (String)value)) {
                                    vr.set(i);
                                }
                                ++i;
                            }
                            FieldSearcher field_searcher = searcher.getFieldSearcher(tableDef.getTableName(), field);
                            field_searcher.fillDocs(vr, r);
                            return r;
                        } else if (idx >= 0) {
                            value = value.substring(0, value.length() - 1);
                            BSTR term = new BSTR(value);
                            int term_min = vs.find(term, false);
                            term = new BSTR(String.valueOf(value) + "\uffff");
                            int term_max = vs.find(term, false);
                            FieldSearcher field_searcher = searcher.getFieldSearcher(tableDef.getTableName(), field);
                            field_searcher.fill(term_min, term_max, r);
                            return r;
                        } else {
                            BSTR term = new BSTR(value);
                            int term_no = vs.find(term, true);
                            if (term_no < 0) return r;
                            FieldSearcher field_searcher = searcher.getFieldSearcher(tableDef.getTableName(), field);
                            field_searcher.fill(term_no, r);
                        }
                        return r;
                    } else if (bq.operation.equals(BinaryQuery.CONTAINS)) {
                        Result vr = new Result(vs.size());
                        int i = 0;
                        while (i < vs.size()) {
                            String str = vs.getValue(i).toString();
                            if (FilterContains.compare(str, value)) {
                                vr.set(i);
                            }
                            ++i;
                        }
                        FieldSearcher field_searcher = searcher.getFieldSearcher(tableDef.getTableName(), field);
                        field_searcher.fillDocs(vr, r);
                        return r;
                    } else {
                        if (!bq.operation.equals(BinaryQuery.REGEXP)) throw new IllegalArgumentException(String.valueOf(bq.operation) + " is not supported");
                        Result vr = new Result(vs.size());
                        int i = 0;
                        while (i < vs.size()) {
                            String str = vs.getValue(i).toString();
                            if (Pattern.matches(value, str)) {
                                vr.set(i);
                            }
                            ++i;
                        }
                        FieldSearcher field_searcher = searcher.getFieldSearcher(tableDef.getTableName(), field);
                        field_searcher.fillDocs(vr, r);
                    }
                    return r;
                } else {
                    if (!NumSearcherMV.isNumericType(f.getType())) throw new IllegalArgumentException("Field type '" + f.getType() + "' not supported");
                    if (value == null) {
                        NumSearcherMV num_searcher = searcher.getNumSearcher(tableDef.getTableName(), field);
                        num_searcher.fillNull(r);
                        return r;
                    }
                    if ("*".equals(value)) {
                        NumSearcherMV num_searcher = searcher.getNumSearcher(tableDef.getTableName(), field);
                        num_searcher.fillNull(r);
                        r.not();
                        return r;
                    }
                    if (!bq.operation.equals(BinaryQuery.EQUALS)) {
                        throw new IllegalArgumentException("Contains is not supported for numeric types");
                    }
                    if (value.indexOf(42) >= 0 || value.indexOf(63) >= 0) {
                        throw new IllegalArgumentException("Wildcard search not supported for numeric types");
                    }
                    NumSearcherMV num_searcher = searcher.getNumSearcher(tableDef.getTableName(), field);
                    num_searcher.fill(NumSearcherMV.parse(value, f.getType()), r);
                }
                return r;
            } else if (query instanceof MVSBinaryQuery) {
                MVSBinaryQuery mvs = (MVSBinaryQuery)query;
                BinaryQuery bq = mvs.innerQuery;
                String field = bq.field;
                String value = bq.value;
                if (field == null && "*".equals(value)) {
                    r.not();
                    return r;
                }
                if (field == null || "*".equals(field)) {
                    throw new IllegalArgumentException("All-fields search not supported");
                }
                FieldDefinition f = tableDef.getFieldDef(field);
                if (f == null) {
                    throw new IllegalArgumentException("Field '" + field + "' not found");
                }
                if (f.getType() == FieldType.TEXT) {
                    if (value == null) {
                        FieldSearcher field_searcher = searcher.getFieldSearcher(tableDef.getTableName(), field);
                        field_searcher.fillCount(0, 1, r);
                        return r;
                    }
                    if ("*".equals(value)) {
                        FieldSearcher field_searcher = searcher.getFieldSearcher(tableDef.getTableName(), field);
                        field_searcher.fillCount(0, 1, r);
                        r.not();
                        return r;
                    }
                    value = value.toLowerCase();
                    ValueSearcher vs = searcher.getValueSearcher(tableDef.getTableName(), field);
                    if (bq.operation.equals(BinaryQuery.EQUALS)) {
                        int idx = value.indexOf(42);
                        int idx2 = value.indexOf(63);
                        if (idx < 0) {
                            idx = idx2;
                        } else if (idx2 >= 0 && idx2 < idx) {
                            idx = idx2;
                        }
                        if (idx >= 0 && idx != value.length() - 1) {
                            Result vr = new Result(vs.size());
                            int i = 0;
                            while (i < vs.size()) {
                                String str = vs.getValue(i).toString();
                                if (Utils.matchesPattern((String)str, (String)value)) {
                                    vr.set(i);
                                }
                                ++i;
                            }
                            if (LinkQuery.ALL.equals(mvs.quantifier)) {
                                vr.not();
                            }
                            FieldSearcher field_searcher = searcher.getFieldSearcher(tableDef.getTableName(), field);
                            field_searcher.fillDocs(vr, r);
                            if (LinkQuery.ALL.equals(mvs.quantifier)) {
                                Result noValues = new Result(r.size());
                                field_searcher.fillCount(0, 1, noValues);
                                r.or(noValues);
                            }
                        } else if (idx >= 0) {
                            value = value.substring(0, value.length() - 1);
                            BSTR term = new BSTR(value);
                            int term_min = vs.find(term, false);
                            term = new BSTR(String.valueOf(value) + "\uffff");
                            int term_max = vs.find(term, false);
                            FieldSearcher field_searcher = searcher.getFieldSearcher(tableDef.getTableName(), field);
                            if (LinkQuery.ALL.equals(mvs.quantifier)) {
                                field_searcher.fill(Integer.MIN_VALUE, term_min, r);
                                field_searcher.fill(term_max, Integer.MAX_VALUE, r);
                            } else {
                                field_searcher.fill(term_min, term_max, r);
                            }
                        } else {
                            BSTR term = new BSTR(value);
                            int term_no = vs.find(term, true);
                            if (term_no >= 0) {
                                FieldSearcher field_searcher = searcher.getFieldSearcher(tableDef.getTableName(), field);
                                if (LinkQuery.ALL.equals(mvs.quantifier)) {
                                    field_searcher.fill(Integer.MIN_VALUE, term_no, r);
                                    field_searcher.fill(term_no + 1, Integer.MAX_VALUE, r);
                                    Result noValues = new Result(r.size());
                                    field_searcher.fillCount(0, 1, r);
                                    r.or(noValues);
                                } else {
                                    field_searcher.fill(term_no, r);
                                }
                            } else if (LinkQuery.ALL.equals(mvs.quantifier)) {
                                r.not();
                            }
                        }
                    } else if (bq.operation.equals(BinaryQuery.CONTAINS)) {
                        Result vr = new Result(vs.size());
                        int i = 0;
                        while (i < vs.size()) {
                            String str = vs.getValue(i).toString();
                            if (FilterContains.compare(str, value)) {
                                vr.set(i);
                            }
                            ++i;
                        }
                        if (LinkQuery.ALL.equals(mvs.quantifier)) {
                            vr.not();
                        }
                        FieldSearcher field_searcher = searcher.getFieldSearcher(tableDef.getTableName(), field);
                        field_searcher.fillDocs(vr, r);
                        if (LinkQuery.ALL.equals(mvs.quantifier)) {
                            Result noValues = new Result(r.size());
                            field_searcher.fillCount(0, 1, r);
                            r.or(noValues);
                        }
                    } else {
                        if (!bq.operation.equals(BinaryQuery.REGEXP)) throw new IllegalArgumentException(String.valueOf(bq.operation) + " is not supported");
                        Result vr = new Result(vs.size());
                        int i = 0;
                        while (i < vs.size()) {
                            String str = vs.getValue(i).toString();
                            if (Pattern.matches(value, str)) {
                                vr.set(i);
                            }
                            ++i;
                        }
                        if (LinkQuery.ALL.equals(mvs.quantifier)) {
                            vr.not();
                        }
                        FieldSearcher field_searcher = searcher.getFieldSearcher(tableDef.getTableName(), field);
                        field_searcher.fillDocs(vr, r);
                        if (LinkQuery.ALL.equals(mvs.quantifier)) {
                            Result noValues = new Result(r.size());
                            field_searcher.fillCount(0, 1, r);
                            r.or(noValues);
                        }
                    }
                } else {
                    if (!NumSearcherMV.isNumericType(f.getType())) throw new IllegalArgumentException("Field type '" + f.getType() + "' not supported");
                    if (value == null) {
                        NumSearcherMV num_searcher = searcher.getNumSearcher(tableDef.getTableName(), field);
                        num_searcher.fillNull(r);
                        return r;
                    }
                    if ("*".equals(value)) {
                        NumSearcherMV num_searcher = searcher.getNumSearcher(tableDef.getTableName(), field);
                        num_searcher.fillNull(r);
                        r.not();
                        return r;
                    }
                    if (LinkQuery.ANY.equals(mvs.quantifier)) {
                        return ResultBuilder.searchInternal(tableDef, mvs.innerQuery, searcher);
                    }
                    if (LinkQuery.NONE.equals(mvs.quantifier)) {
                        Result result = ResultBuilder.searchInternal(tableDef, mvs.innerQuery, searcher);
                        result.not();
                        return result;
                    }
                    if (LinkQuery.ALL.equals(mvs.quantifier)) {
                        Result result = ResultBuilder.searchInternal(tableDef, mvs.innerQuery, searcher);
                        NumSearcherMV ns = searcher.getNumSearcher(tableDef.getTableName(), field);
                        Result countOne = new Result(result.size());
                        ns.fillCount(1, 2, countOne);
                        result.and(countOne);
                        return result;
                    }
                }
                if (LinkQuery.ANY.equals(mvs.quantifier)) return r;
                r.not();
                return r;
            } else if (query instanceof LinkQuery) {
                LinkQuery lq = (LinkQuery)query;
                if (lq.xlink != null) {
                    ((XLinkQuery)((Object)lq.xlink)).search(searcher, r);
                    return r;
                }
                FieldDefinition field = tableDef.getFieldDef(lq.link);
                Utils.require((!field.isGroupField() ? 1 : 0) != 0, (String)"Group fields are not supported");
                Utils.require((boolean)field.isLinkField(), (String)(String.valueOf(lq.link) + " is not a link field"));
                TableDefinition extent = tableDef.getAppDef().getTableDef(field.getLinkExtent());
                Result inner = ResultBuilder.search(extent, lq.innerQuery, searcher);
                if (LinkQuery.ALL.equals(lq.quantifier)) {
                    inner.not();
                }
                Result filter = null;
                if (lq.filter != null) {
                    filter = ResultBuilder.search(extent, lq.filter, searcher);
                    inner.and(filter);
                }
                FieldSearcher field_searcher = searcher.getFieldSearcher(field.getLinkExtent(), field.getLinkInverse());
                field_searcher.fields(inner, r);
                if (!LinkQuery.ANY.equals(lq.quantifier)) {
                    r.not();
                }
                if (!LinkQuery.ALL.equals(lq.quantifier)) return r;
                inner.clear();
                inner.not();
                if (filter != null) {
                    inner.and(filter);
                }
                Result atLeastOne = new Result(r.size());
                field_searcher.fields(inner, atLeastOne);
                r.and(atLeastOne);
                return r;
            } else if (query instanceof RangeQuery) {
                RangeQuery rq = (RangeQuery)query;
                String field = rq.field;
                FieldDefinition f = tableDef.getFieldDef(field);
                if (f == null) {
                    throw new IllegalArgumentException("Field '" + field + "' not found");
                }
                if (f.getType() == FieldType.TEXT) {
                    BSTR term;
                    ValueSearcher vs;
                    int term_min;
                    String min;
                    String string = min = rq.min == null ? "" : rq.min.toLowerCase();
                    if (!rq.minInclusive) {
                        min = String.valueOf(min) + "\u0000";
                    }
                    if ((term_min = (vs = searcher.getValueSearcher(tableDef.getTableName(), field)).find(term = new BSTR(min), false)) < 0) {
                        term_min = vs.size();
                    }
                    int term_max = vs.size();
                    if (rq.max != null) {
                        String max = rq.max.toLowerCase();
                        if (rq.maxInclusive) {
                            max = String.valueOf(max) + "\u0000";
                        }
                        term = new BSTR(max);
                        term_max = vs.find(term, false);
                    }
                    FieldSearcher field_searcher = searcher.getFieldSearcher(tableDef.getTableName(), field);
                    field_searcher.fill(term_min, term_max, r);
                    return r;
                } else {
                    if (!NumSearcherMV.isNumericType(f.getType())) throw new IllegalArgumentException("Field type '" + f.getType() + "' not supported");
                    long min = Long.MIN_VALUE;
                    long max = Long.MAX_VALUE;
                    if (rq.min != null) {
                        min = NumSearcherMV.parse(rq.min, f.getType());
                    }
                    if (rq.max != null) {
                        max = NumSearcherMV.parse(rq.max, f.getType());
                    }
                    if (!rq.minInclusive) {
                        ++min;
                    }
                    if (rq.maxInclusive) {
                        ++max;
                    }
                    NumSearcherMV num_searcher = searcher.getNumSearcher(tableDef.getTableName(), field);
                    num_searcher.fill(min, max, r);
                }
                return r;
            } else {
                if (query instanceof TransitiveLinkQuery) {
                    TransitiveLinkQuery lq = (TransitiveLinkQuery)query;
                    if (LinkQuery.ALL.equals(lq.quantifier)) {
                        AndQuery q = new AndQuery();
                        LinkQuery clauseExists = new LinkQuery();
                        clauseExists.filter = lq.filter;
                        clauseExists.innerQuery = new AllQuery();
                        clauseExists.link = lq.link;
                        clauseExists.quantifier = LinkQuery.ANY;
                        TransitiveLinkQuery clauseEveryone = new TransitiveLinkQuery();
                        clauseEveryone.depth = lq.depth;
                        clauseEveryone.filter = lq.filter;
                        NotQuery nq = new NotQuery();
                        nq.innerQuery = lq.innerQuery;
                        clauseEveryone.innerQuery = nq;
                        clauseEveryone.link = lq.link;
                        clauseEveryone.quantifier = LinkQuery.ANY;
                        NotQuery negation = new NotQuery();
                        negation.innerQuery = clauseEveryone;
                        q.subqueries.add(clauseExists);
                        q.subqueries.add(negation);
                        return ResultBuilder.searchInternal(tableDef, q, searcher);
                    }
                    FieldDefinition field = tableDef.getFieldDef(lq.link);
                    int depth = lq.depth == 0 ? 100 : lq.depth;
                    TableDefinition extent = tableDef.getAppDef().getTableDef(field.getLinkExtent());
                    Result inner = ResultBuilder.search(extent, lq.getInnerQuery(), searcher);
                    FieldSearcher field_searcher = searcher.getFieldSearcher(field.getLinkExtent(), field.getLinkInverse());
                    Result iteration = new Result(r.size());
                    Result next_iteration = new Result(r.size());
                    field_searcher.fields(inner, iteration);
                    r.or(iteration);
                    int resultsCount = r.countSet();
                    while (--depth > 0) {
                        field_searcher.fields(iteration, next_iteration);
                        Result tmp = iteration;
                        iteration = next_iteration;
                        next_iteration = tmp;
                        r.or(iteration);
                        int nextCount = r.countSet();
                        if (resultsCount == nextCount) break;
                        resultsCount = nextCount;
                    }
                    if (lq.filter == null) return r;
                    Result filter = ResultBuilder.search(extent, lq.filter, searcher);
                    r.and(filter);
                    return r;
                }
                if (query instanceof IdQuery) {
                    BSTR id;
                    IdQuery iq = (IdQuery)query;
                    if ("*".equals(iq.id)) {
                        r.clear();
                        r.not();
                        return r;
                    }
                    IdSearcher id_searcher = searcher.getIdSearcher(tableDef.getTableName());
                    int doc = id_searcher.find(id = new BSTR(iq.id), true);
                    if (doc < 0) return r;
                    r.set(doc);
                    return r;
                } else {
                    if (query instanceof LinkIdQuery) {
                        LinkIdQuery lq = (LinkIdQuery)query;
                        if (lq.xlink != null) {
                            ((XLinkQuery)((Object)lq.xlink)).search(searcher, r);
                            return r;
                        }
                        if (lq.id == null) {
                            FieldDefinition f = tableDef.getFieldDef(lq.link);
                            if (f == null) {
                                throw new IllegalArgumentException("Link " + lq.link + " not found in table " + tableDef.getTableName());
                            }
                            FieldSearcher field_searcher = searcher.getFieldSearcher(f.getTableName(), f.getName());
                            field_searcher.fillCount(0, 1, r);
                            return r;
                        }
                        if ("*".equals(lq.id)) {
                            FieldDefinition f = tableDef.getFieldDef(lq.link);
                            if (f == null) {
                                throw new IllegalArgumentException("Link " + lq.link + " not found in table " + tableDef.getTableName());
                            }
                            FieldSearcher field_searcher = searcher.getFieldSearcher(f.getTableName(), f.getName());
                            field_searcher.fillCount(0, 1, r);
                            r.not();
                            return r;
                        }
                        LinkQuery linkq = new LinkQuery(lq.quantifier, lq.link, new IdQuery(lq.id));
                        return ResultBuilder.search(tableDef, linkq, searcher);
                    }
                    if (query instanceof LinkCountQuery) {
                        LinkCountQuery q = (LinkCountQuery)query;
                        if (q.xlink != null) {
                            ((XLinkQuery)((Object)q.xlink)).search(searcher, r);
                            return r;
                        }
                        FieldDefinition f = tableDef.getFieldDef(q.link);
                        Utils.require((f != null ? 1 : 0) != 0, (String)(String.valueOf(q.link) + " not found in " + tableDef.getTableName()));
                        Utils.require((boolean)f.isLinkField(), (String)(String.valueOf(q.link) + " is not a link field"));
                        FieldSearcher field_searcher = searcher.getFieldSearcher(f.getTableName(), f.getName());
                        if (q.filter != null) {
                            TableDefinition extent = tableDef.getAppDef().getTableDef(f.getLinkExtent());
                            Result filter = ResultBuilder.search(extent, q.filter, searcher);
                            field_searcher.fillCount(q.count, q.count + 1, filter, r);
                            return r;
                        } else {
                            field_searcher.fillCount(q.count, q.count + 1, r);
                        }
                        return r;
                    } else if (query instanceof LinkCountRangeQuery) {
                        int max;
                        LinkCountRangeQuery q = (LinkCountRangeQuery)query;
                        if (q.xlink != null) {
                            ((XLinkQuery)((Object)q.xlink)).search(searcher, r);
                            return r;
                        }
                        FieldDefinition f = tableDef.getFieldDef(q.link);
                        Utils.require((f != null ? 1 : 0) != 0, (String)(String.valueOf(q.link) + " not found in " + tableDef.getTableName()));
                        Utils.require((boolean)f.isLinkField(), (String)(String.valueOf(q.link) + " is not a link field"));
                        FieldSearcher field_searcher = searcher.getFieldSearcher(f.getTableName(), f.getName());
                        int min = q.range.min == null ? Integer.MIN_VALUE : Integer.parseInt(q.range.min);
                        int n = max = q.range.max == null ? Integer.MAX_VALUE : Integer.parseInt(q.range.max);
                        if (!q.range.minInclusive) {
                            ++min;
                        }
                        if (q.range.maxInclusive) {
                            ++max;
                        }
                        if (q.filter != null) {
                            TableDefinition extent = tableDef.getAppDef().getTableDef(f.getLinkExtent());
                            Result filter = ResultBuilder.search(extent, q.filter, searcher);
                            field_searcher.fillCount(min, max, filter, r);
                            return r;
                        } else {
                            field_searcher.fillCount(min, max, r);
                        }
                        return r;
                    } else if (query instanceof DatePartBinaryQuery) {
                        DatePartBinaryQuery dpq = (DatePartBinaryQuery)query;
                        int datePart = dpq.part;
                        BinaryQuery bq = dpq.innerQuery;
                        String field = bq.field;
                        String value = bq.value;
                        if (bq.operation != BinaryQuery.EQUALS) {
                            throw new IllegalArgumentException("Contains is not supported");
                        }
                        FieldDefinition f = tableDef.getFieldDef(field);
                        if (f == null) {
                            throw new IllegalArgumentException("Field '" + field + "' not found");
                        }
                        if (f.getType() != FieldType.TIMESTAMP) {
                            throw new IllegalArgumentException("Field '" + field + "' in DatePartBinaryQuery should be timestamp");
                        }
                        if (value.indexOf(42) >= 0 || value.indexOf(63) >= 0) {
                            throw new IllegalArgumentException("Wildcard search not supported for DatePartBinaryQuery");
                        }
                        int partValue = Integer.parseInt(value);
                        if (datePart == 2) {
                            --partValue;
                        }
                        NumSearcherMV num_searcher = searcher.getNumSearcher(tableDef.getTableName(), field);
                        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
                        int i = 0;
                        while (i < r.size()) {
                            int sz = num_searcher.size(i);
                            int j = 0;
                            while (j < sz) {
                                long millis = num_searcher.get(i, j);
                                if (millis != 0L) {
                                    cal.setTimeInMillis(millis);
                                    if (cal.get(datePart) == partValue) {
                                        r.set(i);
                                    }
                                }
                                ++j;
                            }
                            ++i;
                        }
                        return r;
                    } else if (query instanceof FieldCountQuery) {
                        FieldCountQuery q = (FieldCountQuery)query;
                        FieldDefinition f = tableDef.getFieldDef(q.field);
                        Utils.require((f != null ? 1 : 0) != 0, (String)(String.valueOf(q.field) + " not found in " + tableDef.getTableName()));
                        if (NumSearcherMV.isNumericType(f.getType())) {
                            NumSearcherMV num_searcher = searcher.getNumSearcher(f.getTableName(), f.getName());
                            num_searcher.fillCount(q.count, q.count + 1, r);
                            return r;
                        } else {
                            FieldSearcher field_searcher = searcher.getFieldSearcher(f.getTableName(), f.getName());
                            field_searcher.fillCount(q.count, q.count + 1, r);
                        }
                        return r;
                    } else if (query instanceof FieldCountRangeQuery) {
                        int max;
                        FieldCountRangeQuery q = (FieldCountRangeQuery)query;
                        FieldDefinition f = tableDef.getFieldDef(q.field);
                        Utils.require((f != null ? 1 : 0) != 0, (String)(String.valueOf(q.field) + " not found in " + tableDef.getTableName()));
                        int min = q.range.min == null ? Integer.MIN_VALUE : Integer.parseInt(q.range.min);
                        int n = max = q.range.max == null ? Integer.MAX_VALUE : Integer.parseInt(q.range.max);
                        if (!q.range.minInclusive) {
                            ++min;
                        }
                        if (q.range.maxInclusive) {
                            ++max;
                        }
                        if (NumSearcherMV.isNumericType(f.getType())) {
                            NumSearcherMV num_searcher = searcher.getNumSearcher(f.getTableName(), f.getName());
                            num_searcher.fillCount(min, max, r);
                            return r;
                        } else {
                            FieldSearcher field_searcher = searcher.getFieldSearcher(f.getTableName(), f.getName());
                            field_searcher.fillCount(min, max, r);
                        }
                        return r;
                    } else {
                        BSTR term;
                        IdSearcher idSearcher;
                        int term_min;
                        String min;
                        if (!(query instanceof IdRangeQuery)) throw new IllegalArgumentException("Query " + query.getClass().getSimpleName() + " not supported");
                        IdRangeQuery rq = (IdRangeQuery)query;
                        String string = min = rq.min == null ? "" : rq.min;
                        if (!rq.minInclusive) {
                            min = String.valueOf(min) + "\u0000";
                        }
                        if ((term_min = (idSearcher = searcher.getIdSearcher(tableDef.getTableName())).find(term = new BSTR(min), false)) < 0) {
                            term_min = idSearcher.size();
                        }
                        int term_max = idSearcher.size();
                        if (rq.max != null) {
                            String max = rq.max;
                            if (rq.maxInclusive) {
                                max = String.valueOf(max) + "\u0000";
                            }
                            term = new BSTR(max);
                            term_max = idSearcher.find(term, false);
                        }
                        int i = term_min;
                        while (i < term_max) {
                            r.set(i);
                            ++i;
                        }
                    }
                }
            }
        }
        return r;
    }
}

