/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.olap.search;

import com.dell.doradus.common.AggregateResult;
import com.dell.doradus.common.TableDefinition;
import com.dell.doradus.olap.Olap;
import com.dell.doradus.olap.OlapAggregate;
import com.dell.doradus.olap.OlapQuery;
import com.dell.doradus.olap.aggregate.AggregateResultConverter;
import com.dell.doradus.olap.aggregate.AggregationResult;
import com.dell.doradus.search.SearchResult;
import com.dell.doradus.search.SearchResultList;
import java.util.HashMap;

public class MetricsInSearch {
    public static void addMetricsInSearch(Olap olap, TableDefinition tableDef, SearchResultList result, OlapQuery olapQuery) {
        if (olapQuery.getMetrics() == null) {
            return;
        }
        if (result.results.size() == 0) {
            return;
        }
        StringBuilder ids = new StringBuilder();
        for (SearchResult r : result.results) {
            ids.append("'");
            ids.append(r.id().replace("'", "'"));
            ids.append("'");
            ids.append(",");
        }
        ids.setLength(ids.length() - 1);
        String query = "(" + olapQuery.getOriginalQuery() + ") AND _ID IN(" + ids.toString() + ")";
        OlapAggregate aggregate = new OlapAggregate("x", query, "_ID", olapQuery.getMetrics(), olapQuery.getPair());
        aggregate.setShards(olapQuery.getShards(), olapQuery.getShardsRange());
        aggregate.setXShards(olapQuery.getXShards(), olapQuery.getXShardsRange());
        AggregationResult aresult = olap.aggregate(tableDef.getAppDef(), tableDef.getTableName(), aggregate);
        AggregateResult r = AggregateResultConverter.create(aresult, aggregate);
        for (AggregateResult.AggGroupSet groupSet : r.getGroupsets()) {
            HashMap<String, String> values = new HashMap<String, String>();
            String metricName = groupSet.getMetricParam();
            for (AggregateResult.AggGroup group : groupSet.getGroups()) {
                values.put(group.getFieldValue(), group.getGroupValue());
            }
            for (SearchResult sr : result.results) {
                String value = (String)values.get(sr.id());
                if (value == null) continue;
                sr.scalars.put(metricName, value);
            }
        }
    }
}

