/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.olap.search;

import com.dell.doradus.common.TableDefinition;
import com.dell.doradus.olap.search.Result;
import com.dell.doradus.olap.search.ResultBuilder;
import com.dell.doradus.olap.store.CubeSearcher;
import com.dell.doradus.search.FieldSet;
import com.dell.doradus.search.aggregate.SortOrder;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;

public class FieldSetCreator {
    public int limit;
    public Result filter;
    public SortOrder[] orders;
    public TableDefinition tableDef;
    public List<String> scalarFields;
    public TreeMap<String, List<FieldSetCreator>> links = new TreeMap();
    public FieldSet fieldSet;

    public FieldSetCreator(CubeSearcher searcher, FieldSet fieldSet, SortOrder[] orders) {
        this.tableDef = fieldSet.tableDef;
        this.limit = fieldSet.limit;
        if (this.limit == -1) {
            this.limit = Integer.MAX_VALUE;
        }
        this.scalarFields = fieldSet.ScalarFields;
        this.orders = orders;
        this.fieldSet = fieldSet;
        if (fieldSet.filter != null) {
            this.filter = ResultBuilder.search(this.tableDef, fieldSet.filter, searcher);
        }
        for (String linkName : fieldSet.getLinks()) {
            List<FieldSet> linkSetList = fieldSet.getLinks(linkName);
            ArrayList<FieldSetCreator> creatorList = new ArrayList<FieldSetCreator>();
            this.links.put(linkName, creatorList);
            for (FieldSet linkSet : linkSetList) {
                creatorList.add(new FieldSetCreator(searcher, linkSet, null));
            }
        }
    }
}

