/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.olap.merge;

import com.dell.doradus.common.TableDefinition;
import com.dell.doradus.olap.Olap;
import com.dell.doradus.olap.io.BSTR;
import com.dell.doradus.olap.io.FileDeletedException;
import com.dell.doradus.olap.store.IdReader;
import com.dell.doradus.service.olap.OLAPService;

public class RestorableIxDoc
implements Comparable<RestorableIxDoc> {
    private Olap m_olap = OLAPService.instance().getOlap();
    private String m_shard;
    private TableDefinition m_tableDef;
    public int segment;
    public IdReader reader;
    public BSTR id;

    public RestorableIxDoc(int segment, TableDefinition tableDef, String shard) {
        this.m_shard = shard;
        this.m_tableDef = tableDef;
        this.segment = segment;
        this.reader = new IdReader(this.m_olap.getDirectory(this.m_tableDef.getAppDef(), this.m_shard), this.m_tableDef.getTableName());
    }

    public void next() {
        try {
            this.nextInternal();
        }
        catch (FileDeletedException e) {
            this.reader = new IdReader(this.m_olap.getDirectory(this.m_tableDef.getAppDef(), this.m_shard), this.m_tableDef.getTableName());
            this.scanToNext();
        }
    }

    private void nextInternal() {
        this.id = this.reader.next() ? this.reader.cur_id : null;
    }

    private void scanToNext() {
        if (this.id == null) {
            this.id = this.reader.next() ? this.reader.cur_id : null;
            return;
        }
        while (this.reader.next()) {
            if (this.reader.cur_id.compareTo(this.id) <= 0) continue;
            this.id = this.reader.cur_id;
            return;
        }
        this.id = null;
    }

    @Override
    public int compareTo(RestorableIxDoc other) {
        if (this.id == other.id) {
            return 0;
        }
        if (this.id == null) {
            return -1;
        }
        if (other.id == null) {
            return 1;
        }
        int c = other.id.compareTo(this.id);
        if (c != 0) {
            return c;
        }
        return other.segment - this.segment;
    }
}

