/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.olap.merge;

import com.dell.doradus.olap.store.IntList;

public class Remap {
    private IntList[] m_maps;
    private int m_dstSize = -1;

    public Remap(int count) {
        this.m_maps = new IntList[count];
        int i = 0;
        while (i < count) {
            this.m_maps[i] = new IntList();
            ++i;
        }
    }

    public void set(int segment, int srcDoc, int dstDoc) {
        IntList list = this.m_maps[segment];
        if (list.size() == srcDoc + 1) {
            if (list.get(srcDoc) != dstDoc) {
                throw new RuntimeException("Map " + segment + " has last number " + list.get(segment) + "; required " + dstDoc);
            }
            return;
        }
        if (list.size() != srcDoc) {
            throw new RuntimeException("Map " + segment + " has " + list.size() + " elements; required " + srcDoc);
        }
        list.add(dstDoc);
    }

    public void setDeleted(int segment, int srcDoc, int dstDoc) {
        while (segment >= 0) {
            IntList list = this.m_maps[segment];
            int len = list.size();
            if (len != 0 && list.get(len - 1) == dstDoc) {
                list.set(len - 1, -1);
            }
            --segment;
        }
    }

    public int segmentsCount() {
        return this.m_maps.length;
    }

    public int get(int segment, int doc) {
        return this.m_maps[segment].get(doc);
    }

    public int size(int segment) {
        return this.m_maps[segment].size();
    }

    public int dstSize() {
        if (this.m_dstSize >= 0) {
            return this.m_dstSize;
        }
        int lastDoc = -1;
        int i = 0;
        while (i < this.m_maps.length) {
            IntList map = this.m_maps[i];
            int len = map.size();
            while (len > 0) {
                int doc;
                if ((doc = map.get(--len)) < 0) continue;
                if (lastDoc >= doc) break;
                lastDoc = doc;
                break;
            }
            ++i;
        }
        this.m_dstSize = lastDoc + 1;
        return this.m_dstSize;
    }

    public void shrink() {
        IntList[] intListArray = this.m_maps;
        int n = this.m_maps.length;
        int n2 = 0;
        while (n2 < n) {
            IntList list = intListArray[n2];
            list.shrinkToSize();
            ++n2;
        }
    }
}

