/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.olap.merge;

import com.dell.doradus.common.ApplicationDefinition;
import com.dell.doradus.common.FieldDefinition;
import com.dell.doradus.common.FieldType;
import com.dell.doradus.common.TableDefinition;
import com.dell.doradus.core.ServerConfig;
import com.dell.doradus.olap.io.VDirectory;
import com.dell.doradus.olap.merge.IxDoc;
import com.dell.doradus.olap.merge.IxNum;
import com.dell.doradus.olap.merge.IxTerm;
import com.dell.doradus.olap.merge.IxVal;
import com.dell.doradus.olap.merge.Remap;
import com.dell.doradus.olap.store.FieldSearcher;
import com.dell.doradus.olap.store.FieldWriter;
import com.dell.doradus.olap.store.FieldWriterSV;
import com.dell.doradus.olap.store.IdReader;
import com.dell.doradus.olap.store.IdWriter;
import com.dell.doradus.olap.store.InverseLinkWriter;
import com.dell.doradus.olap.store.NumSearcherMV;
import com.dell.doradus.olap.store.NumWriter;
import com.dell.doradus.olap.store.NumWriterMV;
import com.dell.doradus.olap.store.SegmentStats;
import com.dell.doradus.olap.store.ValueReader;
import com.dell.doradus.olap.store.ValueWriter;
import com.dell.doradus.search.util.HeapList;
import com.dell.doradus.utilities.Timer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Merger {
    private static Logger LOG = LoggerFactory.getLogger((String)"Olap.Merger");
    private static ExecutorService executor = ServerConfig.getInstance().olap_merge_threads == 0 ? null : Executors.newFixedThreadPool(ServerConfig.getInstance().olap_merge_threads);
    private ApplicationDefinition appDef;
    private List<VDirectory> sources;
    private VDirectory destination;
    private SegmentStats stats;
    private Map<String, Remap> remaps = new HashMap<String, Remap>();
    private Object m_syncRoot = new Object();

    public static void mergeApplication(ApplicationDefinition appDef, List<VDirectory> sources, VDirectory destination) {
        Merger m = new Merger(appDef, sources, destination);
        if (executor != null) {
            m.mergeApplicationWithThreadPool();
        } else {
            m.mergeApplication();
        }
    }

    public Merger(ApplicationDefinition appDef, List<VDirectory> sources, VDirectory destination) {
        this.appDef = appDef;
        this.sources = sources;
        this.destination = destination;
    }

    public void mergeApplicationWithThreadPool() {
        try {
            Timer timer = new Timer();
            LOG.debug("Merging application {}", (Object)this.appDef.getAppName());
            this.stats = new SegmentStats();
            ArrayList futures = new ArrayList();
            Iterator<Object> i$ = this.appDef.getTableDefinitions().values().iterator();
            while (i$.hasNext()) {
                TableDefinition tableDefinition;
                final TableDefinition fTableDef = tableDefinition = (TableDefinition)i$.next();
                final String table = tableDefinition.getTableName();
                futures.add(executor.submit(new Runnable(){

                    @Override
                    public void run() {
                        LOG.debug("   Merging {}", (Object)table);
                        Merger.this.mergeDocs(fTableDef);
                    }
                }));
            }
            for (Future future : futures) {
                future.get();
            }
            futures.clear();
            for (TableDefinition tableDefinition : this.appDef.getTableDefinitions().values()) {
                LOG.debug("   Merging fields of table {}", (Object)tableDefinition.getTableName());
                Iterator i$2 = tableDefinition.getFieldDefinitions().iterator();
                while (i$2.hasNext()) {
                    FieldDefinition fieldDef;
                    final FieldDefinition fFieldDef = fieldDef = (FieldDefinition)i$2.next();
                    futures.add(executor.submit(new Runnable(){

                        @Override
                        public void run() {
                            LOG.debug("      Merging {}/{} ({})", new Object[]{fFieldDef.getTableName(), fFieldDef.getName(), fFieldDef.getType()});
                            Merger.this.mergeField(fFieldDef);
                        }
                    }));
                }
            }
            for (Future future : futures) {
                future.get();
            }
            futures.clear();
            this.stats.totalStoreSize = this.destination.totalLength(false);
            this.stats.save(this.destination);
            LOG.debug("Application {} merged in {}", (Object)this.appDef.getAppName(), (Object)timer);
        }
        catch (ExecutionException ee) {
            throw new RuntimeException(ee);
        }
        catch (InterruptedException ee) {
            throw new RuntimeException(ee);
        }
    }

    public void mergeApplication() {
        String table;
        Timer timer = new Timer();
        LOG.debug("Merging application {}", (Object)this.appDef.getAppName());
        this.stats = new SegmentStats();
        for (TableDefinition tableDef : this.appDef.getTableDefinitions().values()) {
            table = tableDef.getTableName();
            LOG.debug("   Merging {}", (Object)table);
            this.mergeDocs(tableDef);
        }
        for (TableDefinition tableDef : this.appDef.getTableDefinitions().values()) {
            table = tableDef.getTableName();
            LOG.debug("   Merging fields of table {}", (Object)table);
            for (FieldDefinition fieldDef : tableDef.getFieldDefinitions()) {
                LOG.debug("      Merging {}/{} ({})", new Object[]{table, fieldDef.getName(), fieldDef.getType()});
                this.mergeField(fieldDef);
            }
        }
        this.stats.totalStoreSize = this.destination.totalLength(false);
        this.stats.save(this.destination);
        LOG.debug("Application {} merged in {}", (Object)this.appDef.getAppName(), (Object)timer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mergeDocs(TableDefinition tableDef) {
        String table = tableDef.getTableName();
        Remap remap = new Remap(this.sources.size());
        IdWriter id_writer = new IdWriter(this.destination, table);
        HeapList<IxDoc> heap = new HeapList<IxDoc>(this.sources.size() - 1);
        IxDoc current = null;
        for (int i = 0; i < this.sources.size(); ++i) {
            current = new IxDoc(i, new IdReader(this.sources.get(i), table));
            current.next();
            current = heap.AddEx(current);
        }
        while (current.id != null) {
            int dstDoc = id_writer.add(current.id);
            remap.set(current.segment, current.reader.cur_number, dstDoc);
            if (current.reader.is_deleted) {
                remap.setDeleted(current.segment, current.reader.cur_number, dstDoc);
                id_writer.removeLastId(current.id);
            }
            current.next();
            current = heap.AddEx(current);
        }
        remap.shrink();
        id_writer.close();
        Object object = this.m_syncRoot;
        synchronized (object) {
            this.stats.addTable(table, id_writer.size());
            this.remaps.put(table, remap);
        }
    }

    private void mergeField(FieldDefinition fieldDef) {
        if (fieldDef.getType() == FieldType.TEXT || fieldDef.getType() == FieldType.BINARY) {
            this.mergeTextField(fieldDef);
        } else if (fieldDef.isLinkField()) {
            this.mergeLinkField(fieldDef);
        } else if (NumSearcherMV.isNumericType(fieldDef.getType())) {
            this.mergeNumField(fieldDef);
        } else if (!fieldDef.isGroupField() && !fieldDef.isXLinkField()) {
            throw new RuntimeException("Unsupported field type: " + fieldDef.getType());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mergeNumField(FieldDefinition fieldDef) {
        String table = fieldDef.getTableName();
        String field = fieldDef.getName();
        Remap remap = this.remaps.get(table);
        if (remap.dstSize() == 0) {
            return;
        }
        if (fieldDef.isCollection()) {
            NumWriterMV num_writer = new NumWriterMV(remap.dstSize());
            HeapList<IxNum> heap = new HeapList<IxNum>(this.sources.size() - 1);
            IxNum current = null;
            for (int i = 0; i < this.sources.size(); ++i) {
                current = new IxNum(i, remap, new NumSearcherMV(this.sources.get(i), table, field));
                current.next();
                current = heap.AddEx(current);
            }
            while (current.doc != Integer.MAX_VALUE) {
                num_writer.add(current.doc, current.num);
                current.next();
                current = heap.AddEx(current);
            }
            num_writer.close(this.destination, table, field);
            this.stats.addNumField(fieldDef, num_writer);
        } else {
            NumWriter num_writer = new NumWriter(remap.dstSize());
            for (int i = 0; i < this.sources.size(); ++i) {
                NumSearcherMV num_searcher = new NumSearcherMV(this.sources.get(i), table, field);
                for (int j = 0; j < remap.size(i); ++j) {
                    int doc = remap.get(i, j);
                    if (doc < 0 || num_searcher.sv_isNull(j)) continue;
                    long d = num_searcher.sv_get(j);
                    num_writer.add(doc, d);
                }
            }
            num_writer.close(this.destination, table, field);
            Object object = this.m_syncRoot;
            synchronized (object) {
                this.stats.addNumField(fieldDef, num_writer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mergeTextField(FieldDefinition fieldDef) {
        Object field_writer;
        int i;
        String table = fieldDef.getTableName();
        String field = fieldDef.getName();
        Remap docRemap = this.remaps.get(table);
        if (docRemap.dstSize() == 0) {
            return;
        }
        Remap valRemap = new Remap(this.sources.size());
        ValueWriter value_writer = new ValueWriter(this.destination, table, field);
        HeapList<Comparable<IxTerm>> heap = new HeapList<Comparable<IxTerm>>(this.sources.size() - 1);
        Comparable<IxTerm> current = null;
        for (i = 0; i < this.sources.size(); ++i) {
            current = new IxTerm(i, new ValueReader(this.sources.get(i), table, field));
            ((IxTerm)current).next();
            current = heap.AddEx(current);
        }
        while (((IxTerm)current).term != null) {
            int dstVal = value_writer.add(((IxTerm)current).term, ((IxTerm)current).orig);
            valRemap.set(((IxTerm)current).segment, ((IxTerm)current).reader.cur_number, dstVal);
            ((IxTerm)current).next();
            current = heap.AddEx(current);
        }
        value_writer.close();
        if (fieldDef.isCollection()) {
            field_writer = new FieldWriter(docRemap.dstSize());
            heap = new HeapList(this.sources.size() - 1);
            current = null;
            for (i = 0; i < this.sources.size(); ++i) {
                current = new IxVal(i, docRemap, valRemap, new FieldSearcher(this.sources.get(i), table, field));
                ((IxVal)current).next();
                current = (IxVal)heap.AddEx(current);
            }
            while (((IxVal)current).doc != Integer.MAX_VALUE) {
                ((FieldWriter)field_writer).add(((IxVal)current).doc, ((IxVal)current).val);
                ((IxVal)current).next();
                current = (IxVal)((Object)heap.AddEx(current));
            }
            ((FieldWriter)field_writer).close(this.destination, table, field);
            Merger i2 = this;
            synchronized (i2) {
                this.stats.addTextField(fieldDef, (FieldWriter)field_writer);
            }
        }
        field_writer = new FieldWriterSV(docRemap.dstSize());
        for (int i3 = 0; i3 < this.sources.size(); ++i3) {
            FieldSearcher field_searcher = new FieldSearcher(this.sources.get(i3), table, field);
            for (int j = 0; j < docRemap.size(i3); ++j) {
                int d;
                int doc = docRemap.get(i3, j);
                if (doc < 0 || (d = field_searcher.sv_get(j)) < 0) continue;
                ((FieldWriterSV)field_writer).set(doc, valRemap.get(i3, d));
            }
        }
        ((FieldWriterSV)field_writer).close(this.destination, table, field);
        Merger merger = this;
        synchronized (merger) {
            this.stats.addTextField(fieldDef, (FieldWriterSV)field_writer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mergeLinkField(FieldDefinition fieldDef) {
        String table = fieldDef.getTableName();
        String link = fieldDef.getName();
        Remap docRemap = this.remaps.get(table);
        Remap valRemap = this.remaps.get(fieldDef.getLinkExtent());
        if (docRemap.dstSize() == 0 || valRemap.dstSize() == 0) {
            return;
        }
        if (InverseLinkWriter.shouldWriteInverse(fieldDef)) {
            InverseLinkWriter.writeInverse(this.destination, fieldDef, this.stats);
        } else {
            FieldWriter field_writer = new FieldWriter(docRemap.dstSize());
            HeapList<IxVal> heap = new HeapList<IxVal>(this.sources.size() - 1);
            IxVal current = null;
            for (int i = 0; i < this.sources.size(); ++i) {
                current = new IxVal(i, docRemap, valRemap, new FieldSearcher(this.sources.get(i), table, link));
                current.next();
                current = heap.AddEx(current);
            }
            while (current.doc != Integer.MAX_VALUE) {
                field_writer.add(current.doc, current.val);
                current.next();
                current = heap.AddEx(current);
            }
            field_writer.close(this.destination, table, link);
            Merger merger = this;
            synchronized (merger) {
                this.stats.addLinkField(fieldDef, field_writer);
            }
        }
    }
}

