/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.olap.merge;

import com.dell.doradus.olap.search.GroupCount;
import com.dell.doradus.olap.search.GroupResult;
import com.dell.doradus.search.FieldSet;
import com.dell.doradus.search.SearchResult;
import com.dell.doradus.search.SearchResultList;
import com.dell.doradus.search.util.HeapSort;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class MergeResult {
    public static GroupResult mergeGroups(List<GroupResult> results, int top) {
        if (results.size() == 1) {
            return results.get(0);
        }
        GroupResult groupResult = new GroupResult();
        groupResult.isSortByCount = top > 0;
        HeapSort<GroupCount> heapSort = new HeapSort<GroupCount>();
        for (GroupResult r : results) {
            groupResult.totalCount += r.totalCount;
            Collections.sort(r.groups);
            heapSort.add(r.groups);
        }
        GroupCount last = null;
        for (GroupCount c : heapSort) {
            if (last != null && last.name.equalsIgnoreCase(c.name)) {
                last.count += c.count;
                continue;
            }
            groupResult.groups.add(c);
            last = c;
        }
        groupResult.groupsCount = groupResult.groups.size();
        if (groupResult.isSortByCount) {
            Collections.sort(groupResult.groups, new Comparator<GroupCount>(){

                @Override
                public int compare(GroupCount x, GroupCount y) {
                    return y.count - x.count;
                }
            });
        }
        if (top > 0 && groupResult.groups.size() >= top) {
            groupResult.groups = groupResult.groups.subList(0, top);
        }
        return groupResult;
    }

    public static SearchResultList merge(List<SearchResultList> results, FieldSet fieldSet) {
        ArrayList<SearchResult> res;
        if (results.size() == 1) {
            return results.get(0);
        }
        SearchResultList searchResultList = new SearchResultList();
        searchResultList.documentsCount = 0;
        HeapSort<SearchResult> heapSort = new HeapSort<SearchResult>();
        for (SearchResultList s : results) {
            heapSort.add(s.results);
            searchResultList.documentsCount += s.documentsCount;
        }
        SearchResult last = null;
        ArrayList<SearchResult> list = new ArrayList<SearchResult>();
        for (SearchResult s : heapSort) {
            if (last == null || last != null && last.id().equals(s.id())) {
                list.add(s);
                last = s;
                continue;
            }
            if (searchResultList.results.size() >= fieldSet.limit) break;
            SearchResult merged = (SearchResult)list.get(list.size() - 1);
            searchResultList.results.add(merged);
            last = s;
            list.clear();
            list.add(s);
        }
        if (list.size() > 0 && searchResultList.results.size() < fieldSet.limit) {
            SearchResult merged = (SearchResult)list.get(0);
            searchResultList.results.add(merged);
        }
        if ((res = searchResultList.results).size() < searchResultList.documentsCount && res.size() > 0) {
            searchResultList.continuation_token = ((SearchResult)res.get(res.size() - 1)).id();
        }
        return searchResultList;
    }
}

