/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.olap.merge;

import com.dell.doradus.olap.merge.Remap;
import com.dell.doradus.olap.store.FieldSearcher;
import com.dell.doradus.olap.store.IntIterator;

public class IxVal
implements Comparable<IxVal> {
    public int segment;
    public int doc;
    public int val;
    private Remap docRemap;
    private Remap valRemap;
    private FieldSearcher searcher;
    private IntIterator iter = new IntIterator();
    private int nxt_doc;
    private int nxt_val;

    public IxVal(int segment, Remap docRemap, Remap valRemap, FieldSearcher searcher) {
        this.segment = segment;
        this.docRemap = docRemap;
        this.valRemap = valRemap;
        this.searcher = searcher;
    }

    public void next() {
        do {
            this.doNext();
        } while (this.doc != Integer.MAX_VALUE && this.val < 0);
    }

    private void doNext() {
        if (this.nxt_val < this.iter.count()) {
            int v = this.iter.get(this.nxt_val++);
            this.val = this.valRemap.get(this.segment, v);
            return;
        }
        this.nxt_val = 0;
        this.iter.setup(null, 0, 0);
        while (this.nxt_doc < this.searcher.size() && this.iter.count() == 0) {
            int d;
            ++this.nxt_doc;
            this.doc = this.docRemap.get(this.segment, d);
            if (this.doc < 0) continue;
            this.searcher.fields(d, this.iter);
        }
        if (this.iter.count() == 0) {
            this.doc = Integer.MAX_VALUE;
            this.val = 0;
            return;
        }
        int v = this.iter.get(this.nxt_val++);
        this.val = this.valRemap.get(this.segment, v);
    }

    @Override
    public int compareTo(IxVal other) {
        if (this.doc > other.doc) {
            return -1;
        }
        if (this.doc < other.doc) {
            return 1;
        }
        if (this.val != other.val) {
            return other.val - this.val;
        }
        return other.segment - this.segment;
    }
}

