/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.olap.io;

import com.dell.doradus.olap.io.BSTR;
import com.dell.doradus.olap.io.IBufferWriter;
import com.dell.doradus.olap.io.VDirectory;

public class VOutputStream {
    private IBufferWriter m_bufferWriter;
    private byte[] m_buffer = new byte[VDirectory.CHUNK_SIZE];
    private int m_buffersCount;
    private int m_positionInBuffer;
    private BSTR m_cur = new BSTR();

    public VOutputStream(IBufferWriter bufferWriter) {
        this.m_bufferWriter = bufferWriter;
        this.m_buffersCount = 0;
        this.m_positionInBuffer = 0;
    }

    public long position() {
        return this.m_buffersCount * this.m_buffer.length + this.m_positionInBuffer;
    }

    public void close() {
        long length = this.position();
        if (this.m_positionInBuffer != 0) {
            this.writeBuffer();
        }
        this.m_bufferWriter.close(length);
    }

    private void writeBuffer() {
        this.m_bufferWriter.writeBuffer(this.m_buffersCount, this.m_buffer, this.m_positionInBuffer);
        ++this.m_buffersCount;
        this.m_positionInBuffer = 0;
    }

    public void writeByte(byte value) {
        this.m_buffer[this.m_positionInBuffer++] = value;
        if (this.m_positionInBuffer == this.m_buffer.length) {
            this.writeBuffer();
        }
    }

    public void write(byte[] buffer, int offset, int count) {
        while (count > 0) {
            int toCopy = Math.min(this.m_buffer.length - this.m_positionInBuffer, count);
            System.arraycopy(buffer, offset, this.m_buffer, this.m_positionInBuffer, toCopy);
            this.m_positionInBuffer += toCopy;
            count -= toCopy;
            offset += toCopy;
            if (this.m_positionInBuffer != this.m_buffer.length) continue;
            this.writeBuffer();
        }
    }

    public void writeVInt(int value) {
        int u = value >>> 7;
        while (u != 0) {
            this.writeByte((byte)(value & 0x7F | 0x80));
            value = u;
            u >>>= 7;
        }
        this.writeByte((byte)value);
    }

    public void writeVLong(long value) {
        long u = value >>> 7;
        while (u != 0L) {
            this.writeByte((byte)(value & 0x7FL | 0x80L));
            value = u;
            u >>>= 7;
        }
        this.writeByte((byte)value);
    }

    public void writeShort(short value) {
        short u = value;
        this.writeByte((byte)u);
        u = (short)(u >>> 8);
        this.writeByte((byte)u);
    }

    public void writeInt(int value) {
        int u = value;
        this.writeByte((byte)u);
        this.writeByte((byte)(u >>>= 8));
        this.writeByte((byte)(u >>>= 8));
        this.writeByte((byte)(u >>>= 8));
    }

    public void writeLong(long value) {
        long u = value;
        this.writeByte((byte)u);
        this.writeByte((byte)(u >>>= 8));
        this.writeByte((byte)(u >>>= 8));
        this.writeByte((byte)(u >>>= 8));
        this.writeByte((byte)(u >>>= 8));
        this.writeByte((byte)(u >>>= 8));
        this.writeByte((byte)(u >>>= 8));
        this.writeByte((byte)(u >>>= 8));
        u >>>= 8;
    }

    public void write(BSTR bstr) {
        this.writeVInt(bstr.length);
        this.write(bstr.buffer, 0, bstr.length);
    }

    public void writeVString(BSTR bstr) {
        int pfx = 0;
        int len = Math.min(this.m_cur.length, bstr.length);
        while (pfx < len && this.m_cur.buffer[pfx] == bstr.buffer[pfx]) {
            ++pfx;
        }
        this.writeVInt(pfx);
        this.writeVInt(bstr.length - pfx);
        this.write(bstr.buffer, pfx, bstr.length - pfx);
        this.m_cur.assertLength(bstr.length);
        System.arraycopy(bstr.buffer, pfx, this.m_cur.buffer, pfx, bstr.length - pfx);
        this.m_cur.length = bstr.length;
    }

    public void writeString(String str) {
        BSTR bstr = new BSTR(str);
        this.write(bstr);
    }
}

