/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.olap.io;

import com.dell.doradus.olap.io.BSTR;
import com.dell.doradus.olap.io.IBufferReader;
import com.dell.doradus.olap.io.VDirectory;

public class VInputStream {
    private IBufferReader m_bufferReader;
    private long m_length;
    private int m_bufferSize = VDirectory.CHUNK_SIZE;
    private byte[] m_buffer;
    private int m_buffersCount;
    private int m_bufferNumber;
    private int m_bufferLength;
    private int m_positionInBuffer;

    public VInputStream(IBufferReader bufferReader, long length) {
        if (length < 0L) {
            throw new RuntimeException("Length<0");
        }
        this.m_bufferReader = bufferReader;
        this.m_length = length;
        this.m_buffersCount = (int)((this.m_length + (long)this.m_bufferSize - 1L) / (long)this.m_bufferSize);
        this.m_bufferNumber = -1;
        this.m_bufferLength = 0;
        this.m_positionInBuffer = 0;
    }

    public VInputStream(VInputStream stream) {
        this.m_bufferReader = stream.m_bufferReader;
        this.m_length = stream.m_length;
        this.m_bufferSize = stream.m_bufferSize;
        this.m_buffer = stream.m_buffer;
        this.m_buffersCount = stream.m_buffersCount;
        this.m_bufferNumber = stream.m_bufferNumber;
        this.m_bufferLength = stream.m_bufferLength;
        this.m_positionInBuffer = stream.m_positionInBuffer;
    }

    public long length() {
        return this.m_length;
    }

    public long position() {
        return this.m_bufferNumber < 0 ? 0 : this.m_bufferNumber * this.m_bufferSize + this.m_positionInBuffer;
    }

    public boolean end() {
        return this.m_positionInBuffer == this.m_bufferLength && this.m_bufferNumber == this.m_buffersCount - 1 || this.m_positionInBuffer == 0 && this.m_bufferNumber == this.m_buffersCount;
    }

    public void seek(long position) {
        if (position == this.m_length && this.m_length == (long)(this.m_buffersCount * this.m_bufferSize)) {
            this.m_positionInBuffer = 0;
            this.m_bufferLength = 0;
            this.m_bufferNumber = this.m_buffersCount;
        } else {
            int bufferNumber = (int)(position / (long)this.m_bufferSize);
            this.readBuffer(bufferNumber);
            this.m_positionInBuffer = (int)(position % (long)this.m_bufferSize);
            if (this.m_positionInBuffer > this.m_bufferLength) {
                throw new RuntimeException("End of stream");
            }
        }
    }

    private void readBuffer(int bufferNumber) {
        if (this.m_bufferNumber == bufferNumber) {
            return;
        }
        if (bufferNumber < 0 || bufferNumber >= this.m_buffersCount) {
            throw new RuntimeException("End of stream");
        }
        this.m_bufferNumber = bufferNumber;
        this.m_buffer = this.m_bufferReader.readBuffer(bufferNumber);
        this.m_bufferLength = this.m_buffer.length;
        this.m_positionInBuffer = 0;
    }

    public int read(byte[] buffer, int offset, int count) {
        int cnt = count;
        while (count > 0) {
            if (this.m_positionInBuffer == this.m_bufferLength) {
                this.readBuffer(this.m_bufferNumber + 1);
            }
            int toRead = Math.min(this.m_bufferLength - this.m_positionInBuffer, count);
            System.arraycopy(this.m_buffer, this.m_positionInBuffer, buffer, offset, toRead);
            count -= toRead;
            this.m_positionInBuffer += toRead;
            offset += toRead;
        }
        return cnt;
    }

    public int readByte() {
        if (this.m_positionInBuffer == this.m_bufferLength) {
            this.readBuffer(this.m_bufferNumber + 1);
        }
        return this.m_buffer[this.m_positionInBuffer++] & 0xFF;
    }

    public int readVInt() {
        int b = this.readByte();
        int u = b & 0x7F;
        int shift = 7;
        while (b > 127) {
            b = this.readByte();
            u += (b & 0x7F) << shift;
            shift += 7;
        }
        return u;
    }

    public long readVLong() {
        long b = this.readByte();
        long u = b & 0x7FL;
        int shift = 7;
        while (b > 127L) {
            b = this.readByte();
            u += (b & 0x7FL) << shift;
            shift += 7;
        }
        return u;
    }

    public short readShort() {
        int u = this.readByte() | this.readByte() << 8;
        return (short)u;
    }

    public int readInt() {
        int u = this.readByte() | this.readByte() << 8 | this.readByte() << 16 | this.readByte() << 24;
        return u;
    }

    public long readLong() {
        long u = (long)this.readByte() | (long)this.readByte() << 8 | (long)this.readByte() << 16 | (long)this.readByte() << 24 | (long)this.readByte() << 32 | (long)this.readByte() << 40 | (long)this.readByte() << 48 | (long)this.readByte() << 56;
        return u;
    }

    public void read(BSTR bstr) {
        bstr.length = this.readVInt();
        bstr.assertLength(bstr.length);
        this.read(bstr.buffer, 0, bstr.length);
    }

    public String readString() {
        int i = this.readVInt();
        byte[] b = new byte[i];
        this.read(b, 0, i);
        BSTR bstr = new BSTR(b);
        return bstr.toString();
    }

    public void readVString(BSTR bstr) {
        if (bstr.length < 0) {
            bstr.length = 0;
        }
        int pfx = this.readVInt();
        int len = this.readVInt();
        bstr.length = pfx + len;
        bstr.assertLength(bstr.length);
        this.read(bstr.buffer, pfx, len);
    }
}

